/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.huggingface.translator.CrossEncoderBatchTranslator;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.StringPair;
import java.io.IOException;
import java.util.Map;

public class CrossEncoderTranslator
implements Translator<StringPair, float[]> {
    private HuggingFaceTokenizer tokenizer;
    private boolean includeTokenTypes;
    private Batchifier batchifier;

    CrossEncoderTranslator(HuggingFaceTokenizer tokenizer, boolean includeTokenTypes, Batchifier batchifier) {
        this.tokenizer = tokenizer;
        this.includeTokenTypes = includeTokenTypes;
        this.batchifier = batchifier;
    }

    public Batchifier getBatchifier() {
        return this.batchifier;
    }

    public NDList processInput(TranslatorContext ctx, StringPair input) {
        Encoding encoding = this.tokenizer.encode((String)input.getKey(), (String)input.getValue());
        ctx.setAttachment("encoding", (Object)encoding);
        return encoding.toNDList(ctx.getNDManager(), this.includeTokenTypes);
    }

    public float[] processOutput(TranslatorContext ctx, NDList list) {
        NDArray logits = (NDArray)list.get(0);
        NDArray result = logits.getNDArrayInternal().sigmoid();
        return result.toFloatArray();
    }

    public CrossEncoderBatchTranslator toBatchTranslator(Batchifier batchifier) {
        this.tokenizer.enableBatch();
        return new CrossEncoderBatchTranslator(this.tokenizer, this.includeTokenTypes, batchifier);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer) {
        return new Builder(tokenizer);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer, Map<String, ?> arguments) {
        Builder builder = CrossEncoderTranslator.builder(tokenizer);
        builder.configure(arguments);
        return builder;
    }

    public static final class Builder {
        private HuggingFaceTokenizer tokenizer;
        private boolean includeTokenTypes;
        private Batchifier batchifier = Batchifier.STACK;

        Builder(HuggingFaceTokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }

        public Builder optIncludeTokenTypes(boolean includeTokenTypes) {
            this.includeTokenTypes = includeTokenTypes;
            return this;
        }

        public Builder optBatchifier(Batchifier batchifier) {
            this.batchifier = batchifier;
            return this;
        }

        public void configure(Map<String, ?> arguments) {
            this.optIncludeTokenTypes(ArgumentsUtil.booleanValue(arguments, (String)"includeTokenTypes"));
            String batchifierStr = ArgumentsUtil.stringValue(arguments, (String)"batchifier", (String)"stack");
            this.optBatchifier(Batchifier.fromString((String)batchifierStr));
        }

        public CrossEncoderTranslator build() throws IOException {
            return new CrossEncoderTranslator(this.tokenizer, this.includeTokenTypes, this.batchifier);
        }
    }
}

