/*
 * Decompiled with CFR 0.152.
 */
package newcontroller;

import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.geso.routes.RoutingResult;
import me.geso.routes.WebRouter;
import newcontroller.RouterDefinition;
import newcontroller.support.CapturedHttpServletRequestAdopter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;

public class RouterHandlerMapping<T>
extends AbstractHandlerMapping {
    @Autowired
    Optional<List<RouterDefinition<T>>> routerDefinitions;
    private static final Logger log = LoggerFactory.getLogger(RouterHandlerMapping.class);
    private final WebRouter<T> router = new WebRouter();
    private final HandlerApplier<T> handlerApplier;

    public RouterHandlerMapping(HandlerApplier<T> handlerApplier) {
        this.handlerApplier = handlerApplier;
    }

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        if (request.getRequestURI().equalsIgnoreCase("favicon.ico")) {
            return null;
        }
        String method = request.getMethod();
        String path = request.getRequestURI();
        return this.router.match(method, path);
    }

    @PostConstruct
    public void init() {
        this.routerDefinitions.ifPresent(defs -> {
            for (RouterDefinition def : defs) {
                def.define(this.router);
            }
        });
        this.router.getPatterns().forEach(x -> log.info("Router(path={}, method={})\t->\t{}", new Object[]{x.getPath(), x.getMethods(), x.getDestination()}));
    }

    public HandlerAdapter handlerAdapter() {
        return new HandlerAdapter(){

            public boolean supports(Object handler) {
                return RoutingResult.class.isAssignableFrom(handler.getClass());
            }

            public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
                RoutingResult routingResult = (RoutingResult)handler;
                CapturedHttpServletRequestAdopter req = new CapturedHttpServletRequestAdopter(routingResult.getCaptured(), request);
                return RouterHandlerMapping.this.handlerApplier.apply(routingResult.getDestination(), req, response);
            }

            public long getLastModified(HttpServletRequest request, Object handler) {
                return -1L;
            }
        };
    }

    @FunctionalInterface
    public static interface HandlerApplier<T> {
        public ModelAndView apply(T var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;
    }
}

