/*
 * Decompiled with CFR 0.152.
 */
package newcontroller.handler.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import newcontroller.handler.Request;
import newcontroller.handler.impl.HttpMessageConvertersHelper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.WebDataBinder;

public class DefaultRequest
implements Request {
    private final HttpServletRequest request;
    private final List<HttpMessageConverter<?>> converters;

    public DefaultRequest(HttpServletRequest request, List<HttpMessageConverter<?>> converters) {
        this.request = request;
        this.converters = converters == null ? Collections.emptyList() : converters;
    }

    public DefaultRequest(HttpServletRequest request) {
        this(request, null);
    }

    @Override
    public Optional<String> param(String name) {
        return Optional.ofNullable(this.request.getParameter(name));
    }

    @Override
    public List<String> params(String name) {
        String[] values = this.request.getParameterValues(name);
        return values == null ? Collections.emptyList() : Arrays.asList(values);
    }

    @Override
    public Map<String, List<String>> params() {
        return this.request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> Arrays.asList((Object[])x.getValue())));
    }

    @Override
    public <T> T params(Class<T> clazz) {
        Object obj = BeanUtils.instantiate(clazz);
        WebDataBinder binder = new WebDataBinder(obj);
        binder.bind((PropertyValues)new MutablePropertyValues(this.request.getParameterMap()));
        return (T)obj;
    }

    @Override
    public <T> T body(Class<T> clazz) {
        MediaType mediaType = MediaType.parseMediaType((String)this.request.getContentType());
        HttpMessageConverter<?> converter = HttpMessageConvertersHelper.findConverter(this.converters, clazz, mediaType);
        try {
            return clazz.cast(converter.read(clazz, (HttpInputMessage)new ServletServerHttpRequest(this.request)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Request put(String key, Object value) {
        this.request.setAttribute(key, value);
        return this;
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        return clazz.cast(this.request.getAttribute(key));
    }

    @Override
    public Map<String, ?> model() {
        return Collections.list(this.request.getAttributeNames()).stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((HttpServletRequest)this.request).getAttribute(arg_0)));
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return clazz.cast(this.request);
    }
}

