/*
 * Decompiled with CFR 0.152.
 */
package newcontroller.handler.impl;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletResponse;
import newcontroller.handler.HandlerBridge;
import newcontroller.handler.Response;
import newcontroller.handler.impl.HttpMessageConverterHandlerBridge;
import newcontroller.handler.impl.HttpMessageConvertersHelper;
import newcontroller.handler.impl.ModelAndViewHandlerBridge;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.View;

public class DefaultResponse
implements Response {
    private final HttpServletResponse response;
    private final List<HttpMessageConverter<?>> converters;
    private MediaType contentType;

    public DefaultResponse(HttpServletResponse response, List<HttpMessageConverter<?>> converters) {
        this.response = response;
        this.converters = converters == null ? Collections.emptyList() : converters;
    }

    public DefaultResponse(HttpServletResponse response) {
        this(response, null);
    }

    @Override
    public HandlerBridge body(Object body) {
        HttpMessageConverter<?> converter = HttpMessageConvertersHelper.findConverter(this.converters, body.getClass(), this.contentType);
        return new HttpMessageConverterHandlerBridge<Object>(body, converter);
    }

    @Override
    public HandlerBridge view(String viewName) {
        return new ModelAndViewHandlerBridge(viewName);
    }

    @Override
    public HandlerBridge view(View view) {
        return new ModelAndViewHandlerBridge(view);
    }

    @Override
    public HandlerBridge with(Supplier<HandlerBridge> supplier) {
        return supplier.get();
    }

    @Override
    public MediaType contentType() {
        return this.contentType;
    }

    @Override
    public Response contentType(MediaType conentType) {
        this.contentType = conentType;
        return this;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return clazz.cast(this.response);
    }
}

