/*
 * Decompiled with CFR 0.152.
 */
package newcontroller.handler.impl;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import newcontroller.handler.HandlerBridge;
import newcontroller.handler.Request;
import newcontroller.handler.Response;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;

public class HttpMessageConverterHandlerBridge<T>
implements HandlerBridge<Void> {
    private final T body;
    private final HttpMessageConverter<T> messageConverter;

    public HttpMessageConverterHandlerBridge(T body, HttpMessageConverter<T> messageConverter) {
        this.body = body;
        this.messageConverter = messageConverter;
    }

    @Override
    public Void bridge(Request request, Response response) {
        try {
            this.messageConverter.write(this.body, response.contentType(), (HttpOutputMessage)new ServletServerHttpResponse(response.unwrap(HttpServletResponse.class)));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HttpMessageConverterHandlerBridge{");
        sb.append("body=").append(this.body);
        sb.append(", messageConverter=").append(this.messageConverter);
        sb.append('}');
        return sb.toString();
    }
}

