/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.starteam;

import com.starbase.starteam.Label;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import com.starbase.util.OLEDate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.starteam.StarTeamTask;

public class StarTeamLabel
extends StarTeamTask {
    private String labelName;
    private String description;
    private OLEDate lastBuild = null;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");

    public void setLabel(String label) {
        this.labelName = label;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLastBuild(String lastbuild) throws BuildException {
        try {
            Date lastBuildTime = DATE_FORMAT.parse(lastbuild);
            this.lastBuild = new OLEDate(lastBuildTime);
        }
        catch (ParseException e) {
            throw new BuildException("Unable to parse the date '" + lastbuild + "'", (Throwable)e);
        }
    }

    public void execute() throws BuildException {
        View snapshot = this.openView();
        new Label(snapshot, this.labelName, this.description, this.lastBuild, true).update();
        this.log("Created Label " + this.labelName);
    }

    protected View createSnapshotView(View raw) {
        return new View(raw, ViewConfiguration.createFromTime((OLEDate)this.lastBuild));
    }
}

