/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.BaseRedisCommandBuilder;
import com.lambdaworks.redis.GeoArgs;
import com.lambdaworks.redis.GeoCoordinates;
import com.lambdaworks.redis.GeoWithin;
import com.lambdaworks.redis.KeyScanCursor;
import com.lambdaworks.redis.KeyValue;
import com.lambdaworks.redis.KillArgs;
import com.lambdaworks.redis.MapScanCursor;
import com.lambdaworks.redis.ScanArgs;
import com.lambdaworks.redis.ScanCursor;
import com.lambdaworks.redis.ScoredValue;
import com.lambdaworks.redis.ScoredValueScanCursor;
import com.lambdaworks.redis.ScriptOutputType;
import com.lambdaworks.redis.SortArgs;
import com.lambdaworks.redis.StreamScanCursor;
import com.lambdaworks.redis.ValueScanCursor;
import com.lambdaworks.redis.ZAddArgs;
import com.lambdaworks.redis.ZStoreArgs;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.ArrayOutput;
import com.lambdaworks.redis.output.BooleanListOutput;
import com.lambdaworks.redis.output.BooleanOutput;
import com.lambdaworks.redis.output.ByteArrayOutput;
import com.lambdaworks.redis.output.DateOutput;
import com.lambdaworks.redis.output.DoubleOutput;
import com.lambdaworks.redis.output.GeoCoordinatesListOutput;
import com.lambdaworks.redis.output.GeoWithinListOutput;
import com.lambdaworks.redis.output.IntegerOutput;
import com.lambdaworks.redis.output.KeyListOutput;
import com.lambdaworks.redis.output.KeyOutput;
import com.lambdaworks.redis.output.KeyScanOutput;
import com.lambdaworks.redis.output.KeyScanStreamingOutput;
import com.lambdaworks.redis.output.KeyStreamingChannel;
import com.lambdaworks.redis.output.KeyStreamingOutput;
import com.lambdaworks.redis.output.KeyValueOutput;
import com.lambdaworks.redis.output.KeyValueScanStreamingOutput;
import com.lambdaworks.redis.output.KeyValueStreamingChannel;
import com.lambdaworks.redis.output.KeyValueStreamingOutput;
import com.lambdaworks.redis.output.MapOutput;
import com.lambdaworks.redis.output.MapScanOutput;
import com.lambdaworks.redis.output.NestedMultiOutput;
import com.lambdaworks.redis.output.ScoredValueListOutput;
import com.lambdaworks.redis.output.ScoredValueScanOutput;
import com.lambdaworks.redis.output.ScoredValueScanStreamingOutput;
import com.lambdaworks.redis.output.ScoredValueStreamingChannel;
import com.lambdaworks.redis.output.ScoredValueStreamingOutput;
import com.lambdaworks.redis.output.StatusOutput;
import com.lambdaworks.redis.output.StringListOutput;
import com.lambdaworks.redis.output.ValueListOutput;
import com.lambdaworks.redis.output.ValueOutput;
import com.lambdaworks.redis.output.ValueScanOutput;
import com.lambdaworks.redis.output.ValueScanStreamingOutput;
import com.lambdaworks.redis.output.ValueSetOutput;
import com.lambdaworks.redis.output.ValueStreamingChannel;
import com.lambdaworks.redis.output.ValueStreamingOutput;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandOutput;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.protocol.RedisCommand;
import com.lambdaworks.redis.protocol.SetArgs;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RedisCommandBuilder<K, V>
extends BaseRedisCommandBuilder<K, V> {
    static final String MUST_NOT_CONTAIN_NULL_ELEMENTS = "must not contain null elements";
    static final String MUST_NOT_BE_EMPTY = "must not be empty";
    static final String MUST_NOT_BE_NULL = "must not be null";

    public RedisCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    public Command<K, V, Long> append(K key, V value) {
        return this.createCommand(CommandType.APPEND, new IntegerOutput(this.codec), key, value);
    }

    public Command<K, V, String> auth(String password) {
        RedisCommandBuilder.assertNotEmpty(password, "password must not be empty");
        CommandArgs args = new CommandArgs(this.codec).add(password);
        return this.createCommand(CommandType.AUTH, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> bgrewriteaof() {
        return this.createCommand(CommandType.BGREWRITEAOF, new StatusOutput(this.codec));
    }

    public Command<K, V, String> bgsave() {
        return this.createCommand(CommandType.BGSAVE, new StatusOutput(this.codec));
    }

    public Command<K, V, Long> bitcount(K key) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        return this.createCommand(CommandType.BITCOUNT, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> bitcount(K key, long start, long end) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(start).add(end);
        return this.createCommand(CommandType.BITCOUNT, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> bitpos(K key, boolean state) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(state ? 1L : 0L);
        return this.createCommand(CommandType.BITPOS, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> bitpos(K key, boolean state, long start, long end) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(state ? 1L : 0L).add(start).add(end);
        return this.createCommand(CommandType.BITPOS, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> bitopAnd(K destination, K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.AND).addKey(destination).addKeys(keys);
        return this.createCommand(CommandType.BITOP, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> bitopNot(K destination, K source) {
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.NOT).addKey(destination).addKey(source);
        return this.createCommand(CommandType.BITOP, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> bitopOr(K destination, K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.OR).addKey(destination).addKeys(keys);
        return this.createCommand(CommandType.BITOP, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> bitopXor(K destination, K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandKeyword.XOR).addKey(destination).addKeys(keys);
        return this.createCommand(CommandType.BITOP, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, KeyValue<K, V>> blpop(long timeout, K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys).add(timeout);
        return this.createCommand(CommandType.BLPOP, new KeyValueOutput(this.codec), args);
    }

    public Command<K, V, KeyValue<K, V>> brpop(long timeout, K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys).add(timeout);
        return this.createCommand(CommandType.BRPOP, new KeyValueOutput(this.codec), args);
    }

    public Command<K, V, V> brpoplpush(long timeout, K source, K destination) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(source).addKey(destination).add(timeout);
        return this.createCommand(CommandType.BRPOPLPUSH, new ValueOutput(this.codec), args);
    }

    public Command<K, V, K> clientGetname() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.GETNAME);
        return this.createCommand(CommandType.CLIENT, new KeyOutput(this.codec), args);
    }

    public Command<K, V, String> clientSetname(K name) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SETNAME).addKey(name);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clientKill(String addr) {
        RedisCommandBuilder.assertNotEmpty(addr, "addr must not be empty");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.KILL).add(addr);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Long> clientKill(KillArgs killArgs) {
        RedisCommandBuilder.assertNotNull(killArgs, "killArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.KILL);
        killArgs.build(args);
        return this.createCommand(CommandType.CLIENT, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, String> clientPause(long timeout) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.PAUSE).add(timeout);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clientList() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.LIST);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    public Command<K, V, List<Object>> command() {
        CommandArgs args = new CommandArgs(this.codec);
        return this.createCommand(CommandType.COMMAND, new ArrayOutput(this.codec), args);
    }

    public Command<K, V, List<Object>> commandInfo(String ... commands) {
        this.assertNotEmpty(commands, "commands must not be empty");
        RedisCommandBuilder.assertNoNullElements(commands, "commands must not contain null elements");
        CommandArgs args = new CommandArgs(this.codec);
        args.add(CommandType.INFO);
        for (String command : commands) {
            args.add(command);
        }
        return this.createCommand(CommandType.COMMAND, new ArrayOutput(this.codec), args);
    }

    public Command<K, V, Long> commandCount() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.COUNT);
        return this.createCommand(CommandType.COMMAND, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, String> configRewrite() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.REWRITE);
        return this.createCommand(CommandType.CONFIG, new StatusOutput(this.codec), args);
    }

    public Command<K, V, List<String>> configGet(String parameter) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.GET).add(parameter);
        return this.createCommand(CommandType.CONFIG, new StringListOutput(this.codec), args);
    }

    public Command<K, V, String> configResetstat() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.RESETSTAT);
        return this.createCommand(CommandType.CONFIG, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> configSet(String parameter, String value) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.SET).add(parameter).add(value);
        return this.createCommand(CommandType.CONFIG, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Long> dbsize() {
        return this.createCommand(CommandType.DBSIZE, new IntegerOutput(this.codec));
    }

    public Command<K, V, String> debugObject(K key) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.OBJECT).addKey(key);
        return this.createCommand(CommandType.DEBUG, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Void> debugSegfault() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SEGFAULT);
        return this.createCommand(CommandType.DEBUG, null, args);
    }

    public Command<K, V, Void> debugOom() {
        return this.createCommand(CommandType.DEBUG, null, new CommandArgs(this.codec).add("OOM"));
    }

    public Command<K, V, String> debugHtstats(int db) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.HTSTATS).add(db);
        return this.createCommand(CommandType.DEBUG, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Long> decr(K key) {
        return this.createCommand(CommandType.DECR, new IntegerOutput(this.codec), key);
    }

    public Command<K, V, Long> decrby(K key, long amount) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(amount);
        return this.createCommand(CommandType.DECRBY, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> del(K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.DEL, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> unlink(K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.UNLINK, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, String> discard() {
        return this.createCommand(CommandType.DISCARD, new StatusOutput(this.codec));
    }

    public Command<K, V, byte[]> dump(K key) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        return this.createCommand(CommandType.DUMP, new ByteArrayOutput(this.codec), args);
    }

    public Command<K, V, V> echo(V msg) {
        CommandArgs args = new CommandArgs(this.codec).addValue(msg);
        return this.createCommand(CommandType.ECHO, new ValueOutput(this.codec), args);
    }

    public <T> Command<K, V, T> eval(String script, ScriptOutputType type, K ... keys) {
        RedisCommandBuilder.assertNotEmpty(script, "script must not be empty");
        CommandArgs args = new CommandArgs(this.codec);
        args.add(script).add(keys.length).addKeys(keys);
        CommandOutput output = this.newScriptOutput(this.codec, type);
        return this.createCommand(CommandType.EVAL, output, args);
    }

    public <T> Command<K, V, T> eval(String script, ScriptOutputType type, K[] keys, V ... values) {
        RedisCommandBuilder.assertNotEmpty(script, "script must not be empty");
        CommandArgs args = new CommandArgs(this.codec);
        args.add(script).add(keys.length).addKeys(keys).addValues(values);
        CommandOutput output = this.newScriptOutput(this.codec, type);
        return this.createCommand(CommandType.EVAL, output, args);
    }

    public <T> Command<K, V, T> evalsha(String digest, ScriptOutputType type, K ... keys) {
        RedisCommandBuilder.assertNotEmpty(digest, "digest must not be empty");
        CommandArgs args = new CommandArgs(this.codec);
        args.add(digest).add(keys.length).addKeys(keys);
        CommandOutput output = this.newScriptOutput(this.codec, type);
        return this.createCommand(CommandType.EVALSHA, output, args);
    }

    public <T> Command<K, V, T> evalsha(String digest, ScriptOutputType type, K[] keys, V ... values) {
        RedisCommandBuilder.assertNotEmpty(digest, "digest must not be empty");
        CommandArgs args = new CommandArgs(this.codec);
        args.add(digest).add(keys.length).addKeys(keys).addValues(values);
        CommandOutput output = this.newScriptOutput(this.codec, type);
        return this.createCommand(CommandType.EVALSHA, output, args);
    }

    public Command<K, V, Boolean> exists(K key) {
        return this.createCommand(CommandType.EXISTS, new BooleanOutput(this.codec), key);
    }

    public Command<K, V, Long> exists(K ... keys) {
        return this.createCommand(CommandType.EXISTS, new IntegerOutput(this.codec), new CommandArgs(this.codec).addKeys(keys));
    }

    public Command<K, V, Boolean> expire(K key, long seconds) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(seconds);
        return this.createCommand(CommandType.EXPIRE, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, Boolean> expireat(K key, long timestamp) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(timestamp);
        return this.createCommand(CommandType.EXPIREAT, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, String> flushall() {
        return this.createCommand(CommandType.FLUSHALL, new StatusOutput(this.codec));
    }

    public Command<K, V, String> flushallAsync() {
        return this.createCommand(CommandType.FLUSHALL, new StatusOutput(this.codec), new CommandArgs(this.codec).add(CommandKeyword.ASYNC));
    }

    public Command<K, V, String> flushdb() {
        return this.createCommand(CommandType.FLUSHDB, new StatusOutput(this.codec));
    }

    public Command<K, V, String> flushdbAsync() {
        return this.createCommand(CommandType.FLUSHDB, new StatusOutput(this.codec), new CommandArgs(this.codec).add(CommandKeyword.ASYNC));
    }

    public Command<K, V, V> get(K key) {
        return this.createCommand(CommandType.GET, new ValueOutput(this.codec), key);
    }

    public Command<K, V, Long> getbit(K key, long offset) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(offset);
        return this.createCommand(CommandType.GETBIT, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, V> getrange(K key, long start, long end) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(end);
        return this.createCommand(CommandType.GETRANGE, new ValueOutput(this.codec), args);
    }

    public Command<K, V, V> getset(K key, V value) {
        return this.createCommand(CommandType.GETSET, new ValueOutput(this.codec), key, value);
    }

    public Command<K, V, Long> hdel(K key, K ... fields) {
        this.assertNotEmpty(fields, "fields must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKeys(fields);
        return this.createCommand(CommandType.HDEL, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Boolean> hexists(K key, K field) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(field);
        return this.createCommand(CommandType.HEXISTS, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, V> hget(K key, K field) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(field);
        return this.createCommand(CommandType.HGET, new ValueOutput(this.codec), args);
    }

    public Command<K, V, Long> hincrby(K key, K field, long amount) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(field).add(amount);
        return this.createCommand(CommandType.HINCRBY, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Double> hincrbyfloat(K key, K field, double amount) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(field).add(amount);
        return this.createCommand(CommandType.HINCRBYFLOAT, new DoubleOutput(this.codec), args);
    }

    public Command<K, V, Map<K, V>> hgetall(K key) {
        return this.createCommand(CommandType.HGETALL, new MapOutput(this.codec), key);
    }

    public Command<K, V, Long> hgetall(KeyValueStreamingChannel<K, V> channel, K key) {
        return this.createCommand(CommandType.HGETALL, new KeyValueStreamingOutput<K, V>(this.codec, channel), key);
    }

    public Command<K, V, List<K>> hkeys(K key) {
        return this.createCommand(CommandType.HKEYS, new KeyListOutput(this.codec), key);
    }

    public Command<K, V, Long> hkeys(KeyStreamingChannel<K> channel, K key) {
        return this.createCommand(CommandType.HKEYS, new KeyStreamingOutput(this.codec, channel), key);
    }

    public Command<K, V, Long> hlen(K key) {
        return this.createCommand(CommandType.HLEN, new IntegerOutput(this.codec), key);
    }

    public Command<K, V, Long> hstrlen(K key, K field) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(field);
        return this.createCommand(CommandType.HSTRLEN, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, List<V>> hmget(K key, K ... fields) {
        this.assertNotEmpty(fields, "fields must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKeys(fields);
        return this.createCommand(CommandType.HMGET, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, Long> hmget(ValueStreamingChannel<V> channel, K key, K ... fields) {
        this.assertNotEmpty(fields, "fields must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKeys(fields);
        return this.createCommand(CommandType.HMGET, new ValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, String> hmset(K key, Map<K, V> map) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(map);
        return this.createCommand(CommandType.HMSET, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Boolean> hset(K key, K field, V value) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(field).addValue(value);
        return this.createCommand(CommandType.HSET, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, Boolean> hsetnx(K key, K field, V value) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(field).addValue(value);
        return this.createCommand(CommandType.HSETNX, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, List<V>> hvals(K key) {
        return this.createCommand(CommandType.HVALS, new ValueListOutput(this.codec), key);
    }

    public Command<K, V, Long> hvals(ValueStreamingChannel<V> channel, K key) {
        return this.createCommand(CommandType.HVALS, new ValueStreamingOutput(this.codec, channel), key);
    }

    public Command<K, V, Long> incr(K key) {
        return this.createCommand(CommandType.INCR, new IntegerOutput(this.codec), key);
    }

    public Command<K, V, Long> incrby(K key, long amount) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(amount);
        return this.createCommand(CommandType.INCRBY, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Double> incrbyfloat(K key, double amount) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(amount);
        return this.createCommand(CommandType.INCRBYFLOAT, new DoubleOutput(this.codec), args);
    }

    public Command<K, V, String> info() {
        return this.createCommand(CommandType.INFO, new StatusOutput(this.codec));
    }

    public Command<K, V, String> info(String section) {
        CommandArgs args = new CommandArgs(this.codec).add(section);
        return this.createCommand(CommandType.INFO, new StatusOutput(this.codec), args);
    }

    public Command<K, V, List<K>> keys(K pattern) {
        return this.createCommand(CommandType.KEYS, new KeyListOutput(this.codec), pattern);
    }

    public Command<K, V, Long> keys(KeyStreamingChannel<K> channel, K pattern) {
        return this.createCommand(CommandType.KEYS, new KeyStreamingOutput(this.codec, channel), pattern);
    }

    public Command<K, V, Date> lastsave() {
        return this.createCommand(CommandType.LASTSAVE, new DateOutput(this.codec));
    }

    public Command<K, V, V> lindex(K key, long index) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(index);
        return this.createCommand(CommandType.LINDEX, new ValueOutput(this.codec), args);
    }

    public Command<K, V, Long> linsert(K key, boolean before, V pivot, V value) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(before ? CommandKeyword.BEFORE : CommandKeyword.AFTER).addValue(pivot).addValue(value);
        return this.createCommand(CommandType.LINSERT, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> llen(K key) {
        return this.createCommand(CommandType.LLEN, new IntegerOutput(this.codec), key);
    }

    public Command<K, V, V> lpop(K key) {
        return this.createCommand(CommandType.LPOP, new ValueOutput(this.codec), key);
    }

    public Command<K, V, Long> lpush(K key, V ... values) {
        this.assertNotEmpty(values, "values must not be empty");
        return this.createCommand(CommandType.LPUSH, new IntegerOutput(this.codec), key, values);
    }

    public Command<K, V, Long> lpushx(K key, V value) {
        return this.createCommand(CommandType.LPUSHX, new IntegerOutput(this.codec), key, value);
    }

    public Command<K, V, List<V>> lrange(K key, long start, long stop) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(stop);
        return this.createCommand(CommandType.LRANGE, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, Long> lrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(stop);
        return this.createCommand(CommandType.LRANGE, new ValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> lrem(K key, long count, V value) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(count).addValue(value);
        return this.createCommand(CommandType.LREM, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, String> lset(K key, long index, V value) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(index).addValue(value);
        return this.createCommand(CommandType.LSET, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> ltrim(K key, long start, long stop) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(stop);
        return this.createCommand(CommandType.LTRIM, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> migrate(String host, int port, K key, int db, long timeout) {
        CommandArgs args = new CommandArgs(this.codec);
        args.add(host).add(port).addKey(key).add(db).add(timeout);
        return this.createCommand(CommandType.MIGRATE, new StatusOutput(this.codec), args);
    }

    public Command<K, V, List<V>> mget(K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.MGET, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, Long> mget(ValueStreamingChannel<V> channel, K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.MGET, new ValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Boolean> move(K key, int db) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(db);
        return this.createCommand(CommandType.MOVE, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, String> multi() {
        return this.createCommand(CommandType.MULTI, new StatusOutput(this.codec));
    }

    public Command<K, V, String> mset(Map<K, V> map) {
        CommandArgs args = new CommandArgs<K, V>(this.codec).add(map);
        return this.createCommand(CommandType.MSET, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Boolean> msetnx(Map<K, V> map) {
        CommandArgs args = new CommandArgs<K, V>(this.codec).add(map);
        return this.createCommand(CommandType.MSETNX, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, String> objectEncoding(K key) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.ENCODING).addKey(key);
        return this.createCommand(CommandType.OBJECT, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Long> objectIdletime(K key) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.IDLETIME).addKey(key);
        return this.createCommand(CommandType.OBJECT, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> objectRefcount(K key) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.REFCOUNT).addKey(key);
        return this.createCommand(CommandType.OBJECT, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Boolean> persist(K key) {
        return this.createCommand(CommandType.PERSIST, new BooleanOutput(this.codec), key);
    }

    public Command<K, V, Boolean> pexpire(K key, long milliseconds) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(milliseconds);
        return this.createCommand(CommandType.PEXPIRE, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, Boolean> pexpireat(K key, long timestamp) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(timestamp);
        return this.createCommand(CommandType.PEXPIREAT, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, String> ping() {
        return this.createCommand(CommandType.PING, new StatusOutput(this.codec));
    }

    public Command<K, V, String> readOnly() {
        return this.createCommand(CommandType.READONLY, new StatusOutput(this.codec));
    }

    public Command<K, V, String> readWrite() {
        return this.createCommand(CommandType.READWRITE, new StatusOutput(this.codec));
    }

    public Command<K, V, Long> pttl(K key) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        return this.createCommand(CommandType.PTTL, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> publish(K channel, V message) {
        CommandArgs args = new CommandArgs(this.codec).addKey(channel).addValue(message);
        return this.createCommand(CommandType.PUBLISH, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, List<K>> pubsubChannels() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.CHANNELS);
        return this.createCommand(CommandType.PUBSUB, new KeyListOutput(this.codec), args);
    }

    public Command<K, V, List<K>> pubsubChannels(K pattern) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.CHANNELS).addKey(pattern);
        return this.createCommand(CommandType.PUBSUB, new KeyListOutput(this.codec), args);
    }

    public Command<K, V, Map<K, Long>> pubsubNumsub(K ... pattern) {
        this.assertNotEmpty(pattern, "pattern must not be empty");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.NUMSUB).addKeys(pattern);
        return this.createCommand(CommandType.PUBSUB, new MapOutput(this.codec), args);
    }

    public Command<K, V, Long> pubsubNumpat() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.NUMPAT);
        return this.createCommand(CommandType.PUBSUB, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, String> quit() {
        return this.createCommand(CommandType.QUIT, new StatusOutput(this.codec));
    }

    public Command<K, V, V> randomkey() {
        return this.createCommand(CommandType.RANDOMKEY, new ValueOutput(this.codec));
    }

    public Command<K, V, List<Object>> role() {
        return this.createCommand(CommandType.ROLE, new ArrayOutput(this.codec));
    }

    public Command<K, V, String> rename(K key, K newKey) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(newKey);
        return this.createCommand(CommandType.RENAME, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Boolean> renamenx(K key, K newKey) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKey(newKey);
        return this.createCommand(CommandType.RENAMENX, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, String> restore(K key, long ttl, byte[] value) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(ttl).add(value);
        return this.createCommand(CommandType.RESTORE, new StatusOutput(this.codec), args);
    }

    public Command<K, V, V> rpop(K key) {
        return this.createCommand(CommandType.RPOP, new ValueOutput(this.codec), key);
    }

    public Command<K, V, V> rpoplpush(K source, K destination) {
        CommandArgs args = new CommandArgs(this.codec).addKey(source).addKey(destination);
        return this.createCommand(CommandType.RPOPLPUSH, new ValueOutput(this.codec), args);
    }

    public Command<K, V, Long> rpush(K key, V ... values) {
        this.assertNotEmpty(values, "values must not be empty");
        return this.createCommand(CommandType.RPUSH, new IntegerOutput(this.codec), key, values);
    }

    public Command<K, V, Long> rpushx(K key, V value) {
        return this.createCommand(CommandType.RPUSHX, new IntegerOutput(this.codec), key, value);
    }

    public Command<K, V, Long> sadd(K key, V ... members) {
        this.assertNotEmpty(members, "members must not be empty");
        return this.createCommand(CommandType.SADD, new IntegerOutput(this.codec), key, members);
    }

    public Command<K, V, String> save() {
        return this.createCommand(CommandType.SAVE, new StatusOutput(this.codec));
    }

    public Command<K, V, Long> scard(K key) {
        return this.createCommand(CommandType.SCARD, new IntegerOutput(this.codec), key);
    }

    public Command<K, V, List<Boolean>> scriptExists(String ... digests) {
        this.assertNotEmpty(digests, "digests must not be empty");
        RedisCommandBuilder.assertNoNullElements(digests, "digests must not contain null elements");
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.EXISTS);
        for (String sha : digests) {
            args.add(sha);
        }
        return this.createCommand(CommandType.SCRIPT, new BooleanListOutput(this.codec), args);
    }

    public Command<K, V, String> scriptFlush() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.FLUSH);
        return this.createCommand(CommandType.SCRIPT, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> scriptKill() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.KILL);
        return this.createCommand(CommandType.SCRIPT, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> scriptLoad(V script) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.LOAD).addValue(script);
        return this.createCommand(CommandType.SCRIPT, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Set<V>> sdiff(K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.SDIFF, new ValueSetOutput(this.codec), args);
    }

    public Command<K, V, Long> sdiff(ValueStreamingChannel<V> channel, K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.SDIFF, new ValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> sdiffstore(K destination, K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(destination).addKeys(keys);
        return this.createCommand(CommandType.SDIFFSTORE, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, String> select(int db) {
        CommandArgs args = new CommandArgs(this.codec).add(db);
        return this.createCommand(CommandType.SELECT, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> set(K key, V value) {
        return this.createCommand(CommandType.SET, new StatusOutput(this.codec), key, value);
    }

    public Command<K, V, String> set(K key, V value, SetArgs setArgs) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(value);
        setArgs.build(args);
        return this.createCommand(CommandType.SET, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Long> setbit(K key, long offset, int value) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(offset).add(value);
        return this.createCommand(CommandType.SETBIT, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, String> setex(K key, long seconds, V value) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(seconds).addValue(value);
        return this.createCommand(CommandType.SETEX, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> psetex(K key, long milliseconds, V value) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(milliseconds).addValue(value);
        return this.createCommand(CommandType.PSETEX, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Boolean> setnx(K key, V value) {
        return this.createCommand(CommandType.SETNX, new BooleanOutput(this.codec), key, value);
    }

    public Command<K, V, Long> setrange(K key, long offset, V value) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(offset).addValue(value);
        return this.createCommand(CommandType.SETRANGE, new IntegerOutput(this.codec), args);
    }

    @Deprecated
    public Command<K, V, String> shutdown() {
        return this.createCommand(CommandType.SHUTDOWN, new StatusOutput(this.codec));
    }

    public Command<K, V, String> shutdown(boolean save) {
        CommandArgs args = new CommandArgs(this.codec);
        return this.createCommand(CommandType.SHUTDOWN, new StatusOutput(this.codec), save ? args.add(CommandType.SAVE) : args.add(CommandKeyword.NOSAVE));
    }

    public Command<K, V, Set<V>> sinter(K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.SINTER, new ValueSetOutput(this.codec), args);
    }

    public Command<K, V, Long> sinter(ValueStreamingChannel<V> channel, K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.SINTER, new ValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> sinterstore(K destination, K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(destination).addKeys(keys);
        return this.createCommand(CommandType.SINTERSTORE, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Boolean> sismember(K key, V member) {
        return this.createCommand(CommandType.SISMEMBER, new BooleanOutput(this.codec), key, member);
    }

    public Command<K, V, Boolean> smove(K source, K destination, V member) {
        CommandArgs args = new CommandArgs(this.codec).addKey(source).addKey(destination).addValue(member);
        return this.createCommand(CommandType.SMOVE, new BooleanOutput(this.codec), args);
    }

    public Command<K, V, String> slaveof(String host, int port) {
        RedisCommandBuilder.assertNotEmpty(host, "host must not be empty");
        CommandArgs args = new CommandArgs(this.codec).add(host).add(port);
        return this.createCommand(CommandType.SLAVEOF, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> slaveofNoOne() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.NO).add(CommandKeyword.ONE);
        return this.createCommand(CommandType.SLAVEOF, new StatusOutput(this.codec), args);
    }

    public Command<K, V, List<Object>> slowlogGet() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.GET);
        return this.createCommand(CommandType.SLOWLOG, new NestedMultiOutput(this.codec), args);
    }

    public Command<K, V, List<Object>> slowlogGet(int count) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.GET).add(count);
        return this.createCommand(CommandType.SLOWLOG, new NestedMultiOutput(this.codec), args);
    }

    public Command<K, V, Long> slowlogLen() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.LEN);
        return this.createCommand(CommandType.SLOWLOG, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, String> slowlogReset() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.RESET);
        return this.createCommand(CommandType.SLOWLOG, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Set<V>> smembers(K key) {
        return this.createCommand(CommandType.SMEMBERS, new ValueSetOutput(this.codec), key);
    }

    public Command<K, V, Long> smembers(ValueStreamingChannel<V> channel, K key) {
        return this.createCommand(CommandType.SMEMBERS, new ValueStreamingOutput(this.codec, channel), key);
    }

    public Command<K, V, List<V>> sort(K key) {
        return this.createCommand(CommandType.SORT, new ValueListOutput(this.codec), key);
    }

    public Command<K, V, List<V>> sort(K key, SortArgs sortArgs) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        sortArgs.build(args, null);
        return this.createCommand(CommandType.SORT, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, Long> sort(ValueStreamingChannel<V> channel, K key) {
        return this.createCommand(CommandType.SORT, new ValueStreamingOutput(this.codec, channel), key);
    }

    public Command<K, V, Long> sort(ValueStreamingChannel<V> channel, K key, SortArgs sortArgs) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        sortArgs.build(args, null);
        return this.createCommand(CommandType.SORT, new ValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> sortStore(K key, SortArgs sortArgs, K destination) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        sortArgs.build(args, destination);
        return this.createCommand(CommandType.SORT, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, V> spop(K key) {
        return this.createCommand(CommandType.SPOP, new ValueOutput(this.codec), key);
    }

    public Command<K, V, V> srandmember(K key) {
        return this.createCommand(CommandType.SRANDMEMBER, new ValueOutput(this.codec), key);
    }

    public Command<K, V, Set<V>> srandmember(K key, long count) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(count);
        return this.createCommand(CommandType.SRANDMEMBER, new ValueSetOutput(this.codec), args);
    }

    public Command<K, V, Long> srandmember(ValueStreamingChannel<V> channel, K key, long count) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(count);
        return this.createCommand(CommandType.SRANDMEMBER, new ValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> srem(K key, V ... members) {
        this.assertNotEmpty(members, "members must not be empty");
        return this.createCommand(CommandType.SREM, new IntegerOutput(this.codec), key, members);
    }

    public Command<K, V, Set<V>> sunion(K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.SUNION, new ValueSetOutput(this.codec), args);
    }

    public Command<K, V, Long> sunion(ValueStreamingChannel<V> channel, K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.SUNION, new ValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> sunionstore(K destination, K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(destination).addKeys(keys);
        return this.createCommand(CommandType.SUNIONSTORE, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, String> sync() {
        return this.createCommand(CommandType.SYNC, new StatusOutput(this.codec));
    }

    public Command<K, V, Long> strlen(K key) {
        return this.createCommand(CommandType.STRLEN, new IntegerOutput(this.codec), key);
    }

    public Command<K, V, Long> ttl(K key) {
        return this.createCommand(CommandType.TTL, new IntegerOutput(this.codec), key);
    }

    public Command<K, V, String> type(K key) {
        return this.createCommand(CommandType.TYPE, new StatusOutput(this.codec), key);
    }

    public Command<K, V, String> watch(K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        return this.createCommand(CommandType.WATCH, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Long> wait(int replicas, long timeout) {
        CommandArgs args = new CommandArgs(this.codec).add(replicas).add(timeout);
        return this.createCommand(CommandType.WAIT, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, String> unwatch() {
        return this.createCommand(CommandType.UNWATCH, new StatusOutput(this.codec));
    }

    public Command<K, V, Long> zadd(K key, ZAddArgs zAddArgs, double score, V member) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (zAddArgs != null) {
            zAddArgs.build(args);
        }
        args.add(score).addValue(member);
        return this.createCommand(CommandType.ZADD, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Double> zaddincr(K key, double score, V member) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        args.add(CommandType.INCR);
        args.add(score).addValue(member);
        return this.createCommand(CommandType.ZADD, new DoubleOutput(this.codec), args);
    }

    public Command<K, V, Long> zadd(K key, ZAddArgs zAddArgs, Object ... scoresAndValues) {
        this.assertNotEmpty(scoresAndValues, "scoresAndValues must not be empty");
        RedisCommandBuilder.assertNoNullElements(scoresAndValues, "scoresAndValues must not contain null elements");
        RedisCommandBuilder.assertTrue(scoresAndValues.length % 2 == 0, "scoresAndValues.length must be a multiple of 2 and contain a sequence of score1, value1, score2, value2, scoreN,valueN");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (zAddArgs != null) {
            zAddArgs.build(args);
        }
        for (int i = 0; i < scoresAndValues.length; i += 2) {
            args.add((Double)scoresAndValues[i]);
            args.addValue(scoresAndValues[i + 1]);
        }
        return this.createCommand(CommandType.ZADD, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> zcard(K key) {
        return this.createCommand(CommandType.ZCARD, new IntegerOutput(this.codec), key);
    }

    public Command<K, V, Long> zcount(K key, double min, double max) {
        return this.zcount(key, this.string(min), this.string(max));
    }

    public Command<K, V, Long> zcount(K key, String min, String max) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(min).add(max);
        return this.createCommand(CommandType.ZCOUNT, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Double> zincrby(K key, double amount, K member) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(amount).addKey(member);
        return this.createCommand(CommandType.ZINCRBY, new DoubleOutput(this.codec), args);
    }

    public Command<K, V, Long> zinterstore(K destination, K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        return this.zinterstore(destination, new ZStoreArgs(), keys);
    }

    public Command<K, V, Long> zinterstore(K destination, ZStoreArgs storeArgs, K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKey(destination).add(keys.length).addKeys(keys);
        storeArgs.build(args);
        return this.createCommand(CommandType.ZINTERSTORE, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, List<V>> zrange(K key, long start, long stop) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(stop);
        return this.createCommand(CommandType.ZRANGE, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, List<ScoredValue<V>>> zrangeWithScores(K key, long start, long stop) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(start).add(stop).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZRANGE, new ScoredValueListOutput(this.codec), args);
    }

    public Command<K, V, List<V>> zrangebyscore(K key, double min, double max) {
        return this.zrangebyscore(key, this.string(min), this.string(max));
    }

    public Command<K, V, List<V>> zrangebyscore(K key, String min, String max) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(min).add(max);
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, List<V>> zrangebyscore(K key, double min, double max, long offset, long count) {
        return this.zrangebyscore(key, this.string(min), this.string(max), offset, count);
    }

    public Command<K, V, List<V>> zrangebyscore(K key, String min, String max, long offset, long count) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(min).add(max).add(CommandKeyword.LIMIT).add(offset).add(count);
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, List<ScoredValue<V>>> zrangebyscoreWithScores(K key, double min, double max) {
        return this.zrangebyscoreWithScores(key, this.string(min), this.string(max));
    }

    public Command<K, V, List<ScoredValue<V>>> zrangebyscoreWithScores(K key, String min, String max) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(min).add(max).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ScoredValueListOutput(this.codec), args);
    }

    public Command<K, V, List<ScoredValue<V>>> zrangebyscoreWithScores(K key, double min, double max, long offset, long count) {
        return this.zrangebyscoreWithScores(key, this.string(min), this.string(max), offset, count);
    }

    public Command<K, V, List<ScoredValue<V>>> zrangebyscoreWithScores(K key, String min, String max, long offset, long count) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(min).add(max).add(CommandKeyword.WITHSCORES).add(CommandKeyword.LIMIT).add(offset).add(count);
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ScoredValueListOutput(this.codec), args);
    }

    public Command<K, V, Long> zrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(stop);
        return this.createCommand(CommandType.ZRANGE, new ValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> zrangeWithScores(ScoredValueStreamingChannel<V> channel, K key, long start, long stop) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(start).add(stop).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZRANGE, new ScoredValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, double min, double max) {
        return this.zrangebyscore(channel, key, this.string(min), this.string(max));
    }

    public Command<K, V, Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, String min, String max) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(min).add(max);
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, double min, double max, long offset, long count) {
        return this.zrangebyscore(channel, key, this.string(min), this.string(max), offset, count);
    }

    public Command<K, V, Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, String min, String max, long offset, long count) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(min).add(max).add(CommandKeyword.LIMIT).add(offset).add(count);
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double min, double max) {
        return this.zrangebyscoreWithScores(channel, key, this.string(min), this.string(max));
    }

    public Command<K, V, Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String min, String max) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(min).add(max).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ScoredValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double min, double max, long offset, long count) {
        return this.zrangebyscoreWithScores(channel, key, this.string(min), this.string(max), offset, count);
    }

    public Command<K, V, Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String min, String max, long offset, long count) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(min).add(max).add(CommandKeyword.WITHSCORES).add(CommandKeyword.LIMIT).add(offset).add(count);
        return this.createCommand(CommandType.ZRANGEBYSCORE, new ScoredValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> zrank(K key, V member) {
        return this.createCommand(CommandType.ZRANK, new IntegerOutput(this.codec), key, member);
    }

    public Command<K, V, Long> zrem(K key, V ... members) {
        this.assertNotEmpty(members, "members must not be empty");
        return this.createCommand(CommandType.ZREM, new IntegerOutput(this.codec), key, members);
    }

    public Command<K, V, Long> zremrangebyrank(K key, long start, long stop) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(stop);
        return this.createCommand(CommandType.ZREMRANGEBYRANK, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> zremrangebyscore(K key, double min, double max) {
        return this.zremrangebyscore(key, this.string(min), this.string(max));
    }

    public Command<K, V, Long> zremrangebyscore(K key, String min, String max) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(min).add(max);
        return this.createCommand(CommandType.ZREMRANGEBYSCORE, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, List<V>> zrevrange(K key, long start, long stop) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(stop);
        return this.createCommand(CommandType.ZREVRANGE, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, List<ScoredValue<V>>> zrevrangeWithScores(K key, long start, long stop) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(start).add(stop).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZREVRANGE, new ScoredValueListOutput(this.codec), args);
    }

    public Command<K, V, List<V>> zrevrangebyscore(K key, double max, double min) {
        return this.zrevrangebyscore(key, this.string(max), this.string(min));
    }

    public Command<K, V, List<V>> zrevrangebyscore(K key, String max, String min) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(max).add(min);
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, List<V>> zrevrangebyscore(K key, double max, double min, long offset, long count) {
        return this.zrevrangebyscore(key, this.string(max), this.string(min), offset, count);
    }

    public Command<K, V, List<V>> zrevrangebyscore(K key, String max, String min, long offset, long count) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(max).add(min).add(CommandKeyword.LIMIT).add(offset).add(count);
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, double max, double min) {
        return this.zrevrangebyscoreWithScores(key, this.string(max), this.string(min));
    }

    public Command<K, V, List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, String max, String min) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(max).add(min).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ScoredValueListOutput(this.codec), args);
    }

    public Command<K, V, List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, double max, double min, long offset, long count) {
        return this.zrevrangebyscoreWithScores(key, this.string(max), this.string(min), offset, count);
    }

    public Command<K, V, List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, String max, String min, long offset, long count) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(max).add(min).add(CommandKeyword.WITHSCORES).add(CommandKeyword.LIMIT).add(offset).add(count);
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ScoredValueListOutput(this.codec), args);
    }

    public Command<K, V, Long> zrevrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(start).add(stop);
        return this.createCommand(CommandType.ZREVRANGE, new ValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> zrevrangeWithScores(ScoredValueStreamingChannel<V> channel, K key, long start, long stop) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(start).add(stop).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZREVRANGE, new ScoredValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, double max, double min) {
        return this.zrevrangebyscore(channel, key, this.string(max), this.string(min));
    }

    public Command<K, V, Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, String max, String min) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(max).add(min);
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, double max, double min, long offset, long count) {
        return this.zrevrangebyscore(channel, key, this.string(max), this.string(min), offset, count);
    }

    public Command<K, V, Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, String max, String min, long offset, long count) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(max).add(min).add(CommandKeyword.LIMIT).add(offset).add(count);
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double max, double min) {
        return this.zrevrangebyscoreWithScores(channel, key, this.string(max), this.string(min));
    }

    public Command<K, V, Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String max, String min) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(max).add(min).add(CommandKeyword.WITHSCORES);
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ScoredValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double max, double min, long offset, long count) {
        return this.zrevrangebyscoreWithScores(channel, key, this.string(max), this.string(min), offset, count);
    }

    public Command<K, V, Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String max, String min, long offset, long count) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(max).add(min).add(CommandKeyword.WITHSCORES).add(CommandKeyword.LIMIT).add(offset).add(count);
        return this.createCommand(CommandType.ZREVRANGEBYSCORE, new ScoredValueStreamingOutput(this.codec, channel), args);
    }

    public Command<K, V, Long> zrevrank(K key, V member) {
        return this.createCommand(CommandType.ZREVRANK, new IntegerOutput(this.codec), key, member);
    }

    public Command<K, V, Double> zscore(K key, V member) {
        return this.createCommand(CommandType.ZSCORE, new DoubleOutput(this.codec), key, member);
    }

    public Command<K, V, Long> zunionstore(K destination, K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        return this.zunionstore(destination, new ZStoreArgs(), keys);
    }

    public Command<K, V, Long> zunionstore(K destination, ZStoreArgs storeArgs, K ... keys) {
        this.assertNotEmpty(keys, "keys must not be empty");
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(destination).add(keys.length).addKeys(keys);
        storeArgs.build(args);
        return this.createCommand(CommandType.ZUNIONSTORE, new IntegerOutput(this.codec), args);
    }

    public RedisCommand<K, V, Long> zlexcount(K key, String min, String max) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(min).add(max);
        return this.createCommand(CommandType.ZLEXCOUNT, new IntegerOutput(this.codec), args);
    }

    public RedisCommand<K, V, Long> zremrangebylex(K key, String min, String max) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(min).add(max);
        return this.createCommand(CommandType.ZREMRANGEBYLEX, new IntegerOutput(this.codec), args);
    }

    public RedisCommand<K, V, List<V>> zrangebylex(K key, String min, String max) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(min).add(max);
        return this.createCommand(CommandType.ZRANGEBYLEX, new ValueListOutput(this.codec), args);
    }

    public RedisCommand<K, V, List<V>> zrangebylex(K key, String min, String max, long offset, long count) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key).add(min).add(max).add(CommandKeyword.LIMIT).add(offset).add(count);
        return this.createCommand(CommandType.ZRANGEBYLEX, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, List<V>> time() {
        CommandArgs args = new CommandArgs(this.codec);
        return this.createCommand(CommandType.TIME, new ValueListOutput(this.codec), args);
    }

    public Command<K, V, KeyScanCursor<K>> scan() {
        return this.scan(null, null);
    }

    public Command<K, V, KeyScanCursor<K>> scan(ScanCursor scanCursor) {
        return this.scan(scanCursor, null);
    }

    public Command<K, V, KeyScanCursor<K>> scan(ScanArgs scanArgs) {
        return this.scan(null, scanArgs);
    }

    public Command<K, V, KeyScanCursor<K>> scan(ScanCursor scanCursor, ScanArgs scanArgs) {
        CommandArgs args = new CommandArgs(this.codec);
        this.scanArgs(scanCursor, scanArgs, args);
        KeyScanOutput output = new KeyScanOutput(this.codec);
        return this.createCommand(CommandType.SCAN, output, args);
    }

    protected void scanArgs(ScanCursor scanCursor, ScanArgs scanArgs, CommandArgs<K, V> args) {
        if (scanCursor != null) {
            args.add(scanCursor.getCursor());
        } else {
            args.add("0");
        }
        if (scanArgs != null) {
            scanArgs.build(args);
        }
    }

    public Command<K, V, StreamScanCursor> scanStreaming(KeyStreamingChannel<K> channel) {
        return this.scanStreaming(channel, null, null);
    }

    public Command<K, V, StreamScanCursor> scanStreaming(KeyStreamingChannel<K> channel, ScanCursor scanCursor) {
        return this.scanStreaming(channel, scanCursor, null);
    }

    public Command<K, V, StreamScanCursor> scanStreaming(KeyStreamingChannel<K> channel, ScanArgs scanArgs) {
        return this.scanStreaming(channel, null, scanArgs);
    }

    public Command<K, V, StreamScanCursor> scanStreaming(KeyStreamingChannel<K> channel, ScanCursor scanCursor, ScanArgs scanArgs) {
        CommandArgs args = new CommandArgs(this.codec);
        this.scanArgs(scanCursor, scanArgs, args);
        KeyScanStreamingOutput output = new KeyScanStreamingOutput(this.codec, channel);
        return this.createCommand(CommandType.SCAN, output, args);
    }

    public Command<K, V, ValueScanCursor<V>> sscan(K key) {
        return this.sscan(key, null, null);
    }

    public Command<K, V, ValueScanCursor<V>> sscan(K key, ScanCursor scanCursor) {
        return this.sscan(key, scanCursor, null);
    }

    public Command<K, V, ValueScanCursor<V>> sscan(K key, ScanArgs scanArgs) {
        return this.sscan(key, null, scanArgs);
    }

    public Command<K, V, ValueScanCursor<V>> sscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key);
        this.scanArgs(scanCursor, scanArgs, args);
        ValueScanOutput output = new ValueScanOutput(this.codec);
        return this.createCommand(CommandType.SSCAN, output, args);
    }

    public Command<K, V, StreamScanCursor> sscanStreaming(ValueStreamingChannel<V> channel, K key) {
        return this.sscanStreaming(channel, key, null, null);
    }

    public Command<K, V, StreamScanCursor> sscanStreaming(ValueStreamingChannel<V> channel, K key, ScanCursor scanCursor) {
        return this.sscanStreaming(channel, key, scanCursor, null);
    }

    public Command<K, V, StreamScanCursor> sscanStreaming(ValueStreamingChannel<V> channel, K key, ScanArgs scanArgs) {
        return this.sscanStreaming(channel, key, null, scanArgs);
    }

    public Command<K, V, StreamScanCursor> sscanStreaming(ValueStreamingChannel<V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key);
        this.scanArgs(scanCursor, scanArgs, args);
        ValueScanStreamingOutput output = new ValueScanStreamingOutput(this.codec, channel);
        return this.createCommand(CommandType.SSCAN, output, args);
    }

    public Command<K, V, MapScanCursor<K, V>> hscan(K key) {
        return this.hscan(key, null, null);
    }

    public Command<K, V, MapScanCursor<K, V>> hscan(K key, ScanCursor scanCursor) {
        return this.hscan(key, scanCursor, null);
    }

    public Command<K, V, MapScanCursor<K, V>> hscan(K key, ScanArgs scanArgs) {
        return this.hscan(key, null, scanArgs);
    }

    public Command<K, V, MapScanCursor<K, V>> hscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key);
        this.scanArgs(scanCursor, scanArgs, args);
        MapScanOutput output = new MapScanOutput(this.codec);
        return this.createCommand(CommandType.HSCAN, output, args);
    }

    public Command<K, V, StreamScanCursor> hscanStreaming(KeyValueStreamingChannel<K, V> channel, K key) {
        return this.hscanStreaming(channel, key, null, null);
    }

    public Command<K, V, StreamScanCursor> hscanStreaming(KeyValueStreamingChannel<K, V> channel, K key, ScanCursor scanCursor) {
        return this.hscanStreaming(channel, key, scanCursor, null);
    }

    public Command<K, V, StreamScanCursor> hscanStreaming(KeyValueStreamingChannel<K, V> channel, K key, ScanArgs scanArgs) {
        return this.hscanStreaming(channel, key, null, scanArgs);
    }

    public Command<K, V, StreamScanCursor> hscanStreaming(KeyValueStreamingChannel<K, V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key);
        this.scanArgs(scanCursor, scanArgs, args);
        KeyValueScanStreamingOutput<K, V> output = new KeyValueScanStreamingOutput<K, V>(this.codec, channel);
        return this.createCommand(CommandType.HSCAN, output, args);
    }

    public Command<K, V, ScoredValueScanCursor<V>> zscan(K key) {
        return this.zscan(key, null, null);
    }

    public Command<K, V, ScoredValueScanCursor<V>> zscan(K key, ScanCursor scanCursor) {
        return this.zscan(key, scanCursor, null);
    }

    public Command<K, V, ScoredValueScanCursor<V>> zscan(K key, ScanArgs scanArgs) {
        return this.zscan(key, null, scanArgs);
    }

    public Command<K, V, ScoredValueScanCursor<V>> zscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key);
        this.scanArgs(scanCursor, scanArgs, args);
        ScoredValueScanOutput output = new ScoredValueScanOutput(this.codec);
        return this.createCommand(CommandType.ZSCAN, output, args);
    }

    public Command<K, V, StreamScanCursor> zscanStreaming(ScoredValueStreamingChannel<V> channel, K key) {
        return this.zscanStreaming(channel, key, null, null);
    }

    public Command<K, V, StreamScanCursor> zscanStreaming(ScoredValueStreamingChannel<V> channel, K key, ScanCursor scanCursor) {
        return this.zscanStreaming(channel, key, scanCursor, null);
    }

    public Command<K, V, StreamScanCursor> zscanStreaming(ScoredValueStreamingChannel<V> channel, K key, ScanArgs scanArgs) {
        return this.zscanStreaming(channel, key, null, scanArgs);
    }

    public Command<K, V, StreamScanCursor> zscanStreaming(ScoredValueStreamingChannel<V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKey(key);
        this.scanArgs(scanCursor, scanArgs, args);
        ScoredValueScanStreamingOutput output = new ScoredValueScanStreamingOutput(this.codec, channel);
        return this.createCommand(CommandType.ZSCAN, output, args);
    }

    public Command<K, V, Long> pfadd(K key, V value, V ... moreValues) {
        RedisCommandBuilder.assertNotNull(value, "value must not be null");
        RedisCommandBuilder.assertNotNull(moreValues, "moreValues must not be null");
        RedisCommandBuilder.assertNoNullElements(moreValues, "moreValues must not contain null elements");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(value).addValues(moreValues);
        return this.createCommand(CommandType.PFADD, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> pfcount(K key, K ... moreKeys) {
        RedisCommandBuilder.assertNotNull(key, "key must not be null");
        RedisCommandBuilder.assertNotNull(moreKeys, "moreKeys must not be null");
        RedisCommandBuilder.assertNoNullElements(moreKeys, "moreKeys must not contain null elements");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addKeys(moreKeys);
        return this.createCommand(CommandType.PFCOUNT, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, String> pfmerge(K destkey, K sourcekey, K ... moreSourceKeys) {
        RedisCommandBuilder.assertNotNull(destkey, "destkey must not be null");
        RedisCommandBuilder.assertNotNull(sourcekey, "sourcekey must not be null");
        RedisCommandBuilder.assertNotNull(moreSourceKeys, "moreSourceKeys must not be null");
        RedisCommandBuilder.assertNoNullElements(moreSourceKeys, "moreSourceKeys must not contain null elements");
        CommandArgs args = new CommandArgs(this.codec).addKeys(destkey).addKey(sourcekey).addKeys(moreSourceKeys);
        return this.createCommand(CommandType.PFMERGE, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clusterMeet(String ip, int port) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.MEET).add(ip).add(port);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clusterForget(String nodeId) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.FORGET).add(nodeId);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clusterAddslots(int[] slots) {
        RedisCommandBuilder.assertNotEmpty(slots, "slots must not be empty");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.ADDSLOTS);
        for (int slot : slots) {
            args.add(slot);
        }
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clusterDelslots(int[] slots) {
        RedisCommandBuilder.assertNotEmpty(slots, "slots must not be empty");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.DELSLOTS);
        for (int slot : slots) {
            args.add(slot);
        }
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clusterInfo() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.INFO);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clusterMyId() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.MYID);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clusterNodes() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.NODES);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, List<K>> clusterGetKeysInSlot(int slot, int count) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.GETKEYSINSLOT).add(slot).add(count);
        return this.createCommand(CommandType.CLUSTER, new KeyListOutput(this.codec), args);
    }

    public Command<K, V, Long> clusterCountKeysInSlot(int slot) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.COUNTKEYSINSLOT).add(slot);
        return this.createCommand(CommandType.CLUSTER, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> clusterCountFailureReports(String nodeId) {
        CommandArgs args = new CommandArgs(this.codec).add("COUNT-FAILURE-REPORTS").add(nodeId);
        return this.createCommand(CommandType.CLUSTER, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> clusterKeyslot(K key) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.KEYSLOT).addKey(key);
        return this.createCommand(CommandType.CLUSTER, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, String> clusterSaveconfig() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SAVECONFIG);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clusterSetConfigEpoch(long configEpoch) {
        CommandArgs args = new CommandArgs(this.codec).add("SET-CONFIG-EPOCH").add(configEpoch);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, List<Object>> clusterSlots() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SLOTS);
        return this.createCommand(CommandType.CLUSTER, new ArrayOutput(this.codec), args);
    }

    public Command<K, V, String> clusterSetSlotNode(int slot, String nodeId) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SETSLOT).add(slot).add(CommandKeyword.NODE).add(nodeId);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clusterSetSlotStable(int slot) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SETSLOT).add(slot).add(CommandKeyword.STABLE);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clusterSetSlotMigrating(int slot, String nodeId) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SETSLOT).add(slot).add(CommandKeyword.MIGRATING).add(nodeId);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clusterSetSlotImporting(int slot, String nodeId) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SETSLOT).add(slot).add(CommandKeyword.IMPORTING).add(nodeId);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clusterReplicate(String nodeId) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.REPLICATE).add(nodeId);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> asking() {
        CommandArgs args = new CommandArgs(this.codec);
        return this.createCommand(CommandType.ASKING, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clusterFlushslots() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.FLUSHSLOTS);
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, List<String>> clusterSlaves(String nodeId) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SLAVES).add(nodeId);
        return this.createCommand(CommandType.CLUSTER, new StringListOutput(this.codec), args);
    }

    public Command<K, V, String> clusterFailover(boolean force) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.FAILOVER);
        if (force) {
            args.add(CommandKeyword.FORCE);
        }
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clusterReset(boolean hard) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.RESET);
        if (hard) {
            args.add(CommandKeyword.HARD);
        } else {
            args.add(CommandKeyword.SOFT);
        }
        return this.createCommand(CommandType.CLUSTER, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Long> geoadd(K key, double longitude, double latitude, V member) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(longitude).add(latitude).addValue(member);
        return this.createCommand(CommandType.GEOADD, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Long> geoadd(K key, Object[] lngLatMember) {
        this.assertNotEmpty(lngLatMember, "lngLatMember must not be empty");
        RedisCommandBuilder.assertNoNullElements(lngLatMember, "lngLatMember must not contain null elements");
        RedisCommandBuilder.assertTrue(lngLatMember.length % 3 == 0, "lngLatMember.length must be a multiple of 3 and contain a sequence of longitude1, latitude1, member1, longitude2, latitude2, member2, ... longitudeN, latitudeN, memberN");
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        for (int i = 0; i < lngLatMember.length; i += 3) {
            args.add((Double)lngLatMember[i]);
            args.add((Double)lngLatMember[i + 1]);
            args.addValue(lngLatMember[i + 2]);
        }
        return this.createCommand(CommandType.GEOADD, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, Set<V>> georadius(K key, double longitude, double latitude, double distance, String unit) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(longitude).add(latitude).add(distance).add(unit);
        return this.createCommand(CommandType.GEORADIUS, new ValueSetOutput(this.codec), args);
    }

    public Command<K, V, List<GeoWithin<V>>> georadius(K key, double longitude, double latitude, double distance, String unit, GeoArgs geoArgs) {
        RedisCommandBuilder.assertNotNull(geoArgs, "geoArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).add(longitude).add(latitude).add(distance).add(unit);
        geoArgs.build(args);
        return this.createCommand(CommandType.GEORADIUS, new GeoWithinListOutput(this.codec, geoArgs.isWithDistance(), geoArgs.isWithHash(), geoArgs.isWithCoordinates()), args);
    }

    public Command<K, V, Set<V>> georadiusbymember(K key, V member, double distance, String unit) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(member).add(distance).add(unit);
        return this.createCommand(CommandType.GEORADIUSBYMEMBER, new ValueSetOutput(this.codec), args);
    }

    public Command<K, V, List<GeoWithin<V>>> georadiusbymember(K key, V member, double distance, String unit, GeoArgs geoArgs) {
        RedisCommandBuilder.assertNotNull(geoArgs, "geoArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(member).add(distance).add(unit);
        geoArgs.build(args);
        return this.createCommand(CommandType.GEORADIUSBYMEMBER, new GeoWithinListOutput(this.codec, geoArgs.isWithDistance(), geoArgs.isWithHash(), geoArgs.isWithCoordinates()), args);
    }

    public Command<K, V, List<GeoCoordinates>> geopos(K key, V[] members) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValues(members);
        return this.createCommand(CommandType.GEOPOS, new GeoCoordinatesListOutput(this.codec), args);
    }

    public Command<K, V, Double> geodist(K key, V from, V to, GeoArgs.Unit unit) {
        CommandArgs args = new CommandArgs(this.codec).addKey(key).addValue(from).addValue(to);
        if (unit != null) {
            args.add(unit.name());
        }
        return this.createCommand(CommandType.GEODIST, new DoubleOutput(this.codec), args);
    }

    protected static void assertNotEmpty(String string, String message) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    protected void assertNotEmpty(Object[] array, String message) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    protected static void assertNotEmpty(int[] array, String message) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNoNullElements(Object[] array, String message) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static void assertTrue(boolean value, String message) {
        if (!value) {
            throw new IllegalArgumentException(message);
        }
    }
}

