/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Preconditions;
import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.RedisConnection;
import java.util.concurrent.ExecutionException;

class Connections {
    private Connections() {
    }

    public static final boolean isValid(Object connection) {
        Preconditions.checkNotNull((Object)connection, (Object)"Connection must not be null");
        if (connection instanceof RedisAsyncConnection) {
            RedisAsyncConnection redisAsyncConnection = (RedisAsyncConnection)connection;
            try {
                redisAsyncConnection.ping().get();
                return true;
            }
            catch (RuntimeException e) {
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            catch (ExecutionException e) {
                return false;
            }
        }
        if (connection instanceof RedisConnection) {
            RedisConnection redisConnection = (RedisConnection)connection;
            try {
                redisConnection.ping();
                return true;
            }
            catch (RuntimeException e) {
                return false;
            }
        }
        throw new IllegalArgumentException("Connection class " + connection.getClass() + " not supported");
    }

    public static final boolean isOpen(Object connection) {
        Preconditions.checkNotNull((Object)connection, (Object)"Connection must not be null");
        if (connection instanceof RedisAsyncConnection) {
            RedisAsyncConnection redisAsyncConnection = (RedisAsyncConnection)connection;
            return redisAsyncConnection.isOpen();
        }
        if (connection instanceof RedisConnection) {
            RedisConnection redisConnection = (RedisConnection)connection;
            return redisConnection.isOpen();
        }
        throw new IllegalArgumentException("Connection class " + connection.getClass() + " not supported");
    }

    public static void close(Object connection) {
        Preconditions.checkNotNull((Object)connection, (Object)"Connection must not be null");
        try {
            if (connection instanceof RedisAsyncConnection) {
                RedisAsyncConnection redisAsyncConnection = (RedisAsyncConnection)connection;
                redisAsyncConnection.close();
                return;
            }
            if (connection instanceof RedisConnection) {
                RedisConnection redisConnection = (RedisConnection)connection;
                redisConnection.close();
                return;
            }
        }
        catch (RuntimeException e) {
            return;
        }
        throw new IllegalArgumentException("Connection class " + connection.getClass() + " not supported");
    }
}

