/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.ConnectionBuilder;
import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.RedisConnectionException;
import com.lambdaworks.redis.RedisConnectionPool;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.SslConnectionBuilder;
import com.lambdaworks.redis.StatefulRedisConnectionImpl;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.api.async.RedisAsyncCommands;
import com.lambdaworks.redis.api.sync.RedisCommands;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.pubsub.PubSubCommandHandler;
import com.lambdaworks.redis.pubsub.StatefulRedisPubSubConnection;
import com.lambdaworks.redis.pubsub.StatefulRedisPubSubConnectionImpl;
import com.lambdaworks.redis.sentinel.StatefulRedisSentinelConnectionImpl;
import com.lambdaworks.redis.sentinel.api.StatefulRedisSentinelConnection;
import com.lambdaworks.redis.sentinel.api.async.RedisSentinelAsyncCommands;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RedisClient
extends AbstractRedisClient {
    private final RedisURI redisURI;

    @Deprecated
    public RedisClient() {
        this.redisURI = null;
        this.setDefaultTimeout(60L, TimeUnit.MINUTES);
    }

    @Deprecated
    public RedisClient(String host) {
        this(host, 6379);
    }

    @Deprecated
    public RedisClient(String host, int port) {
        this(RedisURI.Builder.redis(host, port).build());
    }

    @Deprecated
    public RedisClient(RedisURI redisURI) {
        this.redisURI = redisURI;
        this.setDefaultTimeout(redisURI.getTimeout(), redisURI.getUnit());
    }

    public static RedisClient create() {
        return new RedisClient();
    }

    public static RedisClient create(RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return new RedisClient(redisURI);
    }

    public static RedisClient create(String uri) {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        return new RedisClient(RedisURI.create(uri));
    }

    public RedisConnectionPool<RedisCommands<String, String>> pool() {
        return this.pool(5, 20);
    }

    public RedisConnectionPool<RedisCommands<String, String>> pool(int maxIdle, int maxActive) {
        return this.pool(this.newStringStringCodec(), maxIdle, maxActive);
    }

    public <K, V> RedisConnectionPool<RedisCommands<K, V>> pool(final RedisCodec<K, V> codec, int maxIdle, int maxActive) {
        this.checkForRedisURI();
        long maxWait = this.makeTimeout();
        RedisConnectionPool<RedisCommands<K, V>> pool = new RedisConnectionPool<RedisCommands<K, V>>(new RedisConnectionPool.RedisConnectionProvider<RedisCommands<K, V>>(){

            @Override
            public RedisCommands<K, V> createConnection() {
                return RedisClient.this.connect(codec, RedisClient.this.redisURI).sync();
            }

            @Override
            public Class<? extends RedisCommands<K, V>> getComponentType() {
                return RedisCommands.class;
            }
        }, maxActive, maxIdle, maxWait);
        pool.addListener(this.closeableResources::remove);
        this.closeableResources.add(pool);
        return pool;
    }

    protected long makeTimeout() {
        return TimeUnit.MILLISECONDS.convert(this.timeout, this.unit);
    }

    private void checkForRedisURI() {
        Preconditions.checkState((this.redisURI != null ? 1 : 0) != 0, (Object)"RedisURI is not available. Use RedisClient(Host), RedisClient(Host, Port) or RedisClient(RedisURI) to construct your client.");
    }

    public RedisConnectionPool<RedisAsyncCommands<String, String>> asyncPool() {
        return this.asyncPool(5, 20);
    }

    public RedisConnectionPool<RedisAsyncCommands<String, String>> asyncPool(int maxIdle, int maxActive) {
        return this.asyncPool(this.newStringStringCodec(), maxIdle, maxActive);
    }

    public <K, V> RedisConnectionPool<RedisAsyncCommands<K, V>> asyncPool(final RedisCodec<K, V> codec, int maxIdle, int maxActive) {
        this.checkForRedisURI();
        long maxWait = this.makeTimeout();
        RedisConnectionPool<RedisAsyncCommands<K, V>> pool = new RedisConnectionPool<RedisAsyncCommands<K, V>>(new RedisConnectionPool.RedisConnectionProvider<RedisAsyncCommands<K, V>>(){

            @Override
            public RedisAsyncCommands<K, V> createConnection() {
                return RedisClient.this.connectStandalone(codec, RedisClient.this.redisURI).async();
            }

            @Override
            public Class<? extends RedisAsyncCommands<K, V>> getComponentType() {
                return RedisAsyncCommands.class;
            }
        }, maxActive, maxIdle, maxWait);
        pool.addListener(this.closeableResources::remove);
        this.closeableResources.add(pool);
        return pool;
    }

    public StatefulRedisConnection<String, String> connect() {
        return this.connect(this.newStringStringCodec());
    }

    public <K, V> StatefulRedisConnection<K, V> connect(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connect(codec, this.redisURI);
    }

    public StatefulRedisConnection<String, String> connect(RedisURI redisURI) {
        this.checkValidRedisURI(redisURI);
        return this.connect(this.newStringStringCodec(), redisURI);
    }

    public <K, V> StatefulRedisConnection<K, V> connect(RedisCodec<K, V> codec, RedisURI redisURI) {
        return this.connectStandalone(codec, redisURI);
    }

    @Deprecated
    public RedisAsyncCommands<String, String> connectAsync() {
        return this.connect(this.newStringStringCodec()).async();
    }

    @Deprecated
    public <K, V> RedisAsyncCommands<K, V> connectAsync(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connect(codec, this.redisURI).async();
    }

    @Deprecated
    public RedisAsyncCommands<String, String> connectAsync(RedisURI redisURI) {
        this.checkValidRedisURI(redisURI);
        return this.connect(this.newStringStringCodec(), redisURI).async();
    }

    @Deprecated
    public <K, V> RedisAsyncCommands<K, V> connectAsync(RedisCodec<K, V> codec, RedisURI redisURI) {
        this.checkValidRedisURI(redisURI);
        return this.connect(codec, redisURI).async();
    }

    private <K, V> StatefulRedisConnection<K, V> connectStandalone(RedisCodec<K, V> codec, RedisURI redisURI) {
        RedisClient.assertNotNull(codec);
        RedisClient.assertNotNull(redisURI);
        ArrayDeque queue = new ArrayDeque();
        CommandHandler handler = new CommandHandler(this.clientOptions, queue);
        StatefulRedisConnectionImpl connection = this.newStatefulRedisConnection(handler, codec);
        this.connectStateful(handler, connection, redisURI);
        return connection;
    }

    private <K, V> void connectStateful(CommandHandler<K, V> handler, StatefulRedisConnectionImpl<K, V> connection, RedisURI redisURI) {
        ConnectionBuilder connectionBuilder;
        if (redisURI.isSsl()) {
            SslConnectionBuilder sslConnectionBuilder = SslConnectionBuilder.sslConnectionBuilder();
            sslConnectionBuilder.ssl(redisURI);
            connectionBuilder = sslConnectionBuilder;
        } else {
            connectionBuilder = ConnectionBuilder.connectionBuilder();
        }
        connectionBuilder.clientOptions(this.clientOptions);
        this.connectionBuilder(handler, connection, this.getSocketAddressSupplier(redisURI), connectionBuilder, redisURI);
        this.channelType(connectionBuilder, redisURI);
        this.initializeChannel(connectionBuilder);
        if (redisURI.getPassword() != null && redisURI.getPassword().length != 0) {
            connection.async().auth(new String(redisURI.getPassword()));
        }
        if (redisURI.getDatabase() != 0) {
            connection.async().select(redisURI.getDatabase());
        }
    }

    public StatefulRedisPubSubConnection<String, String> connectPubSub() {
        return this.connectPubSub(this.newStringStringCodec());
    }

    public StatefulRedisPubSubConnection<String, String> connectPubSub(RedisURI redisURI) {
        this.checkValidRedisURI(redisURI);
        return this.connectPubSub(this.newStringStringCodec(), redisURI);
    }

    public <K, V> StatefulRedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connectPubSub(codec, this.redisURI);
    }

    public <K, V> StatefulRedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec, RedisURI redisURI) {
        RedisClient.assertNotNull(codec);
        RedisClient.assertNotNull(redisURI);
        ArrayDeque queue = new ArrayDeque();
        PubSubCommandHandler handler = new PubSubCommandHandler(this.clientOptions, queue, codec);
        StatefulRedisPubSubConnectionImpl connection = this.newStatefulRedisPubSubConnection(handler, codec);
        this.connectStateful(handler, connection, redisURI);
        return connection;
    }

    public StatefulRedisSentinelConnection<String, String> connectSentinel() {
        return this.connectSentinel(this.newStringStringCodec());
    }

    public <K, V> StatefulRedisSentinelConnection<K, V> connectSentinel(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connectSentinelImpl(codec, this.redisURI);
    }

    public StatefulRedisSentinelConnection<String, String> connectSentinel(RedisURI redisURI) {
        return this.connectSentinelImpl(this.newStringStringCodec(), redisURI);
    }

    public <K, V> StatefulRedisSentinelConnection<K, V> connectSentinel(RedisCodec<K, V> codec, RedisURI redisURI) {
        return this.connectSentinelImpl(codec, redisURI);
    }

    @Deprecated
    public RedisSentinelAsyncCommands<String, String> connectSentinelAsync() {
        return this.connectSentinel(this.newStringStringCodec()).async();
    }

    @Deprecated
    public <K, V> RedisSentinelAsyncCommands<K, V> connectSentinelAsync(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connectSentinelImpl(codec, this.redisURI).async();
    }

    @Deprecated
    public RedisSentinelAsyncCommands<String, String> connectSentinelAsync(RedisURI redisURI) {
        return this.connectSentinelImpl(this.newStringStringCodec(), redisURI).async();
    }

    @Deprecated
    public <K, V> RedisSentinelAsyncCommands<K, V> connectSentinelAsync(RedisCodec<K, V> codec, RedisURI redisURI) {
        return this.connectSentinelImpl(codec, redisURI).async();
    }

    private <K, V> StatefulRedisSentinelConnection<K, V> connectSentinelImpl(RedisCodec<K, V> codec, RedisURI redisURI) {
        RedisClient.assertNotNull(codec);
        RedisClient.assertNotNull(redisURI);
        ArrayDeque queue = new ArrayDeque();
        ConnectionBuilder connectionBuilder = ConnectionBuilder.connectionBuilder();
        connectionBuilder.clientOptions(ClientOptions.copyOf(this.getOptions()));
        CommandHandler commandHandler = new CommandHandler(this.clientOptions, queue);
        StatefulRedisSentinelConnectionImpl connection = this.newStatefulRedisSentinelConnection(commandHandler, codec);
        logger.debug("Trying to get a Sentinel connection for one of: " + redisURI.getSentinels());
        this.connectionBuilder(commandHandler, connection, this.getSocketAddressSupplier(redisURI), connectionBuilder, redisURI);
        if (redisURI.getSentinels().isEmpty() && (LettuceStrings.isNotEmpty(redisURI.getHost()) || !LettuceStrings.isEmpty(redisURI.getSocket()))) {
            this.channelType(connectionBuilder, redisURI);
            this.initializeChannel(connectionBuilder);
        } else {
            boolean connected = false;
            boolean first = true;
            Exception causingException = null;
            this.validateUrisAreOfSameConnectionType(redisURI.getSentinels());
            for (RedisURI uri : redisURI.getSentinels()) {
                if (first) {
                    this.channelType(connectionBuilder, uri);
                    first = false;
                }
                connectionBuilder.socketAddressSupplier(this.getSocketAddressSupplier(uri));
                logger.debug("Connecting to Sentinel, address: " + uri.getResolvedAddress());
                try {
                    this.initializeChannel(connectionBuilder);
                    connected = true;
                    break;
                }
                catch (Exception e) {
                    logger.warn("Cannot connect sentinel at " + uri + ": " + e.toString());
                    causingException = e;
                    if (!(e instanceof ConnectException)) continue;
                }
            }
            if (!connected) {
                throw new RedisConnectionException("Cannot connect to a sentinel: " + redisURI.getSentinels(), causingException);
            }
        }
        return connection;
    }

    protected <K, V> StatefulRedisPubSubConnectionImpl<K, V> newStatefulRedisPubSubConnection(PubSubCommandHandler<K, V> commandHandler, RedisCodec<K, V> codec) {
        return new StatefulRedisPubSubConnectionImpl<K, V>(commandHandler, codec, this.timeout, this.unit);
    }

    protected <K, V> StatefulRedisSentinelConnectionImpl<K, V> newStatefulRedisSentinelConnection(CommandHandler<K, V> commandHandler, RedisCodec<K, V> codec) {
        return new StatefulRedisSentinelConnectionImpl<K, V>(commandHandler, codec, this.timeout, this.unit);
    }

    protected <K, V> StatefulRedisConnectionImpl<K, V> newStatefulRedisConnection(CommandHandler<K, V> commandHandler, RedisCodec<K, V> codec) {
        return new StatefulRedisConnectionImpl<K, V>(commandHandler, codec, this.timeout, this.unit);
    }

    private void validateUrisAreOfSameConnectionType(List<RedisURI> redisUris) {
        boolean unixDomainSocket = false;
        boolean inetSocket = false;
        for (RedisURI sentinel : redisUris) {
            if (sentinel.getSocket() != null) {
                unixDomainSocket = true;
            }
            if (sentinel.getHost() == null) continue;
            inetSocket = true;
        }
        if (unixDomainSocket && inetSocket) {
            throw new RedisConnectionException("You cannot mix unix domain socket and IP socket URI's");
        }
    }

    private Supplier<SocketAddress> getSocketAddressSupplier(RedisURI redisURI) {
        return () -> {
            try {
                return this.getSocketAddress(redisURI);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RedisCommandInterruptedException(e);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new RedisException(e);
            }
        };
    }

    protected SocketAddress getSocketAddress(RedisURI redisURI) throws InterruptedException, TimeoutException, ExecutionException {
        SocketAddress redisAddress;
        if (redisURI.getSentinelMasterId() != null && !redisURI.getSentinels().isEmpty()) {
            logger.debug("Connecting to Redis using Sentinels " + redisURI.getSentinels() + ", MasterId " + redisURI.getSentinelMasterId());
            redisAddress = this.lookupRedis(redisURI.getSentinelMasterId());
            if (redisAddress == null) {
                throw new RedisConnectionException("Cannot provide redisAddress using sentinel for masterId " + redisURI.getSentinelMasterId());
            }
        } else {
            redisAddress = redisURI.getResolvedAddress();
        }
        return redisAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketAddress lookupRedis(String sentinelMasterId) throws InterruptedException, TimeoutException, ExecutionException {
        try (RedisSentinelAsyncCommands<String, String> connection = this.connectSentinel().async();){
            SocketAddress socketAddress = (SocketAddress)connection.getMasterAddrByName(sentinelMasterId).get(this.timeout, this.unit);
            return socketAddress;
        }
    }

    private void checkValidRedisURI(RedisURI redisURI) {
        Preconditions.checkArgument((redisURI != null && LettuceStrings.isNotEmpty(redisURI.getHost()) ? 1 : 0) != 0, (Object)"A valid RedisURI with a host is needed");
    }

    protected Utf8StringCodec newStringStringCodec() {
        return new Utf8StringCodec();
    }

    private static <K, V> void assertNotNull(RedisCodec<K, V> codec) {
        Preconditions.checkArgument((codec != null ? 1 : 0) != 0, (Object)"RedisCodec must not be null");
    }

    private static void assertNotNull(RedisURI redisURI) {
        Preconditions.checkArgument((redisURI != null ? 1 : 0) != 0, (Object)"RedisURI must not be null");
    }

    @Override
    public void setOptions(ClientOptions clientOptions) {
        super.setOptions(clientOptions);
    }
}

