/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.pubsub;

import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.protocol.RedisCommand;
import com.lambdaworks.redis.pubsub.PubSubOutput;
import com.lambdaworks.redis.resource.ClientResources;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.Queue;

public class PubSubCommandHandler<K, V>
extends CommandHandler<K, V> {
    private final RedisCodec<K, V> codec;
    private PubSubOutput<K, V, V> output;

    public PubSubCommandHandler(ClientOptions clientOptions, ClientResources clientResources, Queue<RedisCommand<K, V, ?>> queue, RedisCodec<K, V> codec) {
        super(clientOptions, clientResources, queue);
        this.codec = codec;
        this.output = new PubSubOutput(codec);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer) throws InterruptedException {
        while (this.output.type() == null && !this.queue.isEmpty()) {
            CommandOutput currentOutput = ((RedisCommand)this.queue.peek()).getOutput();
            if (!this.rsm.decode(buffer, currentOutput)) {
                return;
            }
            ((RedisCommand)this.queue.poll()).complete();
            buffer.discardReadBytes();
            if (!(currentOutput instanceof PubSubOutput)) continue;
            ctx.fireChannelRead(currentOutput);
        }
        while (this.rsm.decode(buffer, this.output)) {
            ctx.fireChannelRead(this.output);
            this.output = new PubSubOutput(this.codec);
            buffer.discardReadBytes();
        }
    }
}

