/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.RedisAsyncCommandsImpl;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisReactiveCommandsImpl;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.api.async.RedisAsyncCommands;
import com.lambdaworks.redis.api.rx.RedisReactiveCommands;
import com.lambdaworks.redis.api.sync.RedisCommands;
import com.lambdaworks.redis.cluster.api.sync.RedisClusterCommands;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.StringCodec;
import com.lambdaworks.redis.output.MultiOutput;
import com.lambdaworks.redis.output.StatusOutput;
import com.lambdaworks.redis.protocol.AsyncCommand;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandArgsAccessor;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.protocol.CompleteableCommand;
import com.lambdaworks.redis.protocol.RedisCommand;
import com.lambdaworks.redis.protocol.TransactionalCommand;
import io.netty.channel.ChannelHandler;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

@ChannelHandler.Sharable
public class StatefulRedisConnectionImpl<K, V>
extends RedisChannelHandler<K, V>
implements StatefulRedisConnection<K, V> {
    protected final RedisCodec<K, V> codec;
    protected final RedisCommands<K, V> sync;
    protected final RedisAsyncCommandsImpl<K, V> async;
    protected final RedisReactiveCommandsImpl<K, V> reactive;
    protected MultiOutput<K, V> multi;
    private char[] password;
    private int db;
    private boolean readOnly;
    private String clientName;

    public StatefulRedisConnectionImpl(RedisChannelWriter<K, V> writer, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        super(writer, timeout, unit);
        this.codec = codec;
        this.async = this.newRedisAsyncCommandsImpl();
        this.sync = this.newRedisSyncCommandsImpl();
        this.reactive = this.newRedisReactiveCommandsImpl();
    }

    @Override
    public RedisAsyncCommands<K, V> async() {
        return this.async;
    }

    protected RedisCommands<K, V> newRedisSyncCommandsImpl() {
        return (RedisCommands)this.syncHandler(this.async(), RedisCommands.class, RedisClusterCommands.class);
    }

    protected RedisAsyncCommandsImpl<K, V> newRedisAsyncCommandsImpl() {
        return new RedisAsyncCommandsImpl<K, V>(this, this.codec);
    }

    @Override
    public RedisReactiveCommands<K, V> reactive() {
        return this.reactive;
    }

    protected RedisReactiveCommandsImpl<K, V> newRedisReactiveCommandsImpl() {
        return new RedisReactiveCommandsImpl<K, V>(this, this.codec);
    }

    @Override
    public RedisCommands<K, V> sync() {
        return this.sync;
    }

    @Override
    public boolean isMulti() {
        return this.multi != null;
    }

    @Override
    public void activated() {
        super.activated();
        if (this.password != null) {
            this.async.authAsync(this.password);
        }
        if (this.db != 0) {
            this.async.selectAsync(this.db);
        }
        if (this.clientName != null) {
            this.setClientName(this.clientName);
        }
        if (this.readOnly) {
            this.async.readOnly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, C extends RedisCommand<K, V, T>> C dispatch(C command) {
        Object object;
        block11: {
            Object local = command;
            if (local.getType().name().equals(CommandType.AUTH.name())) {
                local = this.attachOnComplete((RedisCommand<K, V, T>)local, status -> {
                    if ("OK".equals(status)) {
                        char[] password = CommandArgsAccessor.getFirstCharArray(command.getArgs());
                        if (password != null) {
                            this.password = password;
                        } else {
                            String stringPassword = CommandArgsAccessor.getFirstString(command.getArgs());
                            if (stringPassword != null) {
                                this.password = stringPassword.toCharArray();
                            }
                        }
                    }
                });
            }
            if (local.getType().name().equals(CommandType.SELECT.name())) {
                local = this.attachOnComplete((RedisCommand<K, V, T>)local, status -> {
                    Long db;
                    if ("OK".equals(status) && (db = CommandArgsAccessor.getFirstInteger(command.getArgs())) != null) {
                        this.db = db.intValue();
                    }
                });
            }
            if (local.getType().name().equals(CommandType.READONLY.name())) {
                local = this.attachOnComplete((RedisCommand<K, V, T>)local, status -> {
                    if ("OK".equals(status)) {
                        this.readOnly = true;
                    }
                });
            }
            if (local.getType().name().equals(CommandType.READWRITE.name())) {
                local = this.attachOnComplete((RedisCommand<K, V, T>)local, status -> {
                    if ("OK".equals(status)) {
                        this.readOnly = false;
                    }
                });
            }
            if (local.getType().name().equals(CommandType.DISCARD.name()) && this.multi != null) {
                this.multi.cancel();
                this.multi = null;
            }
            if (local.getType().name().equals(CommandType.EXEC.name())) {
                MultiOutput<K, V> multiOutput = this.multi;
                this.multi = null;
                if (multiOutput == null) {
                    multiOutput = new MultiOutput<K, V>(this.codec);
                }
                local.setOutput(multiOutput);
            }
            if (this.multi != null) {
                local = new TransactionalCommand(local);
                this.multi.add((RedisCommand<K, V, ?>)local);
            }
            try {
                object = super.dispatch(local);
                if (!command.getType().name().equals(CommandType.MULTI.name())) break block11;
                this.multi = this.multi == null ? new MultiOutput<K, V>(this.codec) : this.multi;
            }
            catch (Throwable throwable) {
                if (command.getType().name().equals(CommandType.MULTI.name())) {
                    this.multi = this.multi == null ? new MultiOutput<K, V>(this.codec) : this.multi;
                }
                throw throwable;
            }
        }
        return (C)object;
    }

    private <T> RedisCommand<K, V, T> attachOnComplete(RedisCommand<K, V, T> command, Consumer<T> consumer) {
        if (command instanceof CompleteableCommand) {
            CompleteableCommand completeable = (CompleteableCommand)((Object)command);
            completeable.onComplete(consumer);
        }
        return command;
    }

    public void setClientName(String clientName) {
        CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.UTF8).add(CommandKeyword.SETNAME).addValue(clientName);
        AsyncCommand async = new AsyncCommand(new Command(CommandType.CLIENT, new StatusOutput<String, String>(StringCodec.UTF8), args));
        this.clientName = clientName;
        this.dispatch(async);
    }
}

