/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.cluster.api.async.AsyncExecutions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

class AsyncExecutionsImpl<T>
implements AsyncExecutions<T> {
    private Map<RedisClusterNode, CompletionStage<T>> executions;

    public AsyncExecutionsImpl(Map<RedisClusterNode, CompletionStage<? extends T>> executions) {
        HashMap<RedisClusterNode, CompletionStage<? extends T>> map = new HashMap<RedisClusterNode, CompletionStage<? extends T>>(executions);
        this.executions = Collections.unmodifiableMap(map);
    }

    @Override
    public Map<RedisClusterNode, CompletionStage<T>> asMap() {
        return this.executions;
    }

    @Override
    public Collection<RedisClusterNode> nodes() {
        return this.executions.keySet();
    }

    @Override
    public CompletionStage<T> get(RedisClusterNode redisClusterNode) {
        return this.executions.get(redisClusterNode);
    }

    @Override
    public CompletableFuture<T>[] futures() {
        return this.executions.values().toArray(new CompletableFuture[0]);
    }
}

