/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.ChannelGroupListener;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.ConnectionEventTrigger;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.PlainChannelInitializer;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelInitializer;
import com.lambdaworks.redis.RedisCommandBuilder;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.AsyncCommand;
import com.lambdaworks.redis.protocol.CommandEncoder;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.protocol.ConnectionWatchdog;
import com.lambdaworks.redis.protocol.ReconnectionListener;
import com.lambdaworks.redis.resource.ClientResources;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.util.Timer;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class ConnectionBuilder {
    private static final RedisCommandBuilder<String, String> INITIALIZING_CMD_BUILDER = new RedisCommandBuilder<String, String>(new Utf8StringCodec());
    private static final Supplier<AsyncCommand<?, ?, ?>> PING_COMMAND_SUPPLIER = () -> new AsyncCommand<String, String, String>(INITIALIZING_CMD_BUILDER.ping());
    private Supplier<SocketAddress> socketAddressSupplier;
    private ConnectionEvents connectionEvents;
    private RedisChannelHandler<?, ?> connection;
    private CommandHandler<?, ?> commandHandler;
    private ChannelGroup channelGroup;
    private Timer timer;
    private Bootstrap bootstrap;
    private ClientOptions clientOptions;
    private EventExecutorGroup workerPool;
    private long timeout;
    private TimeUnit timeUnit;
    private ClientResources clientResources;
    private char[] password;
    private ReconnectionListener reconnectionListener = ReconnectionListener.NO_OP;
    private Supplier<AsyncCommand<?, ?, ?>> pingCommandSupplier = PlainChannelInitializer.NO_PING;

    public static ConnectionBuilder connectionBuilder() {
        return new ConnectionBuilder();
    }

    protected List<ChannelHandler> buildHandlers() {
        LettuceAssert.assertState(this.channelGroup != null, "ChannelGroup must be set");
        LettuceAssert.assertState(this.connectionEvents != null, "ConnectionEvents must be set");
        LettuceAssert.assertState(this.connection != null, "Connection must be set");
        LettuceAssert.assertState(this.clientResources != null, "ClientResources must be set");
        ArrayList<ChannelHandler> handlers = new ArrayList<ChannelHandler>();
        this.connection.setOptions(this.clientOptions);
        handlers.add((ChannelHandler)new ChannelGroupListener(this.channelGroup));
        handlers.add((ChannelHandler)new CommandEncoder());
        handlers.add((ChannelHandler)this.commandHandler);
        handlers.add((ChannelHandler)this.connection);
        handlers.add((ChannelHandler)new ConnectionEventTrigger(this.connectionEvents, this.connection, this.clientResources.eventBus()));
        if (this.clientOptions.isAutoReconnect()) {
            handlers.add((ChannelHandler)this.createConnectionWatchdog());
        }
        return handlers;
    }

    public void enablePingBeforeConnect() {
        this.pingCommandSupplier = PING_COMMAND_SUPPLIER;
    }

    public void enableAuthPingBeforeConnect() {
        this.pingCommandSupplier = () -> new AsyncCommand<String, String, String>(INITIALIZING_CMD_BUILDER.auth(new String(this.password)));
    }

    protected ConnectionWatchdog createConnectionWatchdog() {
        LettuceAssert.assertState(this.bootstrap != null, "Bootstrap must be set for autoReconnect=true");
        LettuceAssert.assertState(this.timer != null, "Timer must be set for autoReconnect=true");
        LettuceAssert.assertState(this.socketAddressSupplier != null, "SocketAddressSupplier must be set for autoReconnect=true");
        ConnectionWatchdog watchdog = new ConnectionWatchdog(this.clientResources.reconnectDelay(), this.clientOptions, this.bootstrap, this.timer, this.workerPool, this.socketAddressSupplier, this.reconnectionListener);
        watchdog.setListenOnChannelInactive(true);
        return watchdog;
    }

    public RedisChannelInitializer build() {
        return new PlainChannelInitializer(this.pingCommandSupplier, this.buildHandlers(), this.clientResources, this.timeout, this.timeUnit);
    }

    public ConnectionBuilder socketAddressSupplier(Supplier<SocketAddress> socketAddressSupplier) {
        this.socketAddressSupplier = socketAddressSupplier;
        return this;
    }

    public SocketAddress socketAddress() {
        LettuceAssert.assertState(this.socketAddressSupplier != null, "SocketAddressSupplier must be set");
        return this.socketAddressSupplier.get();
    }

    public ConnectionBuilder timeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public ConnectionBuilder reconnectionListener(ReconnectionListener reconnectionListener) {
        LettuceAssert.notNull(reconnectionListener, "ReconnectionListener must not be null");
        this.reconnectionListener = reconnectionListener;
        return this;
    }

    public ConnectionBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ConnectionBuilder workerPool(EventExecutorGroup workerPool) {
        this.workerPool = workerPool;
        return this;
    }

    public ConnectionBuilder connectionEvents(ConnectionEvents connectionEvents) {
        this.connectionEvents = connectionEvents;
        return this;
    }

    public ConnectionBuilder connection(RedisChannelHandler<?, ?> connection) {
        this.connection = connection;
        return this;
    }

    public ConnectionBuilder channelGroup(ChannelGroup channelGroup) {
        this.channelGroup = channelGroup;
        return this;
    }

    public ConnectionBuilder commandHandler(CommandHandler<?, ?> commandHandler) {
        this.commandHandler = commandHandler;
        return this;
    }

    public ConnectionBuilder timer(Timer timer) {
        this.timer = timer;
        return this;
    }

    public ConnectionBuilder bootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
        return this;
    }

    public ConnectionBuilder clientResources(ClientResources clientResources) {
        this.clientResources = clientResources;
        return this;
    }

    public ConnectionBuilder password(char[] password) {
        this.password = password;
        return this;
    }

    public RedisChannelHandler<?, ?> connection() {
        return this.connection;
    }

    public CommandHandler<?, ?> commandHandler() {
        return this.commandHandler;
    }

    public Bootstrap bootstrap() {
        return this.bootstrap;
    }

    public ClientOptions clientOptions() {
        return this.clientOptions;
    }

    public ClientResources clientResources() {
        return this.clientResources;
    }

    public char[] password() {
        return this.password;
    }

    public EventExecutorGroup workerPool() {
        return this.workerPool;
    }

    Supplier<AsyncCommand<?, ?, ?>> getPingCommandSupplier() {
        return this.pingCommandSupplier;
    }
}

