/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.internal.LettuceAssert;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ClusterTopologyRefreshOptions {
    public static final boolean DEFAULT_PERIODIC_REFRESH_ENABLED = false;
    public static final long DEFAULT_REFRESH_PERIOD = 60L;
    public static final TimeUnit DEFAULT_REFRESH_PERIOD_UNIT = TimeUnit.SECONDS;
    public static final boolean DEFAULT_DYNAMIC_REFRESH_SOURCES = true;
    public static final Set<RefreshTrigger> DEFAULT_ADAPTIVE_REFRESH_TRIGGERS = Collections.emptySet();
    public static final long DEFAULT_ADAPTIVE_REFRESH_TIMEOUT = 30L;
    public static final TimeUnit DEFAULT_ADAPTIVE_REFRESH_TIMEOUT_UNIT = TimeUnit.SECONDS;
    public static final int DEFAULT_REFRESH_TRIGGERS_RECONNECT_ATTEMPTS = 5;
    public static final boolean DEFAULT_CLOSE_STALE_CONNECTIONS = true;
    private final boolean periodicRefreshEnabled;
    private final long refreshPeriod;
    private final TimeUnit refreshPeriodUnit;
    private final boolean closeStaleConnections;
    private final boolean dynamicRefreshSources;
    private final Set<RefreshTrigger> adaptiveRefreshTriggers;
    private final long adaptiveRefreshTimeout;
    private final TimeUnit adaptiveRefreshTimeoutUnit;
    private final int refreshTriggersReconnectAttempts;

    protected ClusterTopologyRefreshOptions(Builder builder) {
        this.periodicRefreshEnabled = builder.periodicRefreshEnabled;
        this.refreshPeriod = builder.refreshPeriod;
        this.refreshPeriodUnit = builder.refreshPeriodUnit;
        this.closeStaleConnections = builder.closeStaleConnections;
        this.dynamicRefreshSources = builder.dynamicRefreshSources;
        this.adaptiveRefreshTriggers = Collections.unmodifiableSet(new HashSet(builder.adaptiveRefreshTriggers));
        this.adaptiveRefreshTimeout = builder.adaptiveRefreshTimeout;
        this.adaptiveRefreshTimeoutUnit = builder.adaptiveRefreshTimeoutUnit;
        this.refreshTriggersReconnectAttempts = builder.refreshTriggersReconnectAttempts;
    }

    protected ClusterTopologyRefreshOptions(ClusterTopologyRefreshOptions original) {
        this.periodicRefreshEnabled = original.periodicRefreshEnabled;
        this.refreshPeriod = original.refreshPeriod;
        this.refreshPeriodUnit = original.refreshPeriodUnit;
        this.closeStaleConnections = original.closeStaleConnections;
        this.dynamicRefreshSources = original.dynamicRefreshSources;
        this.adaptiveRefreshTriggers = Collections.unmodifiableSet(new HashSet<RefreshTrigger>(original.adaptiveRefreshTriggers));
        this.adaptiveRefreshTimeout = original.adaptiveRefreshTimeout;
        this.adaptiveRefreshTimeoutUnit = original.adaptiveRefreshTimeoutUnit;
        this.refreshTriggersReconnectAttempts = original.refreshTriggersReconnectAttempts;
    }

    public static ClusterTopologyRefreshOptions copyOf(ClusterTopologyRefreshOptions options) {
        return new ClusterTopologyRefreshOptions(options);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ClusterTopologyRefreshOptions create() {
        return ClusterTopologyRefreshOptions.builder().build();
    }

    public static ClusterTopologyRefreshOptions enabled() {
        return ClusterTopologyRefreshOptions.builder().enablePeriodicRefresh().enableAllAdaptiveRefreshTriggers().build();
    }

    public boolean isPeriodicRefreshEnabled() {
        return this.periodicRefreshEnabled;
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public TimeUnit getRefreshPeriodUnit() {
        return this.refreshPeriodUnit;
    }

    public boolean isCloseStaleConnections() {
        return this.closeStaleConnections;
    }

    public boolean useDynamicRefreshSources() {
        return this.dynamicRefreshSources;
    }

    public Set<RefreshTrigger> getAdaptiveRefreshTriggers() {
        return this.adaptiveRefreshTriggers;
    }

    public long getAdaptiveRefreshTimeout() {
        return this.adaptiveRefreshTimeout;
    }

    public TimeUnit getAdaptiveRefreshTimeoutUnit() {
        return this.adaptiveRefreshTimeoutUnit;
    }

    public int getRefreshTriggersReconnectAttempts() {
        return this.refreshTriggersReconnectAttempts;
    }

    public static enum RefreshTrigger {
        MOVED_REDIRECT,
        ASK_REDIRECT,
        PERSISTENT_RECONNECTS,
        UNKNOWN_NODE;

    }

    public static class Builder {
        private boolean periodicRefreshEnabled = false;
        private long refreshPeriod = 60L;
        private TimeUnit refreshPeriodUnit = DEFAULT_REFRESH_PERIOD_UNIT;
        private boolean closeStaleConnections = true;
        private boolean dynamicRefreshSources = true;
        private Set<RefreshTrigger> adaptiveRefreshTriggers = new HashSet<RefreshTrigger>(DEFAULT_ADAPTIVE_REFRESH_TRIGGERS);
        private long adaptiveRefreshTimeout = 30L;
        private TimeUnit adaptiveRefreshTimeoutUnit = DEFAULT_ADAPTIVE_REFRESH_TIMEOUT_UNIT;
        private int refreshTriggersReconnectAttempts = 5;

        @Deprecated
        public Builder() {
        }

        public Builder enablePeriodicRefresh() {
            return this.enablePeriodicRefresh(true);
        }

        public Builder enablePeriodicRefresh(boolean enabled) {
            this.periodicRefreshEnabled = enabled;
            return this;
        }

        public Builder enablePeriodicRefresh(long refreshPeriod, TimeUnit refreshPeriodUnit) {
            return this.refreshPeriod(refreshPeriod, refreshPeriodUnit).enablePeriodicRefresh();
        }

        public Builder refreshPeriod(long refreshPeriod, TimeUnit refreshPeriodUnit) {
            LettuceAssert.isTrue(refreshPeriod > 0L, "RefreshPeriod must be greater 0");
            LettuceAssert.notNull((Object)refreshPeriodUnit, "TimeUnit must not be null");
            this.refreshPeriod = refreshPeriod;
            this.refreshPeriodUnit = refreshPeriodUnit;
            return this;
        }

        public Builder closeStaleConnections(boolean closeStaleConnections) {
            this.closeStaleConnections = closeStaleConnections;
            return this;
        }

        public Builder dynamicRefreshSources(boolean dynamicRefreshSources) {
            this.dynamicRefreshSources = dynamicRefreshSources;
            return this;
        }

        public Builder enableAdaptiveRefreshTrigger(RefreshTrigger ... refreshTrigger) {
            LettuceAssert.notNull(refreshTrigger, "RefreshTriggers must not be null");
            LettuceAssert.noNullElements((Object[])refreshTrigger, "RefreshTriggers must not contain null elements");
            this.adaptiveRefreshTriggers.addAll(Arrays.asList(refreshTrigger));
            return this;
        }

        public Builder enableAllAdaptiveRefreshTriggers() {
            this.adaptiveRefreshTriggers.addAll(EnumSet.allOf(RefreshTrigger.class));
            return this;
        }

        public Builder adaptiveRefreshTriggersTimeout(long timeout, TimeUnit unit) {
            this.adaptiveRefreshTimeout = timeout;
            this.adaptiveRefreshTimeoutUnit = unit;
            return this;
        }

        public Builder refreshTriggersReconnectAttempts(int refreshTriggersReconnectAttempts) {
            this.refreshTriggersReconnectAttempts = refreshTriggersReconnectAttempts;
            return this;
        }

        public ClusterTopologyRefreshOptions build() {
            return new ClusterTopologyRefreshOptions(this);
        }
    }
}

