/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.cluster.PipelinedRedisFuture;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;

class MultiNodeExecution {
    MultiNodeExecution() {
    }

    static <T> T execute(Callable<T> function) {
        try {
            return function.call();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RedisCommandInterruptedException(e);
        }
        catch (Exception e) {
            throw new RedisException(e);
        }
    }

    protected static RedisFuture<Long> aggregateAsync(Map<?, ? extends CompletionStage<Long>> executions) {
        return new PipelinedRedisFuture<Long>(executions, objectPipelinedRedisFuture -> {
            AtomicLong result = new AtomicLong();
            for (CompletionStage future : executions.values()) {
                Long value = MultiNodeExecution.execute(() -> (Long)future.toCompletableFuture().get());
                if (value == null) continue;
                result.getAndAdd(value);
            }
            return result.get();
        });
    }

    protected static <T> RedisFuture<T> firstOfAsync(Map<?, ? extends CompletionStage<T>> executions) {
        return new PipelinedRedisFuture<Object>(executions, objectPipelinedRedisFuture -> {
            for (CompletionStage future : executions.values()) {
                MultiNodeExecution.execute(() -> future.toCompletableFuture().get());
            }
            Iterator iterator = executions.values().iterator();
            if (iterator.hasNext()) {
                CompletionStage future;
                future = (CompletionStage)iterator.next();
                return MultiNodeExecution.execute(() -> future.toCompletableFuture().get());
            }
            return null;
        });
    }

    static <T> RedisFuture<T> lastOfAsync(Map<?, ? extends CompletionStage<T>> executions) {
        return new PipelinedRedisFuture<Object>(executions, objectPipelinedRedisFuture -> {
            Object result = null;
            for (CompletionStage future : executions.values()) {
                result = MultiNodeExecution.execute(() -> future.toCompletableFuture().get());
            }
            return result;
        });
    }

    static RedisFuture<String> alwaysOkOfAsync(Map<?, ? extends CompletionStage<String>> executions) {
        return new PipelinedRedisFuture<String>(executions, objectPipelinedRedisFuture -> {
            MultiNodeExecution.synchronize(executions);
            return "OK";
        });
    }

    private static void synchronize(Map<?, ? extends CompletionStage<String>> executions) {
        for (CompletionStage<String> completionStage : executions.values()) {
            try {
                completionStage.toCompletableFuture().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RedisCommandInterruptedException(e);
            }
            catch (ExecutionException executionException) {
            }
        }
    }
}

