/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.KeyValue;
import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.ScoredValue;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.CommandOutput;
import java.nio.ByteBuffer;

public class KeyValueScoredValueOutput<K, V>
extends CommandOutput<K, V, KeyValue<K, ScoredValue<V>>> {
    private K key;
    private V value;

    public KeyValueScoredValueOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.key == null) {
            this.key = this.codec.decodeKey(bytes);
            return;
        }
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.output = new KeyValue<K, ScoredValue<V>>(this.key, new ScoredValue<V>(score, this.value));
        this.key = null;
        this.value = null;
    }
}

