/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.Solar;
import com.nlf.calendar.util.SolarUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolarWeek {
    private final int year;
    private final int month;
    private final int day;
    private final int start;

    public SolarWeek(int start) {
        this(new Date(), start);
    }

    public SolarWeek(Date date, int start) {
        Solar solar = Solar.fromDate(date);
        this.year = solar.getYear();
        this.month = solar.getMonth();
        this.day = solar.getDay();
        this.start = start;
    }

    @Deprecated
    public SolarWeek(Calendar calendar, int start) {
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.start = start;
    }

    public SolarWeek(int year, int month, int day, int start) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.start = start;
    }

    public static SolarWeek fromDate(Date date, int start) {
        return new SolarWeek(date, start);
    }

    @Deprecated
    public static SolarWeek fromCalendar(Calendar calendar, int start) {
        return new SolarWeek(calendar, start);
    }

    public static SolarWeek fromYmd(int year, int month, int day, int start) {
        return new SolarWeek(year, month, day, start);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getStart() {
        return this.start;
    }

    public int getIndex() {
        int offset = Solar.fromYmd(this.year, this.month, 1).getWeek() - this.start;
        if (offset < 0) {
            offset += 7;
        }
        return (int)Math.ceil((double)(this.day + offset) / 7.0);
    }

    public int getIndexInYear() {
        int offset = Solar.fromYmd(this.year, 1, 1).getWeek() - this.start;
        if (offset < 0) {
            offset += 7;
        }
        return (int)Math.ceil((double)(SolarUtil.getDaysInYear(this.year, this.month, this.day) + offset) / 7.0);
    }

    public SolarWeek next(int weeks, boolean separateMonth) {
        if (0 == weeks) {
            return new SolarWeek(this.year, this.month, this.day, this.start);
        }
        Solar solar = Solar.fromYmd(this.year, this.month, this.day);
        if (separateMonth) {
            int n;
            boolean plus;
            SolarWeek week = new SolarWeek(solar.getYear(), solar.getMonth(), solar.getDay(), this.start);
            int month = this.month;
            boolean bl = plus = n > 0;
            for (n = weeks; 0 != n; n -= plus ? 1 : -1) {
                week = new SolarWeek((solar = solar.next(plus ? 7 : -7)).getYear(), solar.getMonth(), solar.getDay(), this.start);
                int weekMonth = week.getMonth();
                if (month == weekMonth) continue;
                int index = week.getIndex();
                if (plus) {
                    if (1 == index) {
                        Solar firstDay = week.getFirstDay();
                        week = new SolarWeek(firstDay.getYear(), firstDay.getMonth(), firstDay.getDay(), this.start);
                        weekMonth = week.getMonth();
                    } else {
                        solar = Solar.fromYmd(week.getYear(), week.getMonth(), 1);
                        week = new SolarWeek(solar.getYear(), solar.getMonth(), solar.getDay(), this.start);
                    }
                } else {
                    int size = SolarUtil.getWeeksOfMonth(week.getYear(), week.getMonth(), this.start);
                    if (size == index) {
                        Solar firstDay = week.getFirstDay();
                        Solar lastDay = firstDay.next(6);
                        week = new SolarWeek(lastDay.getYear(), lastDay.getMonth(), lastDay.getDay(), this.start);
                        weekMonth = week.getMonth();
                    } else {
                        solar = Solar.fromYmd(week.getYear(), week.getMonth(), SolarUtil.getDaysOfMonth(week.getYear(), week.getMonth()));
                        week = new SolarWeek(solar.getYear(), solar.getMonth(), solar.getDay(), this.start);
                    }
                }
                month = weekMonth;
            }
            return week;
        }
        solar = solar.next(weeks * 7);
        return new SolarWeek(solar.getYear(), solar.getMonth(), solar.getDay(), this.start);
    }

    public Solar getFirstDay() {
        Solar solar = Solar.fromYmd(this.year, this.month, this.day);
        int prev = solar.getWeek() - this.start;
        if (prev < 0) {
            prev += 7;
        }
        return solar.next(-prev);
    }

    public Solar getFirstDayInMonth() {
        List<Solar> days = this.getDays();
        for (Solar day : days) {
            if (this.month != day.getMonth()) continue;
            return day;
        }
        return null;
    }

    public List<Solar> getDays() {
        Solar firstDay = this.getFirstDay();
        ArrayList<Solar> l = new ArrayList<Solar>();
        l.add(firstDay);
        for (int i = 1; i < 7; ++i) {
            l.add(firstDay.next(i));
        }
        return l;
    }

    public List<Solar> getDaysInMonth() {
        List<Solar> days = this.getDays();
        ArrayList<Solar> l = new ArrayList<Solar>();
        for (Solar day : days) {
            if (this.month != day.getMonth()) continue;
            l.add(day);
        }
        return l;
    }

    public String toString() {
        return this.year + "." + this.month + "." + this.getIndex();
    }

    public String toFullString() {
        return this.year + "\u5e74" + this.month + "\u6708\u7b2c" + this.getIndex() + "\u5468";
    }
}

