/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.apikey.model;

import cn.dev33.satoken.exception.ApiKeyException;
import cn.dev33.satoken.util.SaFoxUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ApiKeyModel
implements Serializable {
    private static final long serialVersionUID = -6541180061782004705L;
    private String title;
    private String intro;
    private String apiKey;
    private Object loginId;
    private long createTime;
    private long expiresTime;
    private Boolean isValid = true;
    private List<String> scopes = new ArrayList<String>();
    private Map<String, Object> extraData;

    public ApiKeyModel() {
        this.createTime = System.currentTimeMillis();
    }

    public ApiKeyModel addScope(String ... scope) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.addAll(Arrays.asList(scope));
        return this;
    }

    public ApiKeyModel addExtra(String key, Object value) {
        if (this.extraData == null) {
            this.extraData = new LinkedHashMap<String, Object>();
        }
        this.extraData.put(key, value);
        return this;
    }

    public Object getExtra(String key) {
        if (this.extraData == null) {
            return null;
        }
        return this.extraData.get(key);
    }

    public Object removeExtra(String key) {
        if (this.extraData == null) {
            return null;
        }
        return this.extraData.remove(key);
    }

    public void checkByCanSaved() {
        if (SaFoxUtil.isEmpty(this.apiKey)) {
            throw new ApiKeyException("ApiKey \u503c\u4e0d\u53ef\u4e3a\u7a7a").setApiKey(this.apiKey).setCode(12304);
        }
        if (this.loginId == null) {
            throw new ApiKeyException("\u65e0\u6548 ApiKey: " + this.apiKey).setApiKey(this.apiKey).setCode(12304);
        }
        if (this.createTime == 0L) {
            throw new ApiKeyException("\u8bf7\u6307\u5b9a createTime \u521b\u5efa\u65f6\u95f4").setApiKey(this.apiKey).setCode(12304);
        }
        if (this.expiresTime == 0L) {
            throw new ApiKeyException("\u8bf7\u6307\u5b9a expiresTime \u8fc7\u671f\u65f6\u95f4").setApiKey(this.apiKey).setCode(12304);
        }
        if (this.isValid == null) {
            throw new ApiKeyException("\u8bf7\u6307\u5b9a isValid \u662f\u5426\u751f\u6548").setApiKey(this.apiKey).setCode(12304);
        }
    }

    public long expiresIn() {
        if (this.expiresTime == -1L) {
            return -1L;
        }
        long s = (this.expiresTime - System.currentTimeMillis()) / 1000L;
        return s < 1L ? -2L : s;
    }

    public boolean timeExpired() {
        if (this.expiresTime == -1L) {
            return false;
        }
        return System.currentTimeMillis() > this.expiresTime;
    }

    public String getTitle() {
        return this.title;
    }

    public ApiKeyModel setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getIntro() {
        return this.intro;
    }

    public ApiKeyModel setIntro(String intro) {
        this.intro = intro;
        return this;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public ApiKeyModel setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public Object getLoginId() {
        return this.loginId;
    }

    public ApiKeyModel setLoginId(Object loginId) {
        this.loginId = loginId;
        return this;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public ApiKeyModel setCreateTime(long createTime) {
        this.createTime = createTime;
        return this;
    }

    public long getExpiresTime() {
        return this.expiresTime;
    }

    public ApiKeyModel setExpiresTime(long expiresTime) {
        this.expiresTime = expiresTime;
        return this;
    }

    public Boolean getIsValid() {
        return this.isValid;
    }

    public ApiKeyModel setIsValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public ApiKeyModel setScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public Map<String, Object> getExtraData() {
        return this.extraData;
    }

    public ApiKeyModel setExtraData(Map<String, Object> extraData) {
        this.extraData = extraData;
        return this;
    }

    public String toString() {
        return "ApiKeyModel{title='" + this.title + ", intro='" + this.intro + ", apiKey='" + this.apiKey + ", loginId=" + this.loginId + ", createTime=" + this.createTime + ", expiresTime=" + this.expiresTime + ", isValid=" + this.isValid + ", scopes=" + this.scopes + ", extraData=" + this.extraData + '}';
    }
}

