/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.config;

import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.fun.SaParamRetFunction;
import cn.dev33.satoken.secure.SaSecureUtil;

public class SaSignConfig {
    private String secretKey;
    private long timestampDisparity = 900000L;
    private String digestAlgo = "md5";
    public SaParamRetFunction<String, String> digestMethod = fullStr -> {
        if (this.digestAlgo.equalsIgnoreCase("md5")) {
            return SaSecureUtil.md5(fullStr);
        }
        if (this.digestAlgo.equalsIgnoreCase("sha1")) {
            return SaSecureUtil.sha1(fullStr);
        }
        if (this.digestAlgo.equalsIgnoreCase("sha256")) {
            return SaSecureUtil.sha256(fullStr);
        }
        if (this.digestAlgo.equalsIgnoreCase("sha384")) {
            return SaSecureUtil.sha384(fullStr);
        }
        if (this.digestAlgo.equalsIgnoreCase("sha512")) {
            return SaSecureUtil.sha512(fullStr);
        }
        throw new SaTokenException("\u4e0d\u652f\u6301\u7684\u6458\u8981\u7b97\u6cd5\uff1a" + this.digestAlgo + "\uff0c\u4f60\u53ef\u4ee5\u81ea\u5b9a\u4e49\u6458\u8981\u7b97\u6cd5\u51fd\u6570\u5b9e\u73b0");
    };

    public SaSignConfig() {
    }

    public SaSignConfig(String secretKey) {
        this.secretKey = secretKey;
    }

    public long getSaveNonceExpire() {
        if (this.timestampDisparity >= 0L) {
            return this.timestampDisparity / 1000L;
        }
        return 86400L;
    }

    public SaSignConfig setDigestMethod(SaParamRetFunction<String, String> digestMethod) {
        this.digestMethod = digestMethod;
        return this;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public SaSignConfig setSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public long getTimestampDisparity() {
        return this.timestampDisparity;
    }

    public SaSignConfig setTimestampDisparity(long timestampDisparity) {
        this.timestampDisparity = timestampDisparity;
        return this;
    }

    public String getDigestAlgo() {
        return this.digestAlgo;
    }

    public SaSignConfig setDigestAlgo(String digestAlgo) {
        this.digestAlgo = digestAlgo;
        return this;
    }

    public String toString() {
        return "SaSignConfig [secretKey=" + this.secretKey + ", timestampDisparity=" + this.timestampDisparity + "]";
    }
}

