/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.temp;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.session.raw.SaRawSessionDelegator;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SaTempTemplate {
    public static final String DEFAULT_NAMESPACE = "temp-token";
    public String namespace;
    public SaRawSessionDelegator rawSessionDelegator;
    public static final String TEMP_TOKEN_MAP = "__HD_TEMP_TOKEN_MAP";

    public SaTempTemplate() {
        this(DEFAULT_NAMESPACE);
    }

    public SaTempTemplate(String namespace) {
        if (SaFoxUtil.isEmpty(namespace)) {
            throw new SaTokenException("namespace \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.namespace = namespace;
        this.rawSessionDelegator = new SaRawSessionDelegator(namespace);
    }

    public String createToken(Object value, long timeout) {
        return this.createToken(value, timeout, false);
    }

    public String createToken(Object value, long timeout, boolean isRecordIndex) {
        String tempToken = this.createTempTokenValue(value);
        this.saveToken(tempToken, value, timeout);
        if (isRecordIndex) {
            SaSession session = this.rawSessionDelegator.getSessionById(value);
            this.addTempTokenIndex(session, tempToken, timeout);
            this.adjustIndex(value, session);
        }
        return tempToken;
    }

    public void saveToken(String token, Object value, long timeout) {
        String key = this.splicingTempTokenSaveKey(token);
        SaManager.getSaTokenDao().setObject(key, value, timeout);
    }

    public String createTempTokenValue(Object value) {
        return SaStrategy.instance.generateUniqueToken.execute("Temp Token", SaManager.getConfig().getMaxTryTimes(), () -> this.randomTempToken(value), _apiKey -> this._getValue((String)_apiKey) == null);
    }

    public String randomTempToken(Object value) {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public Object parseToken(String token) {
        return this._getValue(token);
    }

    public <T> T parseToken(String token, Class<T> cs) {
        return this.parseToken(token, null, cs);
    }

    public <T> T parseToken(String token, String cutPrefix, Class<T> cs) {
        Object value = this.parseToken(token);
        if (SaFoxUtil.isEmpty(cutPrefix)) {
            return SaFoxUtil.getValueByType(value, cs);
        }
        SaTempTemplate.checkCutPrefixLength(cutPrefix);
        String str = SaFoxUtil.valueToString(value);
        if (str.startsWith(cutPrefix)) {
            return SaFoxUtil.getValueByType(str.substring(cutPrefix.length()), cs);
        }
        return null;
    }

    public long getTimeout(String token) {
        return this._getTimeout(token);
    }

    public void deleteToken(String token) {
        Object value = this.parseToken(token);
        if (SaFoxUtil.isEmpty(value)) {
            return;
        }
        this._deleteToken(token);
        SaSession session = this.rawSessionDelegator.getSessionById(value, false);
        if (session != null) {
            this.deleteTempTokenIndex(session, token);
            this.adjustIndex(value, null);
        }
    }

    public Map<String, Long> adjustIndex(Object value, SaSession session) {
        if (session == null && (session = this.rawSessionDelegator.getSessionById(value, false)) == null) {
            return this.newTempTokenMap();
        }
        Map<String, Long> tempTokenNewList = this.newTempTokenMap();
        ArrayList<Long> tempTokenTtlList = new ArrayList<Long>();
        Map tempTokenMap = session.get(TEMP_TOKEN_MAP, this::newTempTokenMap);
        for (Map.Entry entry : tempTokenMap.entrySet()) {
            long ttl = this.expireTimeToTtl((Long)entry.getValue());
            if (ttl == -2L) continue;
            tempTokenNewList.put((String)entry.getKey(), (Long)entry.getValue());
            tempTokenTtlList.add(ttl);
        }
        if (tempTokenNewList.isEmpty()) {
            this.rawSessionDelegator.deleteSessionById(value);
            return tempTokenNewList;
        }
        session.set(TEMP_TOKEN_MAP, tempTokenNewList);
        long maxTtl = this.getMaxTtl(tempTokenTtlList);
        if (maxTtl != 0L) {
            session.updateTimeout(maxTtl);
        }
        return tempTokenNewList;
    }

    public List<String> getTempTokenList(Object value) {
        Map<String, Long> tempTokenMap = this.adjustIndex(value, null);
        return new ArrayList<String>(tempTokenMap.keySet());
    }

    protected void addTempTokenIndex(SaSession session, String token, long timeout) {
        Map tempTokenMap = session.get(TEMP_TOKEN_MAP, this::newTempTokenMap);
        if (!tempTokenMap.containsKey(token)) {
            tempTokenMap.put(token, this.ttlToExpireTime(timeout));
            session.set(TEMP_TOKEN_MAP, tempTokenMap);
        }
    }

    protected void deleteTempTokenIndex(SaSession session, String token) {
        Map tempTokenMap = session.get(TEMP_TOKEN_MAP, this::newTempTokenMap);
        if (tempTokenMap.containsKey(token)) {
            tempTokenMap.remove(token);
            session.set(TEMP_TOKEN_MAP, tempTokenMap);
        }
    }

    protected Map<String, Long> newTempTokenMap() {
        return new LinkedHashMap<String, Long>();
    }

    protected Object _getValue(String token) {
        String key = this.splicingTempTokenSaveKey(token);
        return SaManager.getSaTokenDao().getObject(key);
    }

    protected void _deleteToken(String token) {
        String key = this.splicingTempTokenSaveKey(token);
        SaManager.getSaTokenDao().deleteObject(key);
    }

    protected long _getTimeout(String token) {
        String key = this.splicingTempTokenSaveKey(token);
        return SaManager.getSaTokenDao().getObjectTimeout(key);
    }

    protected static void checkCutPrefixLength(String cutPrefix) {
        if (cutPrefix.length() >= 32) {
            throw new SaTokenException("\u88c1\u526a\u524d\u7f00\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e 32 \u4f4d");
        }
    }

    protected long getMaxTtl(ArrayList<Long> tempTokenTtlList) {
        long maxTtl = 0L;
        for (long ttl : tempTokenTtlList) {
            if (ttl == -1L) {
                maxTtl = -1L;
                break;
            }
            if (ttl <= maxTtl) continue;
            maxTtl = ttl;
        }
        return maxTtl;
    }

    protected long expireTimeToTtl(long expireTime) {
        if (expireTime == -1L) {
            return -1L;
        }
        if (expireTime == -2L) {
            return -2L;
        }
        return (expireTime - System.currentTimeMillis()) / 1000L;
    }

    protected long ttlToExpireTime(long ttl) {
        if (ttl == -1L) {
            return -1L;
        }
        if (ttl == -2L) {
            return -2L;
        }
        return ttl * 1000L + System.currentTimeMillis();
    }

    public String splicingTempTokenSaveKey(String token) {
        return SaManager.getConfig().getTokenName() + ":" + this.namespace + ":" + token;
    }

    public String getJwtSecretKey() {
        return null;
    }
}

