/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.crypto.digest.Digester;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import java.io.File;
import java.io.InputStream;

public class SmUtil {
    private static String SM3 = "SM3";
    private static String SM4 = "SM4";

    public static SM2 sm2() {
        return new SM2();
    }

    public static SM2 sm2(String privateKeyStr, String publicKeyStr) {
        return new SM2(privateKeyStr, publicKeyStr);
    }

    public static SM2 sm2(byte[] privateKey, byte[] publicKey) {
        return new SM2(privateKey, publicKey);
    }

    public static Digester sm3() {
        return new Digester(SM3);
    }

    public static String sm3(String data) {
        return new Digester(SM3).digestHex(data);
    }

    public static String sm3(InputStream data) {
        return new Digester(SM3).digestHex(data);
    }

    public static String sm3(File dataFile) {
        return new Digester(SM3).digestHex(dataFile);
    }

    public static SymmetricCrypto sm4() {
        return new SymmetricCrypto(SM4);
    }

    public static SymmetricCrypto sm4(byte[] key) {
        return new SymmetricCrypto(SM4, key);
    }
}

