/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public class TypeUtil {
    public static Class<?> getClass(Type type) {
        if (null != type) {
            Type[] upperBounds;
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable) {
                return (Class)((TypeVariable)type).getBounds()[0];
            }
            if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
                return TypeUtil.getClass(upperBounds[0]);
            }
        }
        return null;
    }

    public static Type getType(Field field) {
        if (null == field) {
            return null;
        }
        Class<?> type = field.getGenericType();
        if (null == type) {
            type = field.getType();
        }
        return type;
    }

    public static Class<?> getClass(Field field) {
        return null == field ? null : field.getType();
    }

    public static Type getFirstParamType(Method method) {
        return TypeUtil.getParamType(method, 0);
    }

    public static Class<?> getFirstParamClass(Method method) {
        return TypeUtil.getParamClass(method, 0);
    }

    public static Type getParamType(Method method, int index) {
        Type[] types = TypeUtil.getParamTypes(method);
        if (null != types && types.length > index) {
            return types[index];
        }
        return null;
    }

    public static Class<?> getParamClass(Method method, int index) {
        Class<?>[] classes = TypeUtil.getParamClasses(method);
        if (null != classes && classes.length > index) {
            return classes[index];
        }
        return null;
    }

    public static Type[] getParamTypes(Method method) {
        return null == method ? null : method.getGenericParameterTypes();
    }

    public static Class<?>[] getParamClasses(Method method) {
        return null == method ? null : method.getParameterTypes();
    }

    public static Type getReturnType(Method method) {
        return null == method ? null : method.getGenericReturnType();
    }

    public static Class<?> getReturnClass(Method method) {
        return null == method ? null : method.getReturnType();
    }

    public static Type getTypeArgument(Type type) {
        return TypeUtil.getTypeArgument(type, 0);
    }

    public static Type getTypeArgument(Type type, int index) {
        Type[] typeArguments = TypeUtil.getTypeArguments(type);
        if (null != typeArguments && typeArguments.length > index) {
            return typeArguments[index];
        }
        return null;
    }

    public static Type[] getTypeArguments(Type type) {
        if (null == type) {
            return null;
        }
        ParameterizedType parameterizedType = TypeUtil.toParameterizedType(type);
        return null == parameterizedType ? null : parameterizedType.getActualTypeArguments();
    }

    public static ParameterizedType toParameterizedType(Type type) {
        if (type instanceof ParameterizedType) {
            return (ParameterizedType)type;
        }
        if (type instanceof Class) {
            return TypeUtil.toParameterizedType(((Class)type).getGenericSuperclass());
        }
        return null;
    }

    public static Type getActualType(Class<?> clazz, Class<?> superClass, TypeVariable<?> typeVariable) {
        int index;
        if (!superClass.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Parameter [superClass] must be assignable from [clazz]");
        }
        Type[] typeArguments = TypeUtil.getTypeArguments(clazz);
        if (ArrayUtil.isNotEmpty(typeArguments) && (index = ArrayUtil.indexOf(superClass.getTypeParameters(), typeVariable)) > -1 && index < typeArguments.length) {
            return typeArguments[index];
        }
        return null;
    }

    public static boolean isUnknow(Type type) {
        return null == type || type instanceof TypeVariable;
    }
}

