/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation.scanner;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.annotation.scanner.AnnotationScanner;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TypeAnnotationScanner
implements AnnotationScanner {
    private boolean includeSupperClass;
    private boolean includeInterfaces;
    private Predicate<Class<?>> filter;
    private final Set<Class<?>> excludeTypes;
    private final List<UnaryOperator<Class<?>>> converters;
    private boolean hasConverters;

    public TypeAnnotationScanner(boolean includeSupperClass, boolean includeInterfaces, Predicate<Class<?>> filter, Set<Class<?>> excludeTypes) {
        Assert.notNull(filter, "filter must not null", new Object[0]);
        Assert.notNull(excludeTypes, "excludeTypes must not null", new Object[0]);
        this.includeSupperClass = includeSupperClass;
        this.includeInterfaces = includeInterfaces;
        this.filter = filter;
        this.excludeTypes = excludeTypes;
        this.converters = new ArrayList();
    }

    public TypeAnnotationScanner() {
        this(true, true, t -> true, CollUtil.newHashSet(new Class[0]));
    }

    public boolean isIncludeSupperClass() {
        return this.includeSupperClass;
    }

    public boolean isIncludeInterfaces() {
        return this.includeInterfaces;
    }

    public TypeAnnotationScanner setFilter(Predicate<Class<?>> filter) {
        Assert.notNull(filter, "filter must not null", new Object[0]);
        this.filter = filter;
        return this;
    }

    public TypeAnnotationScanner addExcludeTypes(Class<?> ... excludeTypes) {
        CollUtil.addAll(this.excludeTypes, excludeTypes);
        return this;
    }

    public TypeAnnotationScanner addConverters(UnaryOperator<Class<?>> converter) {
        Assert.notNull(converter, "converter must not null", new Object[0]);
        this.converters.add(converter);
        if (!this.hasConverters) {
            this.hasConverters = true;
        }
        return this;
    }

    public TypeAnnotationScanner setIncludeSupperClass(boolean includeSupperClass) {
        this.includeSupperClass = includeSupperClass;
        return this;
    }

    public TypeAnnotationScanner setIncludeInterfaces(boolean includeInterfaces) {
        this.includeInterfaces = includeInterfaces;
        return this;
    }

    @Override
    public boolean support(AnnotatedElement annotatedElement) {
        return annotatedElement instanceof Class;
    }

    @Override
    public List<Annotation> getAnnotations(AnnotatedElement annotatedElement) {
        return this.scan((Class)annotatedElement).stream().map(Class::getAnnotations).flatMap(Stream::of).filter(a -> !AnnotationUtil.isJdkMetaAnnotation(a.annotationType())).collect(Collectors.toList());
    }

    private Class<?> convert(Class<?> target) {
        if (this.hasConverters) {
            this.converters.forEach(c -> {
                Class cfr_ignored_0 = (Class)c.apply(target);
            });
        }
        return target;
    }

    private Set<Class<?>> scan(Class<?> targetClass) {
        LinkedList<Class> classDeque = CollUtil.newLinkedList(targetClass);
        HashSet accessedTypes = new HashSet();
        while (!classDeque.isEmpty()) {
            Class<?>[] interfaces;
            Class<?> superClass;
            Class<?> target = this.convert((Class)classDeque.removeFirst());
            if (ObjectUtil.isNull(target) || accessedTypes.contains(target) || this.excludeTypes.contains(target) || this.filter.negate().test(target)) continue;
            accessedTypes.add(target);
            if (this.includeSupperClass && !ObjectUtil.equals(superClass = target.getSuperclass(), Object.class) && ObjectUtil.isNotNull(superClass)) {
                classDeque.addLast(superClass);
            }
            if (!this.includeInterfaces || !ArrayUtil.isNotEmpty(interfaces = target.getInterfaces())) continue;
            CollUtil.addAll(classDeque, interfaces);
        }
        return accessedTypes;
    }

    public static class JdkProxyClassConverter
    implements UnaryOperator<Class<?>> {
        @Override
        public Class<?> apply(Class<?> sourceClass) {
            return Proxy.isProxyClass(sourceClass) ? sourceClass.getSuperclass() : sourceClass;
        }
    }
}

