/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.symmetric;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class SymmetricCrypto
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SecretKey secretKey;
    private Cipher cipher;
    private AlgorithmParameterSpec params;
    private boolean isZeroPadding;
    private final Lock lock = new ReentrantLock();

    public SymmetricCrypto(SymmetricAlgorithm algorithm) {
        this(algorithm, (byte[])null);
    }

    public SymmetricCrypto(String algorithm) {
        this(algorithm, (byte[])null);
    }

    public SymmetricCrypto(SymmetricAlgorithm algorithm, byte[] key) {
        this(algorithm.getValue(), key);
    }

    public SymmetricCrypto(SymmetricAlgorithm algorithm, SecretKey key) {
        this(algorithm.getValue(), key);
    }

    public SymmetricCrypto(String algorithm, byte[] key) {
        this(algorithm, KeyUtil.generateKey(algorithm, key));
    }

    public SymmetricCrypto(String algorithm, SecretKey key) {
        this(algorithm, key, null);
    }

    public SymmetricCrypto(String algorithm, SecretKey key, AlgorithmParameterSpec paramsSpec) {
        this.init(algorithm, key);
        if (null != paramsSpec) {
            this.setParams(paramsSpec);
        }
    }

    public SymmetricCrypto init(String algorithm, SecretKey key) {
        Assert.notBlank((CharSequence)algorithm, (String)"'algorithm' must be not blank !", (Object[])new Object[0]);
        this.secretKey = key;
        if (algorithm.startsWith("PBE")) {
            this.params = new PBEParameterSpec(RandomUtil.randomBytes((int)8), 100);
        }
        if (algorithm.contains(Padding.ZeroPadding.name())) {
            algorithm = StrUtil.replace((CharSequence)algorithm, (CharSequence)Padding.ZeroPadding.name(), (CharSequence)Padding.NoPadding.name());
            this.isZeroPadding = true;
        }
        this.cipher = SecureUtil.createCipher(algorithm);
        return this;
    }

    public SymmetricCrypto setParams(AlgorithmParameterSpec params) {
        this.params = params;
        return this;
    }

    public SymmetricCrypto setIv(IvParameterSpec iv) {
        this.setParams(iv);
        return this;
    }

    public SymmetricCrypto setIv(byte[] iv) {
        this.setIv(new IvParameterSpec(iv));
        return this;
    }

    public byte[] encrypt(byte[] data) {
        this.lock.lock();
        try {
            Cipher cipher = this.initCipher(1);
            byte[] byArray = cipher.doFinal(this.paddingDataWithZero(data, cipher.getBlockSize()));
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void encrypt(InputStream data, OutputStream out, boolean isClose) throws IORuntimeException {
        this.lock.lock();
        CipherOutputStream cipherOutputStream = null;
        try {
            int remainLength;
            int blockSize;
            Cipher cipher = this.initCipher(1);
            cipherOutputStream = new CipherOutputStream(out, cipher);
            long length = IoUtil.copy((InputStream)data, (OutputStream)cipherOutputStream);
            if (this.isZeroPadding && (blockSize = cipher.getBlockSize()) > 0 && (remainLength = (int)(length % (long)blockSize)) > 0) {
                cipherOutputStream.write(new byte[blockSize - remainLength]);
                cipherOutputStream.flush();
            }
        }
        catch (IORuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
            if (isClose) {
                IoUtil.close((Closeable)data);
                IoUtil.close((Closeable)cipherOutputStream);
            }
        }
    }

    public String encryptHex(byte[] data) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data));
    }

    public String encryptBase64(byte[] data) {
        return Base64.encode((byte[])this.encrypt(data));
    }

    public byte[] encrypt(String data, String charset) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (String)charset));
    }

    public byte[] encrypt(String data, Charset charset) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (Charset)charset));
    }

    public String encryptHex(String data, String charset) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, charset));
    }

    public String encryptHex(String data, Charset charset) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, charset));
    }

    public String encryptBase64(String data, String charset) {
        return Base64.encode((byte[])this.encrypt(data, charset));
    }

    public String encryptBase64(String data, Charset charset) {
        return Base64.encode((byte[])this.encrypt(data, charset));
    }

    public byte[] encrypt(String data) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (Charset)CharsetUtil.CHARSET_UTF_8));
    }

    public String encryptHex(String data) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data));
    }

    public String encryptBase64(String data) {
        return Base64.encode((byte[])this.encrypt(data));
    }

    public byte[] encrypt(InputStream data) throws IORuntimeException {
        return this.encrypt(IoUtil.readBytes((InputStream)data));
    }

    public String encryptHex(InputStream data) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data));
    }

    public String encryptBase64(InputStream data) {
        return Base64.encode((byte[])this.encrypt(data));
    }

    public byte[] decrypt(byte[] bytes) {
        byte[] decryptData;
        int blockSize;
        this.lock.lock();
        try {
            Cipher cipher = this.initCipher(2);
            blockSize = cipher.getBlockSize();
            decryptData = cipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return this.removePadding(decryptData, blockSize);
    }

    public void decrypt(InputStream data, OutputStream out, boolean isClose) throws IORuntimeException {
        this.lock.lock();
        CipherInputStream cipherInputStream = null;
        try {
            int blockSize;
            Cipher cipher = this.initCipher(2);
            cipherInputStream = new CipherInputStream(data, cipher);
            if (this.isZeroPadding && (blockSize = cipher.getBlockSize()) > 0) {
                this.copyForZeroPadding(cipherInputStream, out, blockSize);
                return;
            }
            IoUtil.copy((InputStream)cipherInputStream, (OutputStream)out);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        catch (IORuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
            if (isClose) {
                IoUtil.close((Closeable)data);
                IoUtil.close((Closeable)cipherInputStream);
            }
        }
    }

    public String decryptStr(byte[] bytes, Charset charset) {
        return StrUtil.str((byte[])this.decrypt(bytes), (Charset)charset);
    }

    public String decryptStr(byte[] bytes) {
        return this.decryptStr(bytes, CharsetUtil.CHARSET_UTF_8);
    }

    public byte[] decrypt(String data) {
        return this.decrypt(SecureUtil.decode(data));
    }

    public String decryptStr(String data, Charset charset) {
        return StrUtil.str((byte[])this.decrypt(data), (Charset)charset);
    }

    public String decryptStr(String data) {
        return this.decryptStr(data, CharsetUtil.CHARSET_UTF_8);
    }

    public byte[] decrypt(InputStream data) throws IORuntimeException {
        return this.decrypt(IoUtil.readBytes((InputStream)data));
    }

    public String decryptStr(InputStream data, Charset charset) {
        return StrUtil.str((byte[])this.decrypt(data), (Charset)charset);
    }

    public String decryptStr(InputStream data) {
        return this.decryptStr(data, CharsetUtil.CHARSET_UTF_8);
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    private Cipher initCipher(int mode) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = this.cipher;
        if (null == this.params) {
            cipher.init(mode, this.secretKey);
        } else {
            cipher.init(mode, (Key)this.secretKey, this.params);
        }
        return cipher;
    }

    private byte[] paddingDataWithZero(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && (remainLength = (length = data.length) % blockSize) > 0) {
            return ArrayUtil.resize((byte[])data, (int)(length + blockSize - remainLength));
        }
        return data;
    }

    private byte[] removePadding(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && blockSize > 0 && (remainLength = (length = data.length) % blockSize) == 0) {
            int i;
            for (i = length - 1; i >= 0 && 0 == data[i]; --i) {
            }
            return ArrayUtil.resize((byte[])data, (int)(i + 1));
        }
        return data;
    }

    private void copyForZeroPadding(CipherInputStream in, OutputStream out, int blockSize) throws IOException {
        int i;
        int readSize;
        int n = 1;
        if (8192 > blockSize) {
            n = Math.max(n, 8192 / blockSize);
        }
        int bufSize = blockSize * n;
        byte[] preBuffer = new byte[bufSize];
        byte[] buffer = new byte[bufSize];
        boolean isFirst = true;
        int preReadSize = 0;
        while ((readSize = in.read(buffer)) != -1) {
            if (isFirst) {
                isFirst = false;
            } else {
                out.write(preBuffer, 0, preReadSize);
            }
            ArrayUtil.copy((Object)buffer, (Object)preBuffer, (int)readSize);
            preReadSize = readSize;
        }
        for (i = preReadSize - 1; i >= 0 && 0 == preBuffer[i]; --i) {
        }
        out.write(preBuffer, 0, i + 1);
        out.flush();
    }
}

