/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib;

import com.onespatial.dwglib.ClassData;
import com.onespatial.dwglib.Expander;
import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.Header;
import com.onespatial.dwglib.Issues;
import com.onespatial.dwglib.ObjectMapSection;
import com.onespatial.dwglib.SectionPage;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.BitStreams;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.objects.AcdbDictionaryWithDefault;
import com.onespatial.dwglib.objects.AcdbPlaceHolder;
import com.onespatial.dwglib.objects.Appid;
import com.onespatial.dwglib.objects.AppidControlObj;
import com.onespatial.dwglib.objects.Arc;
import com.onespatial.dwglib.objects.Attdef;
import com.onespatial.dwglib.objects.Attrib;
import com.onespatial.dwglib.objects.Block;
import com.onespatial.dwglib.objects.BlockControlObj;
import com.onespatial.dwglib.objects.BlockHeader;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.Circle;
import com.onespatial.dwglib.objects.Dictionary;
import com.onespatial.dwglib.objects.DimStyle;
import com.onespatial.dwglib.objects.DimensionLinear;
import com.onespatial.dwglib.objects.DimstyleControlObj;
import com.onespatial.dwglib.objects.Endblk;
import com.onespatial.dwglib.objects.GenericObject;
import com.onespatial.dwglib.objects.Hatch;
import com.onespatial.dwglib.objects.Insert;
import com.onespatial.dwglib.objects.LType;
import com.onespatial.dwglib.objects.LTypeControlObj;
import com.onespatial.dwglib.objects.Layer;
import com.onespatial.dwglib.objects.LayerControlObj;
import com.onespatial.dwglib.objects.Layout;
import com.onespatial.dwglib.objects.Leader;
import com.onespatial.dwglib.objects.Line;
import com.onespatial.dwglib.objects.LwPolyline;
import com.onespatial.dwglib.objects.MLineStyle;
import com.onespatial.dwglib.objects.MText;
import com.onespatial.dwglib.objects.ObjectMap;
import com.onespatial.dwglib.objects.PlaneSurface;
import com.onespatial.dwglib.objects.Point;
import com.onespatial.dwglib.objects.PolylineMesh;
import com.onespatial.dwglib.objects.PolylinePFace;
import com.onespatial.dwglib.objects.SeqEnd;
import com.onespatial.dwglib.objects.Solid;
import com.onespatial.dwglib.objects.SortEntsTable;
import com.onespatial.dwglib.objects.Style;
import com.onespatial.dwglib.objects.StyleControlObj;
import com.onespatial.dwglib.objects.Text;
import com.onespatial.dwglib.objects.ThreeDSolid;
import com.onespatial.dwglib.objects.TwoDPolyline;
import com.onespatial.dwglib.objects.Ucs;
import com.onespatial.dwglib.objects.UcsControlObj;
import com.onespatial.dwglib.objects.VPort;
import com.onespatial.dwglib.objects.VPortControlObj;
import com.onespatial.dwglib.objects.Vertex2D;
import com.onespatial.dwglib.objects.View;
import com.onespatial.dwglib.objects.ViewControlObj;
import com.onespatial.dwglib.objects.ViewPort;
import com.onespatial.dwglib.objects.XRecord;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Reader
implements AutoCloseable {
    private Issues issues = new Issues();
    private FileVersion fileVersion;
    private byte maintenanceReleaseVersion;
    private int previewAddress;
    private byte dwgVersion;
    private byte applicationMaintenanceReleaseVersion;
    private short codePage;
    private byte unknown1;
    private byte unknown2;
    private byte unknown3;
    private boolean areDataEncrypted;
    private boolean arePropertiesEncrypted;
    private boolean signData;
    private boolean addTimestamp;
    private int summaryInfoAddress;
    private int vbaProjectAddress;
    List<Section> sections = new ArrayList<Section>();
    List<ClassData> classes = new ArrayList<ClassData>();
    public Header header;
    private byte[] objectBuffer;
    private List<ObjectMapSection> objectMapSections;
    private Map<Long, CadObject> doneObjects = new HashMap<Long, CadObject>();
    int[] crc32Table = new int[]{0, 1996959894, -301047508, -1727442502, 124634137, 1886057615, -379345611, -1637575261, 249268274, 2044508324, -522852066, -1747789432, 162941995, 2125561021, -407360249, -1866523247, 498536548, 1789927666, -205950648, -2067906082, 450548861, 1843258603, -187386543, -2083289657, 325883990, 1684777152, -43845254, -1973040660, 335633487, 1661365465, -99664541, -1928851979, 997073096, 1281953886, -715111964, -1570279054, 1006888145, 1258607687, -770865667, -1526024853, 901097722, 1119000684, -608450090, -1396901568, 853044451, 1172266101, -589951537, -1412350631, 651767980, 1373503546, -925412992, -1076862698, 565507253, 1454621731, -809855591, -1195530993, 671266974, 1594198024, -972236366, -1324619484, 795835527, 1483230225, -1050600021, -1234817731, 1994146192, 31158534, -1731059524, -271249366, 1907459465, 112637215, -1614814043, -390540237, 2013776290, 251722036, -1777751922, -519137256, 2137656763, 141376813, -1855689577, -429695999, 1802195444, 476864866, -2056965928, -228458418, 1812370925, 453092731, -2113342271, -183516073, 1706088902, 314042704, -1950435094, -54949764, 1658658271, 366619977, -1932296973, -69972891, 1303535960, 984961486, -1547960204, -725929758, 1256170817, 1037604311, -1529756563, -740887301, 1131014506, 879679996, -1385723834, -631195440, 1141124467, 855842277, -1442165665, -586318647, 1342533948, 654459306, -1106571248, -921952122, 1466479909, 544179635, -1184443383, -832445281, 1591671054, 702138776, -1328506846, -942167884, 1504918807, 783551873, -1212326853, -1061524307, -306674912, -1698712650, 62317068, 1957810842, -355121351, -1647151185, 81470997, 1943803523, -480048366, -1805370492, 225274430, 2053790376, -468791541, -1828061283, 167816743, 2097651377, -267414716, -2029476910, 503444072, 1762050814, -144550051, -2140837941, 426522225, 1852507879, -19653770, -1982649376, 282753626, 1742555852, -105259153, -1900089351, 397917763, 1622183637, -690576408, -1580100738, 953729732, 1340076626, -776247311, -1497606297, 1068828381, 1219638859, -670225446, -1358292148, 906185462, 1090812512, -547295293, -1469587627, 829329135, 1181335161, -882789492, -1134132454, 628085408, 1382605366, -871598187, -1156888829, 570562233, 1426400815, -977650754, -1296233688, 733239954, 1555261956, -1026031705, -1244606671, 752459403, 1541320221, -1687895376, -328994266, 1969922972, 40735498, -1677130071, -351390145, 1913087877, 83908371, -1782625662, -491226604, 2075208622, 213261112, -1831694693, -438977011, 2094854071, 198958881, -2032938284, -237706686, 1759359992, 534414190, -2118248755, -155638181, 1873836001, 414664567, -2012718362, -15766928, 1711684554, 285281116, -1889165569, -127750551, 1634467795, 376229701, -1609899400, -686959890, 1308918612, 956543938, -1486412191, -799009033, 1231636301, 1047427035, -1362007478, -640263460, 1088359270, 936918000, -1447252397, -558129467, 1202900863, 817233897, -1111625188, -893730166, 1404277552, 615818150, -1160759803, -841546093, 1423857449, 601450431, -1285129682, -1000256840, 1567103746, 711928724, -1274298825, -1022587231, 1510334235, 755167117};
    private ObjectMap objectMap;

    public Reader(File inputFile) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(inputFile);){
            FileChannel channel = inputStream.getChannel();
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            byte[] versionAsByteArray = new byte[6];
            buffer.get(versionAsByteArray);
            String fileVersionAsString = new String(versionAsByteArray);
            this.fileVersion = new FileVersion(fileVersionAsString);
            this.expect((ByteBuffer)buffer, new byte[]{0, 0, 0, 0, 0});
            this.maintenanceReleaseVersion = buffer.get();
            this.expectAnyOneOf(buffer, new byte[]{0, 1, 3});
            this.previewAddress = buffer.getInt();
            this.dwgVersion = buffer.get();
            this.applicationMaintenanceReleaseVersion = buffer.get();
            this.codePage = buffer.getShort();
            this.unknown1 = buffer.get();
            this.unknown2 = buffer.get();
            this.unknown3 = buffer.get();
            int securityFlags = buffer.getInt();
            this.areDataEncrypted = (securityFlags & 1) != 0;
            this.arePropertiesEncrypted = (securityFlags & 2) != 0;
            this.signData = (securityFlags & 0x10) != 0;
            this.addTimestamp = (securityFlags & 0x20) != 0;
            ((ByteBuffer)buffer).position(32);
            this.summaryInfoAddress = buffer.getInt();
            this.vbaProjectAddress = buffer.getInt();
            this.expect((ByteBuffer)buffer, new byte[]{-128, 0, 0, 0});
            byte[] p = new byte[108];
            int q = 0;
            long sz = 108L;
            int randseed = 1;
            while (sz-- != 0L) {
                randseed *= 214013;
                p[q++] = (byte)((randseed += 2531011) >> 16 & 0xFF);
            }
            ((ByteBuffer)buffer).position(128);
            byte[] decryptedData = new byte[108];
            buffer.get(decryptedData);
            for (int i = 0; i < 108; ++i) {
                int n = i;
                decryptedData[n] = (byte)(decryptedData[n] ^ p[i]);
            }
            ByteBuffer decryptedBuffer = ByteBuffer.wrap(decryptedData);
            byte[] signatureAsBytes = new byte[11];
            decryptedBuffer.get(signatureAsBytes);
            String signature = new String(signatureAsBytes, "UTF-8");
            if (!signature.equals("AcFssFcAJMB")) {
                throw new RuntimeException("signature is incorrect");
            }
            byte nullTerminator = decryptedBuffer.get();
            decryptedBuffer.order(ByteOrder.LITTLE_ENDIAN);
            decryptedBuffer.position(24);
            int rootTreeNodeGap = decryptedBuffer.getInt();
            int lowermostLeftTreeNodeGap = decryptedBuffer.getInt();
            int lowermostRightTreeNodeGap = decryptedBuffer.getInt();
            int unknown = decryptedBuffer.getInt();
            int lastSectionPageId = decryptedBuffer.getInt();
            long lastSectionPageEndAddress = decryptedBuffer.getLong();
            long repeatedHeaderData = decryptedBuffer.getLong();
            int gapAmount = decryptedBuffer.getInt();
            int sectionPageAmount = decryptedBuffer.getInt();
            this.expectInt(decryptedBuffer, 32);
            this.expectInt(decryptedBuffer, 128);
            this.expectInt(decryptedBuffer, 64);
            int sectionPageMapId = decryptedBuffer.getInt();
            long sectionPageMapAddress = decryptedBuffer.getLong();
            int sectionMapId = decryptedBuffer.getInt();
            int sectionPageArraySize = decryptedBuffer.getInt();
            int gapArraySize = decryptedBuffer.getInt();
            int crc = decryptedBuffer.getInt();
            decryptedData[104] = 0;
            decryptedData[105] = 0;
            decryptedData[106] = 0;
            decryptedData[107] = 0;
            int calculatedCrc = this.crc(decryptedData, 108, 0);
            if (crc != calculatedCrc) {
                this.issues.addWarning("CRC does not match");
            }
            byte[] theRest = new byte[20];
            buffer.get(theRest);
            this.readSystemSectionPage(buffer, sectionPageMapAddress, sectionMapId);
        }
    }

    public CadObject parseObject(Handle h) {
        Long offsetIntoObjectMap = this.getOffsetIntoObjectMap(h);
        if (offsetIntoObjectMap == null) {
            throw new RuntimeException("remove me");
        }
        assert (offsetIntoObjectMap != null);
        CadObject cadObject = this.parseObjectAtGivenOffset(offsetIntoObjectMap);
        return cadObject;
    }

    public CadObject parseObjectPossiblyOrphaned(Handle h) {
        Long offsetIntoObjectMap = this.getOffsetIntoObjectMap(h);
        if (offsetIntoObjectMap == null) {
            return null;
        }
        CadObject cadObject = this.parseObjectAtGivenOffset(offsetIntoObjectMap);
        return cadObject;
    }

    protected CadObject parseObjectAtGivenOffset(long offsetIntoObjectMap) {
        CadObject cadObject;
        if (this.doneObjects.containsKey(offsetIntoObjectMap)) {
            return this.doneObjects.get(offsetIntoObjectMap);
        }
        if (offsetIntoObjectMap > Integer.MAX_VALUE) {
            throw new RuntimeException("overflow");
        }
        BitStreams bitStreams = new BitStreams(this.objectBuffer, (int)offsetIntoObjectMap, this.issues);
        BitBuffer dataStream = bitStreams.getDataStream();
        BitBuffer stringStream = bitStreams.getStringStream();
        BitBuffer handleStream = bitStreams.getHandleStream();
        int objectType = dataStream.getOT();
        this.objectMap = new ObjectMap(this);
        if (objectType >= 500) {
            int classIndex = objectType - 500;
            ClassData thisClass = this.classes.get(classIndex);
            switch (thisClass.classdxfname) {
                case "ACDBDICTIONARYWDFLT": {
                    cadObject = new AcdbDictionaryWithDefault(this.objectMap);
                    break;
                }
                case "PLANESURFACE": {
                    cadObject = new PlaneSurface(this.objectMap);
                    break;
                }
                case "SORTENTSTABLE": {
                    cadObject = new SortEntsTable(this.objectMap);
                    break;
                }
                default: {
                    cadObject = new GenericObject(this.objectMap, thisClass.classdxfname);
                    break;
                }
            }
        } else {
            switch (objectType) {
                case 1: {
                    cadObject = new Text(this.objectMap);
                    break;
                }
                case 2: {
                    cadObject = new Attrib(this.objectMap);
                    break;
                }
                case 3: {
                    cadObject = new Attdef(this.objectMap);
                    break;
                }
                case 4: {
                    cadObject = new Block(this.objectMap);
                    break;
                }
                case 5: {
                    cadObject = new Endblk(this.objectMap);
                    break;
                }
                case 6: {
                    cadObject = new SeqEnd(this.objectMap);
                    break;
                }
                case 7: {
                    cadObject = new Insert(this.objectMap);
                    break;
                }
                case 10: {
                    cadObject = new Vertex2D(this.objectMap);
                    break;
                }
                case 15: {
                    cadObject = new TwoDPolyline(this.objectMap);
                    break;
                }
                case 17: {
                    cadObject = new Arc(this.objectMap);
                    break;
                }
                case 18: {
                    cadObject = new Circle(this.objectMap);
                    break;
                }
                case 19: {
                    cadObject = new Line(this.objectMap);
                    break;
                }
                case 21: {
                    cadObject = new DimensionLinear(this.objectMap);
                    break;
                }
                case 27: {
                    cadObject = new Point(this.objectMap);
                    break;
                }
                case 29: {
                    cadObject = new PolylinePFace(this.objectMap);
                    break;
                }
                case 30: {
                    cadObject = new PolylineMesh(this.objectMap);
                    break;
                }
                case 31: {
                    cadObject = new Solid(this.objectMap);
                    break;
                }
                case 34: {
                    cadObject = new ViewPort(this.objectMap);
                    break;
                }
                case 38: {
                    cadObject = new ThreeDSolid(this.objectMap);
                    break;
                }
                case 42: {
                    cadObject = new Dictionary(this.objectMap);
                    break;
                }
                case 44: {
                    cadObject = new MText(this.objectMap);
                    break;
                }
                case 45: {
                    cadObject = new Leader(this.objectMap);
                    break;
                }
                case 48: {
                    cadObject = new BlockControlObj(this.objectMap);
                    break;
                }
                case 49: {
                    cadObject = new BlockHeader(this.objectMap);
                    break;
                }
                case 50: {
                    cadObject = new LayerControlObj(this.objectMap);
                    break;
                }
                case 51: {
                    cadObject = new Layer(this.objectMap);
                    break;
                }
                case 52: {
                    cadObject = new StyleControlObj(this.objectMap);
                    break;
                }
                case 53: {
                    cadObject = new Style(this.objectMap);
                    break;
                }
                case 56: {
                    cadObject = new LTypeControlObj(this.objectMap);
                    break;
                }
                case 57: {
                    cadObject = new LType(this.objectMap);
                    break;
                }
                case 60: {
                    cadObject = new ViewControlObj(this.objectMap);
                    break;
                }
                case 61: {
                    cadObject = new View(this.objectMap);
                    break;
                }
                case 62: {
                    cadObject = new UcsControlObj(this.objectMap);
                    break;
                }
                case 63: {
                    cadObject = new Ucs(this.objectMap);
                    break;
                }
                case 64: {
                    cadObject = new VPortControlObj(this.objectMap);
                    break;
                }
                case 65: {
                    cadObject = new VPort(this.objectMap);
                    break;
                }
                case 66: {
                    cadObject = new AppidControlObj(this.objectMap);
                    break;
                }
                case 67: {
                    cadObject = new Appid(this.objectMap);
                    break;
                }
                case 68: {
                    cadObject = new DimstyleControlObj(this.objectMap);
                    break;
                }
                case 69: {
                    cadObject = new DimStyle(this.objectMap);
                    break;
                }
                case 73: {
                    cadObject = new MLineStyle(this.objectMap);
                    break;
                }
                case 77: {
                    cadObject = new LwPolyline(this.objectMap);
                    break;
                }
                case 78: {
                    cadObject = new Hatch(this.objectMap);
                    break;
                }
                case 79: {
                    cadObject = new XRecord(this.objectMap);
                    break;
                }
                case 80: {
                    cadObject = new AcdbPlaceHolder(this.objectMap);
                    break;
                }
                case 82: {
                    cadObject = new Layout(this.objectMap);
                    break;
                }
                default: {
                    cadObject = new GenericObject(this.objectMap, objectType);
                }
            }
        }
        this.doneObjects.put(offsetIntoObjectMap, cadObject);
        cadObject.readFromStreams(dataStream, stringStream, handleStream, this.fileVersion);
        return cadObject;
    }

    protected Long getOffsetIntoObjectMap(Handle h) {
        Long offsetIntoObjectMap = null;
        for (ObjectMapSection section : this.objectMapSections) {
            int offset = h.offset;
            offsetIntoObjectMap = section.locationMap.get(offset);
            if (offsetIntoObjectMap == null) continue;
            break;
        }
        return offsetIntoObjectMap;
    }

    int crc(byte[] p, int n, int seed) {
        int invertedCrc = ~seed;
        for (int index = 0; index < n; ++index) {
            byte b = p[index];
            int i = invertedCrc >> 8 & 0xFFFFFF;
            invertedCrc = i ^ this.crc32Table[(invertedCrc ^ b) & 0xFF];
        }
        return ~invertedCrc;
    }

    private void readSystemSectionPage(ByteBuffer buffer, long sectionPageMapAddress, int sectionMapId) {
        if (256L + sectionPageMapAddress > Integer.MAX_VALUE) {
            throw new RuntimeException("sectionPageMapAddress is too big for us.");
        }
        buffer.position(256 + (int)sectionPageMapAddress);
        SectionPage sectionPage = this.readSystemSectionPage(buffer, 1097010747);
        ByteBuffer expandedBuffer = ByteBuffer.wrap(sectionPage.expandedData);
        expandedBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int address = 256;
        do {
            int sectionPageNumber = expandedBuffer.getInt();
            int sectionSize = expandedBuffer.getInt();
            if (sectionPageNumber > 0) {
                this.sections.add(new Section(sectionPageNumber, address, sectionSize));
            } else {
                int parent = expandedBuffer.getInt();
                int left = expandedBuffer.getInt();
                int right = expandedBuffer.getInt();
                int hex00 = expandedBuffer.getInt();
                this.sections.add(new SectionGap(sectionPageNumber, address, sectionSize, parent, left, right));
            }
            address += sectionSize;
        } while (expandedBuffer.position() != sectionPage.expandedData.length);
        Section sectionMap = null;
        for (Section eachSection : this.sections) {
            if (eachSection.sectionPageNumber != sectionMapId) continue;
            sectionMap = eachSection;
            break;
        }
        buffer.position(sectionMap.address);
        SectionPage sectionPage2 = this.readSystemSectionPage(buffer, 1097007163);
        ByteBuffer sectionPageBuffer = ByteBuffer.wrap(sectionPage2.expandedData);
        sectionPageBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int numDescriptions = sectionPageBuffer.getInt();
        int hex02 = sectionPageBuffer.getInt();
        int hex7400 = sectionPageBuffer.getInt();
        int hex00 = sectionPageBuffer.getInt();
        int unknown2 = sectionPageBuffer.getInt();
        for (int i = 0; i < numDescriptions; ++i) {
            String sectionName;
            int index;
            long sizeOfSection = sectionPageBuffer.getLong();
            int pageCount = sectionPageBuffer.getInt();
            int maxDecompressedSize = sectionPageBuffer.getInt();
            int unknown3 = sectionPageBuffer.getInt();
            int compressed = sectionPageBuffer.getInt();
            int sectionId = sectionPageBuffer.getInt();
            int encrypted = sectionPageBuffer.getInt();
            switch (compressed) {
                case 1: {
                    boolean isCompressed = false;
                    break;
                }
                case 2: {
                    boolean isCompressed = true;
                    break;
                }
                default: {
                    throw new RuntimeException("bad enum");
                }
            }
            switch (compressed) {
                case 0: {
                    Boolean isEncrypted = false;
                    break;
                }
                case 1: {
                    Boolean isEncrypted = true;
                    break;
                }
                case 2: {
                    Boolean isEncrypted = null;
                    break;
                }
                default: {
                    throw new RuntimeException("bad enum");
                }
            }
            byte[] sectionNameAsBytes = new byte[64];
            sectionPageBuffer.get(sectionNameAsBytes);
            for (index = 0; index != 64 && sectionNameAsBytes[index] != 0; ++index) {
            }
            try {
                sectionName = new String(sectionNameAsBytes, 0, index, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (sectionName.equals("AcDb:Header")) {
                int pageNumber = sectionPageBuffer.getInt();
                int dataSize = sectionPageBuffer.getInt();
                long startOffset = sectionPageBuffer.getLong();
                Section classesData = null;
                for (Section eachSection : this.sections) {
                    if (eachSection.sectionPageNumber != pageNumber) continue;
                    classesData = eachSection;
                    break;
                }
                buffer.position(classesData.address);
                int secMask = 0x4164536B ^ classesData.address;
                int typeA = buffer.getInt();
                int typeB = typeA ^ secMask;
                int sectionPageType = typeA ^ classesData.address;
                int sectionNumber = buffer.getInt() ^ secMask;
                int dataSize2 = buffer.getInt() ^ secMask;
                int pageSize = buffer.getInt() ^ secMask;
                int startOffset2 = buffer.getInt() ^ secMask;
                int pageHeaderChecksum = buffer.getInt() ^ secMask;
                int dataChecksum = buffer.getInt() ^ secMask;
                int unknown5 = buffer.getInt() ^ secMask;
                byte[] compressedData = new byte[dataSize2];
                buffer.get(compressedData);
                byte[] expandedData = new Expander((byte[])compressedData, (int)maxDecompressedSize).result;
                ByteBuffer headerBuffer = ByteBuffer.wrap(expandedData);
                headerBuffer.order(ByteOrder.LITTLE_ENDIAN);
                byte[] headerSignature = new byte[]{-49, 123, 31, 35, -3, -34, 56, -87, 95, 124, 104, -72, 78, 109, 51, 95};
                BitStreams bitStreams = new BitStreams(expandedData, headerSignature, this.fileVersion, this.issues);
                this.header = new Header(bitStreams, this.fileVersion);
                continue;
            }
            if (sectionName.equals("AcDb:Handles")) {
                byte[] expandedData = this.combinePages(buffer, sectionPageBuffer, pageCount, maxDecompressedSize);
                ByteBuffer classesBuffer = ByteBuffer.wrap(expandedData);
                classesBuffer.order(ByteOrder.BIG_ENDIAN);
                this.objectMapSections = new ArrayList<ObjectMapSection>();
                short sectionSize = classesBuffer.getShort();
                while (sectionSize != 2) {
                    ObjectMapSection section = new ObjectMapSection();
                    int lastHandle = 0;
                    long lastLoc = 0L;
                    int endPosition = classesBuffer.position() - 2 + sectionSize;
                    while (classesBuffer.position() != endPosition) {
                        int handleOffset = BitStreams.getUnsignedMC(classesBuffer);
                        int locationOffset = BitStreams.getMC(classesBuffer);
                        section.add(lastHandle += handleOffset, lastLoc += (long)locationOffset);
                    }
                    short crc = classesBuffer.getShort();
                    this.objectMapSections.add(section);
                    sectionSize = classesBuffer.getShort();
                }
                continue;
            }
            if (sectionName.equals("AcDb:AcDbObjects")) {
                byte[] combinedBuffer = this.combinePages(buffer, sectionPageBuffer, pageCount, maxDecompressedSize);
                this.objectBuffer = combinedBuffer;
                continue;
            }
            if (sectionName.equals("AcDb:Classes")) {
                byte[] combinedBuffer = this.combinePages(buffer, sectionPageBuffer, pageCount, maxDecompressedSize);
                byte[] classesSignature = new byte[]{-115, -95, -60, -72, -60, -87, -8, -59, -64, -36, -12, 95, -25, -49, -74, -118};
                BitStreams bitStreams = new BitStreams(combinedBuffer, classesSignature, this.fileVersion, this.issues);
                BitBuffer bitClasses = bitStreams.getDataStream();
                BitBuffer bitClassesStrings = bitStreams.getStringStream();
                int maximumClassNumber = bitClasses.getBL();
                boolean unknownBool = bitClasses.getB();
                do {
                    ClassData classData = new ClassData(bitClasses, bitClassesStrings);
                    this.classes.add(classData);
                } while (bitClasses.hasMoreData());
                assert (!bitClassesStrings.hasMoreData());
                int expectedNumberOfClasses = maximumClassNumber - 499;
                assert (this.classes.size() == expectedNumberOfClasses);
                continue;
            }
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                int pageNumber = sectionPageBuffer.getInt();
                int dataSize = sectionPageBuffer.getInt();
                long l = sectionPageBuffer.getLong();
            }
        }
    }

    private byte[] combinePages(ByteBuffer buffer, ByteBuffer sectionPageBuffer, int pageCount, int maxDecompressedSize) {
        ArrayList<byte[]> objectBuffers = new ArrayList<byte[]>();
        int totalSize = 0;
        for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
            int pageNumber = sectionPageBuffer.getInt();
            int dataSize = sectionPageBuffer.getInt();
            long startOffset = sectionPageBuffer.getLong();
            Section classesData = null;
            for (Section eachSection : this.sections) {
                if (eachSection.sectionPageNumber != pageNumber) continue;
                classesData = eachSection;
                break;
            }
            buffer.position(classesData.address + 32);
            byte[] compressedData = new byte[dataSize];
            buffer.get(compressedData);
            byte[] expandedData = new Expander((byte[])compressedData, (int)maxDecompressedSize).result;
            objectBuffers.add(expandedData);
            totalSize += expandedData.length;
        }
        byte[] combinedBuffer = new byte[totalSize];
        int offset = 0;
        Iterator i$ = objectBuffers.iterator();
        while (i$.hasNext()) {
            byte[] objectBufferPart;
            for (byte b : objectBufferPart = (byte[])i$.next()) {
                combinedBuffer[offset++] = b;
            }
        }
        return combinedBuffer;
    }

    private SectionPage readSystemSectionPage(ByteBuffer buffer, int expectedPageType) {
        int pageType = buffer.getInt();
        int decompressedSize = buffer.getInt();
        int compressedSize = buffer.getInt();
        int compressionType = buffer.getInt();
        int sectionPageChecksum = buffer.getInt();
        byte[] compressedData = new byte[compressedSize];
        buffer.get(compressedData);
        int pageType2 = buffer.getInt();
        int decompressedSize2 = buffer.getInt();
        int compressedSize2 = buffer.getInt();
        int compressionType2 = buffer.getInt();
        int sectionPageChecksum2 = buffer.getInt();
        if (pageType != expectedPageType) {
            throw new RuntimeException();
        }
        byte[] expandedData = new Expander((byte[])compressedData, (int)decompressedSize).result;
        SectionPage result = new SectionPage(pageType, expandedData);
        return result;
    }

    private void expectInt(ByteBuffer buffer, int expected) {
        int actual = buffer.getInt();
        if (actual != expected) {
            this.issues.addWarning("expected " + expected + " at position " + (buffer.position() - 1) + " (4 bytes) but found " + actual + ".");
        }
    }

    private void expect(ByteBuffer buffer, byte[] expectedBytes) {
        for (byte expectedByte : expectedBytes) {
            this.expect(buffer, expectedByte);
        }
    }

    private void expect(ByteBuffer buffer, byte expectedByte) {
        byte actual = buffer.get();
        if (actual != expectedByte) {
            this.issues.addWarning("expected " + expectedByte + " at position " + (buffer.position() - 1) + " but found " + actual + ".");
        }
    }

    private void expectAnyOneOf(ByteBuffer buffer, byte[] expectedBytes) {
        byte actual = buffer.get();
        for (byte expectedByte : expectedBytes) {
            if (actual != expectedByte) continue;
            return;
        }
        this.issues.addWarning("expected one of " + expectedBytes.length + " options at position " + (buffer.position() - 1) + " but found " + actual + ".");
    }

    public String getVersion() {
        return this.fileVersion.getVersionYear();
    }

    public Layer getCLayer() {
        CadObject result = this.parseObject(this.header.CLAYER.get());
        return (Layer)result;
    }

    public LayerControlObj getLayerControlObject() {
        CadObject result = this.parseObject(this.header.LAYER_CONTROL_OBJECT.get());
        return (LayerControlObj)result;
    }

    public CadObject getTextStyle() {
        CadObject result = this.parseObject(this.header.TEXTSTYLE.get());
        return result;
    }

    public CadObject getCelType() {
        CadObject result = this.parseObject(this.header.CELTYPE.get());
        return result;
    }

    public CadObject getCMaterial() {
        CadObject result = this.parseObject(this.header.CMATERIAL.get());
        return result;
    }

    public CadObject getDimStyle() {
        CadObject result = this.parseObject(this.header.DIMSTYLE.get());
        return result;
    }

    public CadObject getCmlStyle() {
        CadObject result = this.parseObject(this.header.CMLSTYLE.get());
        return result;
    }

    public CadObject getDimTxSty() {
        CadObject result = this.parseObject(this.header.DIMTXSTY.get());
        return result;
    }

    public CadObject getDimLdrBlk() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.header.DIMLDRBLK.get());
        return result;
    }

    public CadObject getDimBlk() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.header.DIMBLK.get());
        return result;
    }

    public CadObject getDimBlk1() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.header.DIMBLK1.get());
        return result;
    }

    public CadObject getDimBlk2() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.header.DIMBLK2.get());
        return result;
    }

    public CadObject getDimLType() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.header.DIMLTYPE.get());
        return result;
    }

    public CadObject getDimLTex1() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.header.DIMLTEX1.get());
        return result;
    }

    public CadObject getDimLTex2() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.header.DIMLTEX2.get());
        return result;
    }

    public BlockControlObj getBlockControlObject() {
        CadObject result = this.parseObject(this.header.BLOCK_CONTROL_OBJECT.get());
        return (BlockControlObj)result;
    }

    public CadObject getStyleControlObject() {
        CadObject result = this.parseObject(this.header.STYLE_CONTROL_OBJECT.get());
        return result;
    }

    public CadObject getLinetypeControlObject() {
        CadObject result = this.parseObject(this.header.LINETYPE_CONTROL_OBJECT.get());
        return result;
    }

    public CadObject getViewControlObject() {
        CadObject result = this.parseObject(this.header.VIEW_CONTROL_OBJECT.get());
        return result;
    }

    public CadObject getUcsControlObject() {
        CadObject result = this.parseObject(this.header.UCS_CONTROL_OBJECT.get());
        return result;
    }

    public CadObject getVPortControlObject() {
        CadObject result = this.parseObject(this.header.VPORT_CONTROL_OBJECT.get());
        return result;
    }

    public CadObject getAppidControlObject() {
        CadObject result = this.parseObject(this.header.APPID_CONTROL_OBJECT.get());
        return result;
    }

    public CadObject getDimStyleControlObject() {
        CadObject result = this.parseObject(this.header.DIMSTYLE_CONTROL_OBJECT.get());
        return result;
    }

    public CadObject getDictionaryAcadGroup() {
        CadObject result = this.parseObject(this.header.DICTIONARY_ACAD_GROUP.get());
        return result;
    }

    public CadObject getDictionaryAcadMLineStyle() {
        CadObject result = this.parseObject(this.header.DICTIONARY_ACAD_MLINESTYLE.get());
        return result;
    }

    public CadObject getDictionaryNamedObjects() {
        CadObject result = this.parseObject(this.header.DICTIONARY_NAMED_OBJECTS.get());
        return result;
    }

    public CadObject getDictionaryLayouts() {
        CadObject result = this.parseObject(this.header.DICTIONARY_LAYOUTS.get());
        return result;
    }

    public CadObject getDictionaryPlotsettings() {
        CadObject result = this.parseObject(this.header.DICTIONARY_PLOTSETTINGS.get());
        return result;
    }

    public CadObject getDictionaryPlotstyles() {
        CadObject result = this.parseObject(this.header.DICTIONARY_PLOTSTYLES.get());
        return result;
    }

    public CadObject getDictionaryMaterials() {
        CadObject result = this.parseObject(this.header.DICTIONARY_MATERIALS.get());
        return result;
    }

    public CadObject getDictionaryColors() {
        CadObject result = this.parseObject(this.header.DICTIONARY_COLORS.get());
        return result;
    }

    public CadObject getDictionaryVisualstyle() {
        CadObject result = this.parseObject(this.header.DICTIONARY_VISUALSTYLE.get());
        return result;
    }

    public CadObject getUnknown() {
        if (this.header.UNKNOWN.get() == null) {
            return null;
        }
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.header.UNKNOWN.get());
        return result;
    }

    public CadObject getCpsnid() {
        if (this.header.CPSNID.get() == null) {
            return null;
        }
        CadObject result = this.parseObject(this.header.CPSNID.get());
        return result;
    }

    public CadObject getBlockRecordPaperSpace() {
        CadObject result = this.parseObject(this.header.BLOCK_RECORD_PAPER_SPACE.get());
        return result;
    }

    public CadObject getBlockRecordModelSpace() {
        CadObject result = this.parseObject(this.header.BLOCK_RECORD_MODEL_SPACE.get());
        return result;
    }

    public CadObject getLTypeByLayer() {
        CadObject result = this.parseObject(this.header.LTYPE_BYLAYER.get());
        return result;
    }

    public CadObject getLTypeByBlock() {
        CadObject result = this.parseObject(this.header.LTYPE_BYBLOCK.get());
        return result;
    }

    public CadObject getLTypeContinuous() {
        CadObject result = this.parseObject(this.header.LTYPE_CONTINUOUS.get());
        return result;
    }

    public CadObject getInterfereObjvs() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.header.INTERFEREOBJVS.get());
        return result;
    }

    public CadObject getInterfereVpvs() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.header.INTERFEREVPVS.get());
        return result;
    }

    public CadObject getDragvs() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.header.DRAGVS.get());
        return result;
    }

    @Override
    public void close() throws Exception {
    }

    public Issues getIssues() {
        return this.issues;
    }

    public class SectionGap
    extends Section {
        final int parent;
        final int left;
        final int right;

        public SectionGap(int sectionPageNumber, int address, int sectionSize, int parent, int left, int right) {
            super(sectionPageNumber, address, sectionSize);
            this.parent = parent;
            this.left = left;
            this.right = right;
        }
    }

    public class Section {
        final int sectionPageNumber;
        final int address;
        final int sectionSize;

        public Section(int sectionPageNumber, int address, int sectionSize) {
            this.sectionPageNumber = sectionPageNumber;
            this.address = address;
            this.sectionSize = sectionSize;
        }
    }
}

