/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.bitstreams;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.Issues;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class BitStreams {
    private byte[] byteArray;
    private Issues issues;
    private int dataStreamStart;
    private int stringStreamStart;
    private int stringStreamEnd;
    private int endDataPosition;
    private int handleStreamEnd;

    public BitStreams(byte[] byteArray, byte[] signature, FileVersion fileVersion, Issues issues) {
        this.byteArray = byteArray;
        this.issues = issues;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] actualSignature = new byte[16];
        byteBuffer.get(actualSignature);
        if (!Arrays.equals(actualSignature, signature)) {
            throw new RuntimeException("bad signature: ");
        }
        int sizeOfDataArea = byteBuffer.getInt();
        int unknown75 = byteBuffer.getInt();
        int totalSizeInBits = byteBuffer.getInt();
        int position = byteBuffer.position();
        this.dataStreamStart = position * 8;
        this.endDataPosition = 192 + totalSizeInBits;
        BitBuffer bitBuffer = BitBuffer.wrap(byteArray, issues);
        this.identifyStringStream(bitBuffer);
        this.handleStreamEnd = byteArray.length * 8;
    }

    public BitStreams(byte[] objectBuffer, int byteOffset, Issues issues) {
        this.byteArray = objectBuffer;
        this.issues = issues;
        ByteBuffer objectsBuffer = ByteBuffer.wrap(objectBuffer);
        objectsBuffer.order(ByteOrder.LITTLE_ENDIAN);
        objectsBuffer.position(byteOffset);
        int sizeOfObject = BitStreams.getMS(objectsBuffer);
        int bitSizeOfHandleStream = BitStreams.getUnsignedMC(objectsBuffer);
        this.dataStreamStart = objectsBuffer.position() * 8;
        int bitSizeOfObjectData = sizeOfObject * 8 - bitSizeOfHandleStream;
        this.endDataPosition = this.dataStreamStart + bitSizeOfObjectData;
        this.handleStreamEnd = this.endDataPosition + bitSizeOfHandleStream;
        BitBuffer bitBuffer = BitBuffer.wrap(this.byteArray, issues);
        this.identifyStringStream(bitBuffer);
    }

    private void identifyStringStream(BitBuffer bitBuffer) {
        int strDataSize;
        int position = this.endDataPosition;
        bitBuffer.position(--position);
        boolean endBit = bitBuffer.getB();
        if (endBit) {
            bitBuffer.position(position -= 16);
            strDataSize = bitBuffer.getRS();
            if ((strDataSize & 0x8000) != 0) {
                bitBuffer.position(position -= 16);
                int hiSize = bitBuffer.getRS();
                int loSize = -strDataSize;
                strDataSize = hiSize << 15 | loSize;
            }
        } else {
            strDataSize = 0;
        }
        this.stringStreamEnd = position;
        this.stringStreamStart = position - strDataSize;
    }

    public BitBuffer getDataStream() {
        BitBuffer dataStream = BitBuffer.wrap(this.byteArray, this.issues);
        dataStream.position(this.dataStreamStart);
        dataStream.setEndOffset(this.stringStreamStart);
        return dataStream;
    }

    public BitBuffer getStringStream() {
        BitBuffer stringStream = BitBuffer.wrap(this.byteArray, this.issues);
        stringStream.position(this.stringStreamStart);
        stringStream.setEndOffset(this.stringStreamEnd);
        return stringStream;
    }

    public BitBuffer getHandleStream() {
        BitBuffer handleStream = BitBuffer.wrap(this.byteArray, this.issues);
        handleStream.position(this.endDataPosition);
        handleStream.setEndOffset(this.handleStreamEnd);
        return handleStream;
    }

    public static int getMC(ByteBuffer buffer) {
        int result = 0;
        int shift = 0;
        byte b = buffer.get();
        while ((b & 0x80) != 0) {
            int byteValue = b & 0x7F;
            result |= byteValue << shift;
            shift += 7;
            b = buffer.get();
        }
        boolean signBit = (b & 0x40) != 0;
        int byteValue = b & 0x3F;
        result |= byteValue << shift;
        if (signBit) {
            result = -result;
        }
        return result;
    }

    public static int getUnsignedMC(ByteBuffer buffer) {
        boolean highBit;
        int result = 0;
        int shift = 0;
        do {
            byte b;
            highBit = ((b = buffer.get()) & 0x80) != 0;
            int byteValue = b & 0x7F;
            result |= byteValue << shift;
            shift += 7;
        } while (highBit);
        return result;
    }

    public static int getMS(ByteBuffer buffer) {
        boolean highBit;
        int result = 0;
        int shift = 0;
        assert (buffer.order() == ByteOrder.LITTLE_ENDIAN);
        do {
            short word;
            highBit = ((word = buffer.getShort()) & 0x8000) != 0;
            int wordValue = word & Short.MAX_VALUE;
            result |= wordValue << shift;
            shift += 15;
        } while (highBit);
        return result;
    }
}

