/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.bitstreams.Point3D;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.Insert;
import com.onespatial.dwglib.objects.NonEntityObject;
import com.onespatial.dwglib.objects.ObjectMap;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class BlockHeader
extends NonEntityObject {
    public String entryName;
    public boolean sixtyFourFlag;
    private boolean blockIsXref;
    private boolean xrefOverlaid;
    public boolean loadedBit;
    public Point3D basePoint;
    public String xrefPName;
    public String blockDescription;
    private int[] previewData;
    public int insertUnits;
    public boolean explodable;
    public int blockScaling;
    private Handle firstEntityHandle;
    private Handle lastEntityHandle;
    private Handle[] ownedObjectHandles;
    private Handle endBlockHandle;
    private List<List<Handle>> insertHandles;
    private Handle layoutHandle;

    public BlockHeader(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        this.entryName = stringStream.getTU();
        this.sixtyFourFlag = dataStream.getB();
        boolean xdep = dataStream.getB();
        boolean anonymous = dataStream.getB();
        boolean hasAttributes = dataStream.getB();
        this.blockIsXref = dataStream.getB();
        this.xrefOverlaid = dataStream.getB();
        this.loadedBit = dataStream.getB();
        int ownedObjectCount = dataStream.getBL();
        this.basePoint = dataStream.get3BD();
        this.xrefPName = stringStream.getTU();
        ArrayList<Integer> insertCounts = new ArrayList<Integer>();
        int thisInsertCount = dataStream.getRC();
        while (thisInsertCount != 0) {
            insertCounts.add(thisInsertCount);
            thisInsertCount = dataStream.getRC();
        }
        this.blockDescription = stringStream.getTU();
        int sizeOfPreviewData = dataStream.getBL();
        this.previewData = dataStream.getBytes(sizeOfPreviewData);
        this.insertUnits = dataStream.getBS();
        this.explodable = dataStream.getB();
        this.blockScaling = dataStream.getRC();
        if (!this.blockIsXref && !this.xrefOverlaid) {
            this.firstEntityHandle = handleStream.getHandle(this.handleOfThisObject);
            this.lastEntityHandle = handleStream.getHandle(this.handleOfThisObject);
        }
        this.ownedObjectHandles = new Handle[ownedObjectCount];
        for (int i = 0; i < ownedObjectCount; ++i) {
            this.ownedObjectHandles[i] = handleStream.getHandle();
        }
        this.endBlockHandle = handleStream.getHandle();
        this.insertHandles = new ArrayList<List<Handle>>();
        for (Integer insertCount : insertCounts) {
            ArrayList<Handle> thisList = new ArrayList<Handle>();
            for (int i = 0; i < insertCount; ++i) {
                Handle insertHandle = handleStream.getHandle();
                thisList.add(insertHandle);
            }
            this.insertHandles.add(thisList);
        }
        this.layoutHandle = handleStream.getHandle();
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "BLOCK HEADER";
    }

    public CadObject getFirstEntity() {
        if (this.firstEntityHandle == null) {
            return null;
        }
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.firstEntityHandle);
        return result;
    }

    public CadObject getLastEntity() {
        if (this.lastEntityHandle == null) {
            return null;
        }
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.lastEntityHandle);
        return result;
    }

    public List<CadObject> getOwnedObjects() {
        return new AbstractList<CadObject>(){

            @Override
            public CadObject get(int index) {
                CadObject result = BlockHeader.this.objectMap.parseObject(BlockHeader.this.ownedObjectHandles[index]);
                return result;
            }

            @Override
            public int size() {
                return BlockHeader.this.ownedObjectHandles.length;
            }
        };
    }

    public CadObject getEndBlock() {
        CadObject result = this.objectMap.parseObject(this.endBlockHandle);
        return result;
    }

    public List<Insert> getInserts() {
        ArrayList<Insert> result = new ArrayList<Insert>();
        for (List<Handle> x : this.insertHandles) {
            for (Handle y : x) {
                CadObject insert = this.objectMap.parseObjectPossiblyOrphaned(y);
                result.add((Insert)insert);
            }
        }
        return result;
    }

    public CadObject getLayout() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.layoutHandle);
        return result;
    }
}

