/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.NonEntityObject;
import com.onespatial.dwglib.objects.ObjectMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Dictionary
extends NonEntityObject {
    public Map<String, Handle> dictionaryMap;

    public Dictionary(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        this.readCommonDictionaryData(dataStream, stringStream, handleStream);
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    protected void readCommonDictionaryData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream) {
        int numItems = dataStream.getBL();
        int cloningFlag = dataStream.getBS();
        int hardOwnerFlag = dataStream.getRC();
        this.dictionaryMap = new HashMap<String, Handle>();
        for (int i = 0; i < numItems; ++i) {
            String key = stringStream.getTU();
            Handle handle = handleStream.getHandle(this.handleOfThisObject);
            this.dictionaryMap.put(key, handle);
        }
    }

    public String toString() {
        return "DICTIONARY";
    }

    public CadObject lookupObject(String key) {
        Handle handle = this.dictionaryMap.get(key);
        return this.objectMap.parseObjectPossiblyNull(handle);
    }

    public Set<String> getKeys() {
        return this.dictionaryMap.keySet();
    }
}

