/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.CmColor;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.Dictionary;
import com.onespatial.dwglib.objects.Insert;
import com.onespatial.dwglib.objects.LType;
import com.onespatial.dwglib.objects.Layer;
import com.onespatial.dwglib.objects.NonEntityObject;
import com.onespatial.dwglib.objects.ObjectMap;

public abstract class EntityObject
extends CadObject {
    public Handle parentHandle;
    private Handle layerHandle;
    private Handle linetypeHandle;
    private Handle materialHandle;
    private Handle plotstyleHandle;

    public EntityObject(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readPostCommonFields(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        boolean xDicMissingFlag;
        Handle reactorHandle;
        boolean hasOwnerHandleReference;
        boolean graphicImageFlag = dataStream.getB();
        if (graphicImageFlag) {
            long sizeOfGraphicImageInBytes = dataStream.getBLL();
            int i = 0;
            while ((long)i < sizeOfGraphicImageInBytes * 8L) {
                dataStream.getB();
                ++i;
            }
        }
        int entMode = dataStream.getBB();
        switch (entMode) {
            case 0: {
                hasOwnerHandleReference = true;
                break;
            }
            case 1: {
                hasOwnerHandleReference = false;
                break;
            }
            case 2: {
                hasOwnerHandleReference = false;
                break;
            }
            default: {
                throw new RuntimeException("unexpected value for 'entMode': 3");
            }
        }
        int numReactors = dataStream.getBS();
        boolean hasBinaryData = false;
        if (fileVersion.is2013OrLater()) {
            hasBinaryData = dataStream.getB();
        }
        boolean areLinkersPresent = dataStream.getB();
        CmColor entityColor = dataStream.getENC();
        double linetypeScale = dataStream.getBD();
        int linetypeFlag = dataStream.getBB();
        int plotstyleFlag = dataStream.getBB();
        int materialFlag = dataStream.getBB();
        int shadowFlags = dataStream.getRC();
        boolean hasFullVisualStyle = dataStream.getB();
        boolean hasFaceVisualStyle = dataStream.getB();
        boolean hasEdgeVisualStyle = dataStream.getB();
        int isInvisible = dataStream.getBS();
        int entityLineweightFlag = dataStream.getRC();
        if (hasOwnerHandleReference) {
            this.parentHandle = handleStream.getHandle(this.handleOfThisObject);
        }
        this.reactorHandles = new Handle[numReactors];
        for (int i = 0; i < numReactors; ++i) {
            this.reactorHandles[i] = reactorHandle = handleStream.getHandle(this.handleOfThisObject);
        }
        boolean bl = xDicMissingFlag = hasBinaryData || !fileVersion.is2013OrLater();
        if (!xDicMissingFlag) {
            reactorHandle = handleStream.getHandle();
        }
        this.layerHandle = handleStream.getHandle();
        CadObject myLayer = this.objectMap.parseObject(this.layerHandle);
        if (myLayer instanceof Dictionary) {
            this.layerHandle = handleStream.getHandle();
            CadObject cadObject = this.objectMap.parseObject(this.layerHandle);
        }
        if (linetypeFlag == 3) {
            this.linetypeHandle = handleStream.getHandle();
        }
        if (materialFlag == 3) {
            this.materialHandle = handleStream.getHandle();
        }
        if (plotstyleFlag == 3) {
            this.plotstyleHandle = handleStream.getHandle();
        }
        this.readObjectTypeSpecificData(dataStream, stringStream, handleStream, fileVersion);
    }

    public Layer getLayer() {
        CadObject result = this.objectMap.parseObject(this.layerHandle);
        if (this instanceof Insert && result instanceof Dictionary) {
            return null;
        }
        return (Layer)result;
    }

    public LType getLinetype() {
        if (this.linetypeHandle == null) {
            return null;
        }
        CadObject result = this.objectMap.parseObject(this.linetypeHandle);
        return (LType)result;
    }

    public NonEntityObject getMaterial() {
        if (this.materialHandle == null) {
            return null;
        }
        CadObject result = this.objectMap.parseObject(this.materialHandle);
        return (NonEntityObject)result;
    }

    public NonEntityObject getPlotstyle() {
        if (this.plotstyleHandle == null) {
            return null;
        }
        CadObject result = this.objectMap.parseObject(this.plotstyleHandle);
        return (NonEntityObject)result;
    }
}

