/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.bitstreams.Point2D;
import com.onespatial.dwglib.bitstreams.Point3D;
import com.onespatial.dwglib.objects.EntityObject;
import com.onespatial.dwglib.objects.ObjectMap;

public class Hatch
extends EntityObject {
    public Point3D start;
    public Point3D end;
    public double thickness;
    public Point3D extrusion;
    public int isGradientFill;
    public int reserved;
    public double gradientAngle;
    public double gradientShift;
    public int singleColorGradient;
    public double gradientTint;
    public GradientColor[] gradientColors;
    public String gradientName;
    public double zCoordinate;
    public Point3D extrusion2;
    public String name;
    public boolean associative;
    public Path[] paths;
    public int style;
    public int patternType;
    public Fill fill;
    public double pixelSize;
    public Point2D[] seedPoints;

    public Hatch(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        this.isGradientFill = dataStream.getBL();
        this.reserved = dataStream.getBL();
        this.gradientAngle = dataStream.getBD();
        this.gradientShift = dataStream.getBD();
        this.singleColorGradient = dataStream.getBL();
        this.gradientTint = dataStream.getBD();
        int numberOfGradientColors = dataStream.getBL();
        this.gradientColors = new GradientColor[numberOfGradientColors];
        for (int i = 0; i < numberOfGradientColors; ++i) {
            this.gradientColors[i].unknownDouble = dataStream.getBD();
            this.gradientColors[i].unknownShort = dataStream.getBS();
            this.gradientColors[i].rgbColor = dataStream.getBL();
            this.gradientColors[i].ignoredColorByte = dataStream.getRC();
        }
        this.gradientName = stringStream.getTU();
        this.zCoordinate = dataStream.getBD();
        this.extrusion2 = dataStream.get3BD();
        this.name = stringStream.getTU();
        boolean solidFill = dataStream.getB();
        this.associative = dataStream.getB();
        boolean pixelSizePresent = false;
        int numPaths = dataStream.getBL();
        this.paths = new Path[numPaths];
        for (int i = 0; i < numPaths; ++i) {
            int pathFlag = dataStream.getBL();
            this.paths[i] = (pathFlag & 2) == 0 ? new SegmentedPath() : new PolylinePath();
            this.paths[i].readFromDataStream(dataStream, handleStream, fileVersion);
            int unknown = dataStream.getBL();
            pixelSizePresent |= (pathFlag & 4) != 0;
        }
        this.style = dataStream.getBS();
        this.patternType = dataStream.getBS();
        if (!solidFill) {
            this.fill = new Fill();
            this.fill.readFromDataStream(dataStream);
        }
        if (pixelSizePresent) {
            this.pixelSize = dataStream.getBD();
        }
        int numSeedPoints = dataStream.getBL();
        this.seedPoints = new Point2D[numSeedPoints];
        for (int i = 0; i < numSeedPoints; ++i) {
            this.seedPoints[i] = dataStream.get2RD();
        }
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "HATCH";
    }

    public class SplinePathType
    extends PathType {
        public int degree;
        public boolean isPeriodic;
        public double[] knots;
        public ControlPoint[] controlPoints;
        public Point2D[] fitPoints;
        public Point2D startTangent;
        public Point2D endTanget;

        @Override
        public void readFromDataStream(BitBuffer dataStream, FileVersion fileVersion) {
            int i;
            this.degree = dataStream.getBL();
            boolean isRational = dataStream.getB();
            this.isPeriodic = dataStream.getB();
            int numKnots = dataStream.getBL();
            int numControlPoints = dataStream.getBL();
            this.knots = new double[numKnots];
            for (i = 0; i < numKnots; ++i) {
                this.knots[i] = dataStream.getBD();
            }
            this.controlPoints = new ControlPoint[numControlPoints];
            for (i = 0; i < numControlPoints; ++i) {
                this.controlPoints[i] = new ControlPoint();
                this.controlPoints[i].pt0 = dataStream.get2RD();
                if (!isRational) continue;
                this.controlPoints[i].weight = dataStream.getBD();
            }
            if (!fileVersion.is2013OrLater()) {
                int numFitPoints = dataStream.getBL();
                this.fitPoints = new Point2D[numFitPoints];
                for (int i2 = 0; i2 < numFitPoints; ++i2) {
                    this.fitPoints[i2] = dataStream.get2RD();
                }
                this.startTangent = dataStream.get2RD();
                this.endTanget = dataStream.get2RD();
            }
        }
    }

    public class ElipticalArcPathType
    extends PathType {
        public Point2D pt0;
        public Point2D endPoint;
        public double minorMajorRatio;
        public double startAngle;
        public double endAngle;
        public boolean isCcw;

        @Override
        public void readFromDataStream(BitBuffer dataStream, FileVersion fileVersion) {
            this.pt0 = dataStream.get2RD();
            this.endPoint = dataStream.get2RD();
            this.minorMajorRatio = dataStream.getBD();
            this.startAngle = dataStream.getBD();
            this.endAngle = dataStream.getBD();
            this.isCcw = dataStream.getB();
        }
    }

    public class CircularArcPathType
    extends PathType {
        public double pt0;
        public double radius;
        public double startAngle;
        public double endAngle;
        public boolean isCcw;

        @Override
        public void readFromDataStream(BitBuffer dataStream, FileVersion fileVersion) {
            this.pt0 = dataStream.getRD();
            this.radius = dataStream.getBD();
            this.startAngle = dataStream.getBD();
            this.endAngle = dataStream.getBD();
            this.isCcw = dataStream.getB();
        }
    }

    public class LinePathType
    extends PathType {
        public double pt0;
        public double pt1;

        @Override
        public void readFromDataStream(BitBuffer dataStream, FileVersion fileVersion) {
            this.pt0 = dataStream.getRD();
            this.pt1 = dataStream.getRD();
        }
    }

    public abstract class PathType {
        public abstract void readFromDataStream(BitBuffer var1, FileVersion var2);
    }

    public static class ControlPoint {
        public Point2D pt0;
        public double weight;
    }

    public static class GradientColor {
        public double unknownDouble;
        public int unknownShort;
        public int rgbColor;
        public int ignoredColorByte;
    }

    public static class Fill {
        public double angle;
        public Point2D pt0;
        public double scaleOrSpacing;
        public boolean doubleHatch;
        public DefLine[] defLines;

        public void readFromDataStream(BitBuffer dataStream) {
            this.angle = dataStream.getBD();
            this.pt0 = dataStream.get2RD();
            this.scaleOrSpacing = dataStream.getBD();
            this.doubleHatch = dataStream.getB();
            int numDefLines = dataStream.getBS();
            this.defLines = new DefLine[numDefLines];
            for (int i = 0; i < numDefLines; ++i) {
                this.defLines[i] = new DefLine();
                this.defLines[i].readFromDataStream(dataStream);
            }
        }
    }

    public static class DefLine {
        public double angle;
        public Point2D pt0;
        public Point2D offset;
        public double[] dashLengths;

        public void readFromDataStream(BitBuffer dataStream) {
            this.angle = dataStream.getBD();
            this.pt0 = dataStream.get2RD();
            this.offset = dataStream.get2BD();
            int numDashes = dataStream.getBL();
            this.dashLengths = new double[numDashes];
            for (int i = 0; i < numDashes; ++i) {
                this.dashLengths[i] = dataStream.getBD();
            }
        }
    }

    public abstract class Path {
        private Handle[] boundaryObjHandles;

        public abstract void readFromDataStream(BitBuffer var1, BitBuffer var2, FileVersion var3);

        public void readBoundaryItemCountAndHandles(BitBuffer dataStream, BitBuffer handleStream) {
            int numboundaryobjhandles = dataStream.getBL();
            this.boundaryObjHandles = new Handle[numboundaryobjhandles];
            for (int i = 0; i < numboundaryobjhandles; ++i) {
                this.boundaryObjHandles[i] = handleStream.getHandle(Hatch.this.handleOfThisObject);
            }
        }
    }

    public class SegmentedPath
    extends Path {
        public PathType[] pathSegments;

        @Override
        public void readFromDataStream(BitBuffer dataStream, BitBuffer handleStream, FileVersion fileVersion) {
            int numPathSegs = dataStream.getBL();
            this.pathSegments = new PathType[numPathSegs];
            for (int j = 0; j < numPathSegs; ++j) {
                int pathTypeStatus = dataStream.getRC();
                switch (pathTypeStatus) {
                    case 1: {
                        this.pathSegments[j] = new LinePathType();
                        break;
                    }
                    case 2: {
                        this.pathSegments[j] = new CircularArcPathType();
                        break;
                    }
                    case 3: {
                        this.pathSegments[j] = new ElipticalArcPathType();
                        break;
                    }
                    case 4: {
                        this.pathSegments[j] = new SplinePathType();
                        break;
                    }
                    default: {
                        throw new RuntimeException("unexpected case");
                    }
                }
                this.pathSegments[j].readFromDataStream(dataStream, fileVersion);
            }
            super.readBoundaryItemCountAndHandles(dataStream, handleStream);
        }
    }

    public class PolylinePath
    extends Path {
        public boolean bulgesPresent;
        public boolean closed;
        public PolylinePathSegment[] pathSegments;

        @Override
        public void readFromDataStream(BitBuffer dataStream, BitBuffer handleStream, FileVersion fileVersion) {
            this.bulgesPresent = dataStream.getB();
            this.closed = dataStream.getB();
            int numPathSegs = dataStream.getBL();
            this.pathSegments = new PolylinePathSegment[numPathSegs];
            for (int j = 0; j < numPathSegs; ++j) {
                this.pathSegments[j].pt0 = dataStream.get2RD();
                if (!this.bulgesPresent) continue;
                this.pathSegments[j].bulge = dataStream.getBD();
            }
            super.readBoundaryItemCountAndHandles(dataStream, handleStream);
        }
    }

    public static class PolylinePathSegment {
        public Point2D pt0;
        public double bulge;
    }
}

