/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.bitstreams.Point3D;
import com.onespatial.dwglib.objects.BlockHeader;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.EntityObject;
import com.onespatial.dwglib.objects.ObjectMap;
import java.util.AbstractList;
import java.util.List;

public class Insert
extends EntityObject {
    public Point3D insertPoint;
    public double xScaleFactor;
    public double yScaleFactor;
    public double zScaleFactor;
    public double rotation;
    public Point3D extrusion;
    private Handle blockHeaderHandle;
    private Handle[] ownedObjectHandles;
    private Handle seqEndHandle;

    public Insert(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        this.insertPoint = dataStream.get3BD();
        int dataFlags = dataStream.getBB();
        switch (dataFlags) {
            case 0: {
                this.xScaleFactor = dataStream.getRD();
                this.yScaleFactor = dataStream.getDD(this.xScaleFactor);
                this.zScaleFactor = dataStream.getDD(this.xScaleFactor);
                break;
            }
            case 1: {
                this.xScaleFactor = 1.0;
                this.yScaleFactor = dataStream.getDD(this.xScaleFactor);
                this.zScaleFactor = dataStream.getDD(this.xScaleFactor);
                break;
            }
            case 2: {
                this.yScaleFactor = this.xScaleFactor = dataStream.getRD();
                this.zScaleFactor = this.xScaleFactor;
                break;
            }
            case 3: {
                this.xScaleFactor = 1.0;
                this.yScaleFactor = 1.0;
                this.zScaleFactor = 1.0;
            }
        }
        this.rotation = dataStream.getBD();
        this.extrusion = dataStream.get3BD();
        boolean hasAttributes = dataStream.getB();
        int ownedObjectCount = 0;
        if (hasAttributes) {
            ownedObjectCount = dataStream.getBL();
        }
        this.blockHeaderHandle = handleStream.getHandle();
        this.ownedObjectHandles = new Handle[ownedObjectCount];
        for (int i = 0; i < ownedObjectCount; ++i) {
            this.ownedObjectHandles[i] = handleStream.getHandle();
        }
        if (hasAttributes) {
            this.seqEndHandle = handleStream.getHandle();
        }
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "INSERT";
    }

    public BlockHeader getBlockHeader() {
        CadObject result = this.objectMap.parseObject(this.blockHeaderHandle);
        return (BlockHeader)result;
    }

    public List<CadObject> getOwnedObjects() {
        return new AbstractList<CadObject>(){

            @Override
            public CadObject get(int index) {
                CadObject result = Insert.this.objectMap.parseObject(Insert.this.ownedObjectHandles[index]);
                return result;
            }

            @Override
            public int size() {
                return Insert.this.ownedObjectHandles.length;
            }
        };
    }

    public CadObject getSeqEnd() {
        if (this.seqEndHandle == null) {
            return null;
        }
        CadObject result = this.objectMap.parseObject(this.seqEndHandle);
        return result;
    }
}

