/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.NonEntityObject;
import com.onespatial.dwglib.objects.ObjectMap;
import java.io.UnsupportedEncodingException;

public class LType
extends NonEntityObject {
    public String entryName;
    public boolean sixtyFourFlag;
    public boolean xDep;
    public String description;
    public double patternLen;
    public Dash[] dashes;
    private Handle externalReferenceBlockHandle;

    public LType(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        int i;
        this.entryName = stringStream.getTU();
        this.sixtyFourFlag = dataStream.getB();
        this.xDep = dataStream.getB();
        this.description = stringStream.getTU();
        this.patternLen = dataStream.getBD();
        dataStream.expectRC(65);
        int numDashes = dataStream.getRC();
        boolean isTextAreaPresent = false;
        this.dashes = new Dash[numDashes];
        for (i = 0; i < numDashes; ++i) {
            this.dashes[i] = new Dash();
            this.dashes[i].readFromDataStream(dataStream);
            isTextAreaPresent = isTextAreaPresent || (this.dashes[i].shapeFlag & 2) != 0;
        }
        if (isTextAreaPresent) {
            int[] textArea = dataStream.getBytes(512);
            for (int i2 = 0; i2 < numDashes; ++i2) {
                if ((this.dashes[i2].shapeFlag & 2) == 0) continue;
                this.dashes[i2].extractTextFromTextArea(textArea);
            }
        }
        this.externalReferenceBlockHandle = handleStream.getHandle();
        for (i = 0; i < numDashes; ++i) {
            this.dashes[i].readFromHandleStream(handleStream);
        }
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "LTYPE";
    }

    public CadObject getExternalReferenceBlock() {
        CadObject result = this.objectMap.parseObjectPossiblyNull(this.externalReferenceBlockHandle);
        return result;
    }

    public class Dash {
        public double dashLength;
        public int complexShapecode;
        public double xOffset;
        public double yOffset;
        public double scale;
        public double rotation;
        public int shapeFlag;
        private Handle shapefileForDashHandle;
        public String textToBeDrawn;

        public void readFromDataStream(BitBuffer dataStream) {
            this.dashLength = dataStream.getBD();
            this.complexShapecode = dataStream.getBS();
            this.xOffset = dataStream.getRD();
            this.yOffset = dataStream.getRD();
            this.scale = dataStream.getBD();
            this.rotation = dataStream.getBD();
            this.shapeFlag = dataStream.getBS();
        }

        public void readFromHandleStream(BitBuffer handleStream) {
            this.shapefileForDashHandle = handleStream.getHandle();
        }

        public CadObject getShapefileForDash() {
            CadObject result = LType.this.objectMap.parseObjectPossiblyNull(this.shapefileForDashHandle);
            return result;
        }

        public void extractTextFromTextArea(int[] textArea) {
            int textLength = 0;
            for (int i = this.complexShapecode; i < textArea.length && textArea[i] != 0; ++i) {
                ++textLength;
            }
            byte[] extractedBytes = new byte[textLength];
            for (int j = 0; j < textLength; ++j) {
                extractedBytes[j] = (byte)textArea[this.complexShapecode + j];
            }
            try {
                this.textToBeDrawn = new String(extractedBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LType.this.objectMap.getIssues().addWarning("Invalid text in LType text area.  The text is not valid UTF-8.");
            }
        }
    }
}

