/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.LType;
import com.onespatial.dwglib.objects.NonEntityObject;
import com.onespatial.dwglib.objects.ObjectMap;
import java.util.AbstractList;
import java.util.List;

public class LTypeControlObj
extends NonEntityObject {
    private Handle[] lineTypeHandles;
    private Handle bylayerLinetypeHandle;
    private Handle byblockLinetypeHandle;

    public LTypeControlObj(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        int numEntries = dataStream.getBL();
        dataStream.assertEndOfStream();
        this.lineTypeHandles = new Handle[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            this.lineTypeHandles[i] = handleStream.getHandle(this.handleOfThisObject);
        }
        this.bylayerLinetypeHandle = handleStream.getHandle();
        this.byblockLinetypeHandle = handleStream.getHandle();
        handleStream.advanceToByteBoundary();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "LTYPE CONTROL OBJ";
    }

    public List<LType> getLineTypes() {
        return new AbstractList<LType>(){

            @Override
            public LType get(int index) {
                return (LType)LTypeControlObj.this.objectMap.parseObjectPossiblyNull(LTypeControlObj.this.lineTypeHandles[index]);
            }

            @Override
            public int size() {
                return LTypeControlObj.this.lineTypeHandles.length;
            }
        };
    }

    public LType getBylayerLinetype() {
        CadObject result = this.objectMap.parseObject(this.bylayerLinetypeHandle);
        return (LType)result;
    }

    public LType getByblockLinetype() {
        CadObject result = this.objectMap.parseObject(this.byblockLinetypeHandle);
        return (LType)result;
    }
}

