/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.Layer;
import com.onespatial.dwglib.objects.NonEntityObject;
import com.onespatial.dwglib.objects.ObjectMap;
import java.util.AbstractList;
import java.util.List;

public class LayerControlObj
extends NonEntityObject {
    public Handle[] layerObjectHandles;

    public LayerControlObj(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        int numentries = dataStream.getBL();
        this.layerObjectHandles = new Handle[numentries];
        for (int i = 0; i < numentries; ++i) {
            this.layerObjectHandles[i] = handleStream.getHandle(this.handleOfThisObject);
        }
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "LAYER CONTROL OBJ";
    }

    public List<Layer> getLayers() {
        return new AbstractList<Layer>(){

            @Override
            public Layer get(int index) {
                CadObject result = LayerControlObj.this.objectMap.parseObjectPossiblyNull(LayerControlObj.this.layerObjectHandles[index]);
                return (Layer)result;
            }

            @Override
            public int size() {
                return LayerControlObj.this.layerObjectHandles.length;
            }
        };
    }
}

