/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Point3D;
import com.onespatial.dwglib.objects.EntityObject;
import com.onespatial.dwglib.objects.ObjectMap;

public class Line
extends EntityObject {
    public Point3D start;
    public Point3D end;
    public double thickness;
    public Point3D extrusion;

    public Line(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        double endZ;
        double startZ;
        boolean zAreZero = dataStream.getB();
        double startX = dataStream.getRD();
        double endX = dataStream.getDD(startX);
        double startY = dataStream.getRD();
        double endY = dataStream.getDD(startY);
        if (zAreZero) {
            startZ = 0.0;
            endZ = 0.0;
        } else {
            startZ = dataStream.getRD();
            endZ = dataStream.getDD(startZ);
        }
        this.start = new Point3D(startX, startY, startZ);
        this.end = new Point3D(endX, endY, endZ);
        this.thickness = dataStream.getBT();
        this.extrusion = dataStream.getBE();
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "LINE";
    }
}

