/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.CmColor;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.bitstreams.Point3D;
import com.onespatial.dwglib.objects.CadObject;
import com.onespatial.dwglib.objects.EntityObject;
import com.onespatial.dwglib.objects.ObjectMap;

public class MText
extends EntityObject {
    public Point3D insertionPoint;
    public Point3D extrusion;
    public Point3D xAxisDir;
    public double rectWidth;
    public double rectHeight;
    public double textHeight;
    public int attachment;
    public int drawingDir;
    public double extents;
    public double extentsWid;
    public String text;
    public int linespacingStyle;
    public double linespacingFactor;
    public boolean unknownBit;
    public double backgroundScaleFactor;
    public CmColor backgroundColor;
    public int backgroundTransparency;
    private Handle styleHandle;

    public MText(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        this.insertionPoint = dataStream.get3BD();
        this.extrusion = dataStream.get3BD();
        this.xAxisDir = dataStream.get3BD();
        this.rectWidth = dataStream.getBD();
        this.rectHeight = dataStream.getBD();
        this.textHeight = dataStream.getBD();
        this.attachment = dataStream.getBS();
        this.drawingDir = dataStream.getBS();
        this.extents = dataStream.getBD();
        this.extentsWid = dataStream.getBD();
        this.text = stringStream.getTU();
        this.linespacingStyle = dataStream.getBS();
        this.linespacingFactor = dataStream.getBD();
        this.unknownBit = dataStream.getB();
        int backgroundFlags = dataStream.getBL();
        if (backgroundFlags == 1) {
            this.backgroundScaleFactor = dataStream.getBD();
            this.backgroundColor = dataStream.getCMC();
            this.backgroundTransparency = dataStream.getBL();
        } else {
            this.backgroundScaleFactor = 1.5;
        }
        this.styleHandle = handleStream.getHandle();
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "MTEXT";
    }

    public CadObject getStyle() {
        CadObject result = this.objectMap.parseObject(this.styleHandle);
        return result;
    }
}

