/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Handle;
import com.onespatial.dwglib.bitstreams.Point3D;
import com.onespatial.dwglib.objects.EntityObject;
import com.onespatial.dwglib.objects.ObjectMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class ThreeDSolid
extends EntityObject {
    public Point3D point;
    public Handle historyId;
    public Wire[] wires;

    public ThreeDSolid(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        block19: {
            boolean acisEmptyBit = dataStream.getB();
            boolean unknownBit = dataStream.getB();
            int version = dataStream.getBS();
            if (version == 1) {
                int blockSize = dataStream.getBL();
                for (int i = 0; i < blockSize; ++i) {
                    dataStream.getRC();
                }
            } else if (version == 2) {
                String str;
                StringBuilder header = new StringBuilder();
                byte[] h2 = new byte[15];
                for (int i = 0; i < 15; ++i) {
                    h2[i] = (byte)dataStream.getRC();
                }
                try {
                    str = new String(h2, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                if (str.equals("ACIS BinaryFile")) {
                    byte[] endMarker;
                    try {
                        endMarker = "End..of..ACIS..data".getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    endMarker[3] = 14;
                    endMarker[4] = 2;
                    endMarker[7] = 14;
                    endMarker[8] = 4;
                    endMarker[13] = 13;
                    endMarker[14] = 4;
                    byte sourceByte = (byte)dataStream.getRC();
                    while (true) {
                        int numMatches = 0;
                        for (byte endMarkerByte : endMarker) {
                            if (sourceByte != endMarkerByte) break;
                            if (++numMatches >= endMarker.length) continue;
                            sourceByte = (byte)dataStream.getRC();
                        }
                        if (numMatches != endMarker.length) {
                            if (numMatches != 0) continue;
                            sourceByte = (byte)dataStream.getRC();
                            continue;
                        }
                        break block19;
                        break;
                    }
                }
                this.objectMap.getIssues().addWarning("text file present but not yet supported");
            } else {
                throw new RuntimeException("Version must be 1 or 2");
            }
        }
        boolean wireframeDataPresent = dataStream.getB();
        if (wireframeDataPresent) {
            int i;
            boolean pointPresent = dataStream.getB();
            if (pointPresent) {
                this.point = dataStream.get3BD();
            }
            int numIsoLines = dataStream.getBL();
            boolean isoPresent = dataStream.getB();
            int numWires = dataStream.getBL();
            this.wires = new Wire[numWires];
            for (int i2 = 0; i2 < numWires; ++i2) {
                this.wires[i2] = new Wire();
                this.wires[i2].readFromStream(dataStream);
            }
            int numberOfSilhouettes = dataStream.getBL();
            for (i = 0; i < numberOfSilhouettes; ++i) {
            }
            for (i = 0; i < numWires; ++i) {
            }
            boolean acisEmptyBit2 = dataStream.getB();
            int n = dataStream.getBL();
        }
        this.historyId = handleStream.getHandle();
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "3DSOLID";
    }

    private class ByteBufferAsInputStream
    extends InputStream {
        private ByteBuffer byteBuffer;

        ByteBufferAsInputStream(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        @Override
        public int read() throws IOException {
            if (!this.byteBuffer.hasRemaining()) {
                return -1;
            }
            return this.byteBuffer.get();
        }

        @Override
        public int read(byte[] bytes, int offset, int length) throws IOException {
            length = Math.min(this.byteBuffer.remaining(), length);
            this.byteBuffer.get(bytes, offset, length);
            return length;
        }
    }

    public static class Wire {
        public int wireType;
        public int wireSelectionMarker;
        public int wireColor;
        public int wireAcisIndex;
        public Point3D[] points;

        public void readFromStream(BitBuffer dataStream) {
            this.wireType = dataStream.getRC();
            this.wireSelectionMarker = dataStream.getBL();
            this.wireColor = dataStream.getBS();
            this.wireAcisIndex = dataStream.getBL();
            int wireNumberOfPoints = dataStream.getBL();
            this.points = new Point3D[wireNumberOfPoints];
            for (int j = 0; j < wireNumberOfPoints; ++j) {
                this.points[j] = dataStream.get3BD();
            }
            boolean transformPresent = dataStream.getB();
            if (transformPresent) {
                Point3D xAxis = dataStream.get3BD();
                Point3D yAxis = dataStream.get3BD();
                Point3D zAxis = dataStream.get3BD();
                Point3D translation = dataStream.get3BD();
                double scale = dataStream.getBD();
                boolean hasRotation = dataStream.getB();
                boolean hasReflection = dataStream.getB();
                boolean bl = dataStream.getB();
            }
        }
    }
}

