/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.Point3D;
import com.onespatial.dwglib.objects.EntityObject;
import com.onespatial.dwglib.objects.ObjectMap;

public class Vertex2D
extends EntityObject {
    public int flags;
    public Point3D point;
    public double startWidth;
    public double endWidth;
    public double bulge;
    public int vertexId;
    public double tangentDir;

    public Vertex2D(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        this.flags = dataStream.getRC();
        this.point = dataStream.get3BD();
        double width = dataStream.getBD();
        if (width < 0.0) {
            this.startWidth = -width;
            this.endWidth = -width;
        } else {
            this.startWidth = width;
            this.endWidth = dataStream.getBD();
        }
        this.bulge = dataStream.getBD();
        this.vertexId = dataStream.getBL();
        this.tangentDir = dataStream.getBD();
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
        handleStream.assertEndOfStream();
    }

    public String toString() {
        return "VERTEX (2D)";
    }
}

