/*
 * Decompiled with CFR 0.152.
 */
package com.onespatial.dwglib.objects;

import com.onespatial.dwglib.FileVersion;
import com.onespatial.dwglib.bitstreams.BitBuffer;
import com.onespatial.dwglib.bitstreams.CmColor;
import com.onespatial.dwglib.bitstreams.Point2D;
import com.onespatial.dwglib.bitstreams.Point3D;
import com.onespatial.dwglib.objects.EntityObject;
import com.onespatial.dwglib.objects.ObjectMap;

public class ViewPort
extends EntityObject {
    public Point3D point;
    public double thickness;
    public Point3D extrusion;
    public double xAxisAngle;
    public Point3D center;
    public double width;
    public double height;
    public Point3D viewTarget;
    public Point3D viewDirection;
    public double viewTwistAngle;
    public double viewHeight;
    public double lensLength;
    public double frontClipZ;
    public double backClipZ;
    public double snapAngle;
    public Point2D viewCenter;
    public Point2D snapBase;
    public Point2D snapSpacing;
    public Point2D gridSpacing;
    public int circleZoom;
    public int gridMajor;
    public String styleSheet;
    public int renderMode;
    public boolean ucsAtOrigin;
    public boolean ucsPerViewport;
    public Point3D ucsOrigin;
    public Point3D ucsXAxis;
    public Point3D ucsYAxis;
    public double ucsElevation;
    public int ucsOrthoViewType;
    public int shadePlotMode;
    public boolean useDefLights;
    public int defLightingType;
    public double brightness;
    public double contrast;
    public CmColor ambientLightColor;

    public ViewPort(ObjectMap objectMap) {
        super(objectMap);
    }

    @Override
    public void readObjectTypeSpecificData(BitBuffer dataStream, BitBuffer stringStream, BitBuffer handleStream, FileVersion fileVersion) {
        this.center = dataStream.get3BD();
        this.width = dataStream.getBD();
        this.height = dataStream.getBD();
        this.viewTarget = dataStream.get3BD();
        this.viewDirection = dataStream.get3BD();
        this.viewTwistAngle = dataStream.getBD();
        this.viewHeight = dataStream.getBD();
        this.lensLength = dataStream.getBD();
        this.frontClipZ = dataStream.getBD();
        this.backClipZ = dataStream.getBD();
        this.snapAngle = dataStream.getBD();
        this.viewCenter = dataStream.get2RD();
        this.snapBase = dataStream.get2RD();
        this.snapSpacing = dataStream.get2RD();
        this.gridSpacing = dataStream.get2RD();
        this.circleZoom = dataStream.getBS();
        this.gridMajor = dataStream.getBS();
        int frozenLayerCount = dataStream.getBL();
        int statusFlags = dataStream.getBL();
        this.styleSheet = stringStream.getTU();
        this.renderMode = dataStream.getRC();
        this.ucsAtOrigin = dataStream.getB();
        this.ucsPerViewport = dataStream.getB();
        this.ucsOrigin = dataStream.get3BD();
        this.ucsXAxis = dataStream.get3BD();
        this.ucsYAxis = dataStream.get3BD();
        this.ucsElevation = dataStream.getBD();
        this.ucsOrthoViewType = dataStream.getBS();
        this.shadePlotMode = dataStream.getBS();
        this.useDefLights = dataStream.getB();
        this.defLightingType = dataStream.getRC();
        this.brightness = dataStream.getBD();
        this.contrast = dataStream.getBD();
        this.ambientLightColor = dataStream.getCMC();
        handleStream.advanceToByteBoundary();
        dataStream.assertEndOfStream();
        stringStream.assertEndOfStream();
    }

    public String toString() {
        return "VIEWPORT";
    }
}

