/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.memory.jdbc;

import com.alibaba.cloud.ai.memory.jdbc.JdbcChatMemoryRepository;
import org.springframework.jdbc.core.JdbcTemplate;

public class H2ChatMemoryRepository
extends JdbcChatMemoryRepository {
    private static final String H2_QUERY_ADD = "INSERT INTO ai_chat_memory (conversation_id, content, type, timestamp) VALUES (?, ?, ?, ?)";
    private static final String H2_QUERY_GET = "SELECT content, type FROM ai_chat_memory WHERE conversation_id = ? ORDER BY timestamp";

    private H2ChatMemoryRepository(JdbcTemplate jdbcTemplate) {
        super(jdbcTemplate);
    }

    public static H2Builder h2Builder() {
        return new H2Builder();
    }

    @Override
    protected String hasTableSql(String tableName) {
        return String.format("SELECT table_name FROM information_schema.tables WHERE table_name = '%s'", tableName);
    }

    @Override
    protected String createTableSql(String tableName) {
        return String.format("CREATE TABLE %s (id BIGINT AUTO_INCREMENT PRIMARY KEY, conversation_id VARCHAR(256) NOT NULL, content LONGTEXT NOT NULL, type VARCHAR(100) NOT NULL, timestamp TIMESTAMP NOT NULL, CONSTRAINT chk_message_type CHECK (type IN ('USER', 'ASSISTANT', 'SYSTEM', 'TOOL')))", tableName);
    }

    @Override
    protected String getAddSql() {
        return H2_QUERY_ADD;
    }

    @Override
    protected String getGetSql() {
        return H2_QUERY_GET;
    }

    public static class H2Builder {
        private JdbcTemplate jdbcTemplate;

        public H2Builder jdbcTemplate(JdbcTemplate jdbcTemplate) {
            this.jdbcTemplate = jdbcTemplate;
            return this;
        }

        public H2ChatMemoryRepository build() {
            return new H2ChatMemoryRepository(this.jdbcTemplate);
        }
    }
}

