/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.ttsv2.enrollment;

import com.alibaba.dashscope.api.SynchronizeHalfDuplexApi;
import com.alibaba.dashscope.audio.ttsv2.enrollment.Voice;
import com.alibaba.dashscope.audio.ttsv2.enrollment.VoiceEnrollmentOperationType;
import com.alibaba.dashscope.audio.ttsv2.enrollment.VoiceEnrollmentParam;
import com.alibaba.dashscope.base.HalfDuplexParamBase;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoiceEnrollmentService {
    private static final Logger log = LoggerFactory.getLogger(VoiceEnrollmentService.class);
    private final SynchronizeHalfDuplexApi<HalfDuplexServiceParam> syncApi;
    private final ApiServiceOption createServiceOptions;
    private static final String VOICE_ENROLLMENT_MODEL_NAME = "voice-enrollment";
    private String apikey;
    private String lastRequestId;
    private String model;

    public VoiceEnrollmentService(String apikey) {
        this.apikey = apikey;
        this.createServiceOptions = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).taskGroup("audio")).task("tts")).function("customization")).isAsyncTask(false)).build();
        this.syncApi = new SynchronizeHalfDuplexApi(this.createServiceOptions);
        this.model = VOICE_ENROLLMENT_MODEL_NAME;
    }

    public VoiceEnrollmentService(String apikey, String model) {
        this.apikey = apikey;
        this.createServiceOptions = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).taskGroup("audio")).task("tts")).function("customization")).isAsyncTask(false)).build();
        this.syncApi = new SynchronizeHalfDuplexApi(this.createServiceOptions);
        this.model = model;
    }

    public Voice createVoice(String targetModel, String prefix, String url) throws NoApiKeyException, InputRequiredException {
        return this.createVoice(targetModel, prefix, url, (VoiceEnrollmentParam)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)VoiceEnrollmentParam.builder().model(this.model)).build());
    }

    public Voice[] listVoice(String prefix) throws NoApiKeyException, InputRequiredException {
        return this.listVoice(prefix, 0, 10, (VoiceEnrollmentParam)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)VoiceEnrollmentParam.builder().model(this.model)).build());
    }

    public Voice[] listVoice(String prefix, int pageIndex, int pageSize) throws NoApiKeyException, InputRequiredException {
        return this.listVoice(prefix, pageIndex, pageSize, (VoiceEnrollmentParam)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)VoiceEnrollmentParam.builder().model(this.model)).build());
    }

    public Voice queryVoice(String voiceId) throws NoApiKeyException, InputRequiredException {
        return this.queryVoice(voiceId, (VoiceEnrollmentParam)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)VoiceEnrollmentParam.builder().model(this.model)).build());
    }

    public void updateVoice(String voiceId, String url) throws NoApiKeyException, InputRequiredException {
        this.updateVoice(voiceId, url, (VoiceEnrollmentParam)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)VoiceEnrollmentParam.builder().model(this.model)).build());
    }

    public void deleteVoice(String voiceId) throws NoApiKeyException, InputRequiredException {
        this.deleteVoice(voiceId, (VoiceEnrollmentParam)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)VoiceEnrollmentParam.builder().model(this.model)).build());
    }

    public Voice createVoice(String targetModel, String prefix, String url, VoiceEnrollmentParam customParam) throws NoApiKeyException, InputRequiredException {
        HalfDuplexServiceParam param = ((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((HalfDuplexParamBase.HalfDuplexParamBaseBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder)VoiceEnrollmentParam.builder().operationType(VoiceEnrollmentOperationType.CREATE)).model(this.model)).targetModel(targetModel)).prefix(prefix)).url(url)).apiKey(this.apikey)).headers(customParam.getHeaders())).resources(customParam.getResources())).parameters(customParam.getParameters())).workspace(customParam.getWorkspace())).build();
        ((VoiceEnrollmentParam)param).validate();
        DashScopeResult dashScopeResult = this.syncApi.call(param);
        this.lastRequestId = dashScopeResult.getRequestId();
        return Voice.voiceFromCreateResult(dashScopeResult);
    }

    public Voice[] listVoice(String prefix, int pageIndex, int pageSize, VoiceEnrollmentParam customParam) throws NoApiKeyException, InputRequiredException {
        HalfDuplexServiceParam param = ((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((HalfDuplexParamBase.HalfDuplexParamBaseBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder)VoiceEnrollmentParam.builder().operationType(VoiceEnrollmentOperationType.LIST)).model(this.model)).prefix(prefix)).pageSize(pageSize)).pageIndex(pageIndex)).apiKey(this.apikey)).headers(customParam.getHeaders())).resources(customParam.getResources())).parameters(customParam.getParameters())).workspace(customParam.getWorkspace())).build();
        ((VoiceEnrollmentParam)param).validate();
        DashScopeResult dashScopeResult = this.syncApi.call(param);
        this.lastRequestId = dashScopeResult.getRequestId();
        return Voice.voiceListFromListResult(dashScopeResult);
    }

    public Voice queryVoice(String voiceId, VoiceEnrollmentParam customParam) throws NoApiKeyException, InputRequiredException {
        HalfDuplexServiceParam param = ((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((HalfDuplexParamBase.HalfDuplexParamBaseBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder)VoiceEnrollmentParam.builder().operationType(VoiceEnrollmentOperationType.QUERY)).model(this.model)).voiceId(voiceId)).apiKey(this.apikey)).headers(customParam.getHeaders())).resources(customParam.getResources())).parameters(customParam.getParameters())).workspace(customParam.getWorkspace())).build();
        ((VoiceEnrollmentParam)param).validate();
        DashScopeResult dashScopeResult = this.syncApi.call(param);
        this.lastRequestId = dashScopeResult.getRequestId();
        return Voice.voiceFromQueryResult(dashScopeResult);
    }

    public void updateVoice(String voiceId, String url, VoiceEnrollmentParam customParam) throws NoApiKeyException, InputRequiredException {
        HalfDuplexServiceParam param = ((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((HalfDuplexParamBase.HalfDuplexParamBaseBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder)VoiceEnrollmentParam.builder().operationType(VoiceEnrollmentOperationType.UPDATE)).model(this.model)).voiceId(voiceId)).url(url)).apiKey(this.apikey)).headers(customParam.getHeaders())).resources(customParam.getResources())).parameters(customParam.getParameters())).workspace(customParam.getWorkspace())).build();
        ((VoiceEnrollmentParam)param).validate();
        DashScopeResult dashScopeResult = this.syncApi.call(param);
        this.lastRequestId = dashScopeResult.getRequestId();
    }

    public void deleteVoice(String voiceId, VoiceEnrollmentParam customParam) throws NoApiKeyException, InputRequiredException {
        HalfDuplexServiceParam param = ((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((HalfDuplexParamBase.HalfDuplexParamBaseBuilder)((VoiceEnrollmentParam.VoiceEnrollmentParamBuilder)((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder)VoiceEnrollmentParam.builder().operationType(VoiceEnrollmentOperationType.DELETE)).model(this.model)).voiceId(voiceId)).apiKey(this.apikey)).headers(customParam.getHeaders())).resources(customParam.getResources())).parameters(customParam.getParameters())).workspace(customParam.getWorkspace())).build();
        ((VoiceEnrollmentParam)param).validate();
        DashScopeResult dashScopeResult = this.syncApi.call(param);
        this.lastRequestId = dashScopeResult.getRequestId();
    }

    public String getLastRequestId() {
        return this.lastRequestId;
    }
}

