/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.parser;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLCurrentOfCursorExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAlterColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCommitStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateUserStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLRollbackStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGAttrExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGAlterDatabaseStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGAlterSchemaStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGAnalyzeStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGConnectToStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGCreateDatabaseStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGCreateSchemaStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDeleteStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDoStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDropDatabaseStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDropSchemaStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGEndTransactionStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGShowStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGStartTransactionStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGVacuumStatement;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGCreateTableParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class PGSQLStatementParser
extends SQLStatementParser {
    public static final String TIME_ZONE = "TIME ZONE";
    public static final String TIME = "TIME";
    public static final String LOCAL = "LOCAL";

    public PGSQLStatementParser(PGExprParser parser) {
        super(parser);
    }

    public PGSQLStatementParser(String sql) {
        super(new PGExprParser(sql));
    }

    public PGSQLStatementParser(String sql, SQLParserFeature ... features) {
        super(new PGExprParser(sql, features));
    }

    public PGSQLStatementParser(Lexer lexer) {
        super(new PGExprParser(lexer));
    }

    @Override
    public PGSelectParser createSQLSelectParser() {
        return new PGSelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public SQLUpdateStatement parseUpdateStatement() {
        this.accept(Token.UPDATE);
        PGUpdateStatement updateStatement = new PGUpdateStatement();
        SQLSelectParser selectParser = this.exprParser.createSelectParser();
        SQLTableSource tableSource = selectParser.parseTableSource();
        updateStatement.setTableSource(tableSource);
        this.parseUpdateSet(updateStatement);
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            SQLTableSource from = selectParser.parseTableSource();
            updateStatement.setFrom(from);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            updateStatement.setWhere(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.RETURNING) {
            this.lexer.nextToken();
            while (true) {
                updateStatement.getReturning().add(this.exprParser.expr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        return updateStatement;
    }

    @Override
    public PGInsertStatement parseInsert() {
        PGInsertStatement stmt = new PGInsertStatement();
        if (this.lexer.token() == Token.INSERT) {
            this.lexer.nextToken();
            this.accept(Token.INTO);
            SQLName tableName = this.exprParser.name();
            stmt.setTableName(tableName);
            if (this.lexer.token() == Token.AS) {
                this.lexer.nextToken();
                stmt.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.IDENTIFIER) {
                stmt.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.DEFAULT) {
            this.lexer.nextToken();
            this.accept(Token.VALUES);
            stmt.setDefaultValues(true);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getColumns(), stmt);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            while (true) {
                this.accept(Token.LPAREN);
                SQLInsertStatement.ValuesClause valuesCaluse = new SQLInsertStatement.ValuesClause();
                this.exprParser.exprList(valuesCaluse.getValues(), valuesCaluse);
                stmt.addValueCause(valuesCaluse);
                this.accept(Token.RPAREN);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.WITH) {
            PGSelectStatement nextWithQuery = (PGSelectStatement)this.parseWith();
            stmt.setQuery(nextWithQuery.getSelect());
        } else if (this.lexer.token() == Token.SELECT) {
            SQLQueryExpr queryExpr = (SQLQueryExpr)this.exprParser.expr();
            stmt.setQuery(queryExpr.getSubQuery());
        }
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.CONFLICT)) {
                SQLExpr where;
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    ArrayList<SQLExpr> onConflictTarget = new ArrayList<SQLExpr>();
                    this.exprParser.exprList(onConflictTarget, stmt);
                    stmt.setOnConflictTarget(onConflictTarget);
                    this.accept(Token.RPAREN);
                }
                if (this.lexer.token() == Token.ON) {
                    this.lexer.nextToken();
                    this.accept(Token.CONSTRAINT);
                    SQLName constraintName = this.exprParser.name();
                    stmt.setOnConflictConstraint(constraintName);
                }
                if (this.lexer.token() == Token.WHERE) {
                    this.lexer.nextToken();
                    where = this.exprParser.expr();
                    stmt.setOnConflictWhere(where);
                }
                if (this.lexer.token() == Token.DO) {
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals(FnvHash.Constants.NOTHING)) {
                        this.lexer.nextToken();
                        stmt.setOnConflictDoNothing(true);
                    } else {
                        this.accept(Token.UPDATE);
                        this.accept(Token.SET);
                        while (true) {
                            SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
                            stmt.addConflicUpdateItem(item);
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        if (this.lexer.token() == Token.WHERE) {
                            this.lexer.nextToken();
                            where = this.exprParser.expr();
                            stmt.setOnConflictUpdateWhere(where);
                        }
                    }
                }
            }
        }
        if (this.lexer.token() == Token.RETURNING) {
            this.lexer.nextToken();
            SQLExpr returning = this.exprParser.expr();
            if (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                SQLListExpr list = new SQLListExpr();
                list.addItem(returning);
                this.exprParser.exprList(list.getItems(), list);
                returning = list;
            }
            stmt.setReturning(returning);
        }
        return stmt;
    }

    @Override
    public PGCreateDatabaseStatement parseCreateDatabase() {
        this.accept(Token.CREATE);
        this.accept(Token.DATABASE);
        PGCreateDatabaseStatement stmt = new PGCreateDatabaseStatement(this.dbType);
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            stmt.addBeforeComment(this.lexer.readAndResetComments());
        }
        stmt.setName(this.exprParser.identifier());
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            stmt.setHaveWith(true);
        }
        while (this.lexer.token() != Token.SEMI && !this.lexer.isEOF()) {
            boolean isAttr;
            boolean bl = isAttr = this.lexer.identifierEquals(FnvHash.Constants.TEMPLATE) || this.lexer.identifierEquals(FnvHash.Constants.OWNER);
            if (isAttr) {
                SQLIdentifierExpr attrName = this.exprParser.identifier();
                PGAttrExpr attrExpr = new PGAttrExpr();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                    attrExpr.setMode(PGAttrExpr.PGExprMode.EQ);
                } else {
                    attrExpr.setMode(PGAttrExpr.PGExprMode.EMPTY);
                }
                attrExpr.setName(attrName);
                attrExpr.setValue(this.exprParser.identifier());
                stmt.getStats().add(attrExpr);
                continue;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        return stmt;
    }

    @Override
    public PGCreateSchemaStatement parseCreateSchema() {
        this.accept(Token.CREATE);
        this.accept(Token.SCHEMA);
        PGCreateSchemaStatement stmt = new PGCreateSchemaStatement();
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        if (this.lexer.token() == Token.IDENTIFIER) {
            SQLIdentifierExpr userName;
            if (this.lexer.identifierEquals("AUTHORIZATION")) {
                this.lexer.nextToken();
                stmt.setAuthorization(true);
                userName = (SQLIdentifierExpr)this.exprParser.expr();
                stmt.setUserName(userName);
            } else {
                stmt.setSchemaName(this.exprParser.name());
                if (this.lexer.identifierEquals("AUTHORIZATION")) {
                    this.lexer.nextToken();
                    stmt.setAuthorization(true);
                    userName = (SQLIdentifierExpr)this.exprParser.expr();
                    stmt.setUserName(userName);
                }
            }
        }
        while (this.lexer.token() != Token.SEMI && !this.lexer.isEOF()) {
            if (this.lexer.token() == Token.CREATE) {
                Lexer.SavePoint mark = this.lexer.markOut();
                this.lexer.nextToken();
                if (this.lexer.token() == Token.TABLE) {
                    this.lexer.reset(mark);
                    stmt.getCreateStatements().add(this.parseCreateTable());
                    continue;
                }
                if (this.lexer.token() == Token.VIEW) {
                    this.lexer.reset(mark);
                    stmt.getCreateStatements().add(this.parseCreateView());
                    continue;
                }
                if (this.lexer.token() == Token.INDEX) {
                    this.lexer.reset(mark);
                    stmt.getCreateStatements().add(this.parseCreateIndex());
                    continue;
                }
                if (this.lexer.token() == Token.SEQUENCE) {
                    this.lexer.reset(mark);
                    stmt.getCreateStatements().add(this.parseCreateSequence());
                    continue;
                }
                if (this.lexer.token() == Token.TRIGGER) {
                    this.lexer.reset(mark);
                    stmt.getCreateStatements().add(this.parseCreateTrigger());
                    continue;
                }
            }
            throw new ParserException("syntax error. " + this.lexer.info());
        }
        return stmt;
    }

    @Override
    protected SQLStatement alterSchema() {
        this.accept(Token.ALTER);
        this.accept(Token.SCHEMA);
        PGAlterSchemaStatement stmt = new PGAlterSchemaStatement();
        stmt.setSchemaName(this.exprParser.name());
        if (this.lexer.identifierEquals(FnvHash.Constants.RENAME)) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            stmt.setNewName(this.exprParser.identifier());
        } else if (this.lexer.identifierEquals(FnvHash.Constants.OWNER)) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            stmt.setNewOwner(this.exprParser.identifier());
        }
        return stmt;
    }

    @Override
    public PGDropDatabaseStatement parseDropDatabaseOrSchema(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        PGDropDatabaseStatement stmt = new PGDropDatabaseStatement(this.getDbType());
        if (this.lexer.token() == Token.SCHEMA) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.DATABASE);
        }
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            stmt.setUsingWith(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.FORCE)) {
            this.lexer.nextToken();
            stmt.setForce(true);
        }
        return stmt;
    }

    @Override
    public PGDropSchemaStatement parseDropSchema(boolean physical) {
        PGDropSchemaStatement stmt = new PGDropSchemaStatement();
        if (this.lexer.token() == Token.SCHEMA) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.DATABASE);
        }
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setSchemaName(name);
        stmt.getMultipleNames().add(name);
        while (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
            stmt.getMultipleNames().add(this.exprParser.name());
        }
        if (this.lexer.token() == Token.CASCADE) {
            this.lexer.nextToken();
            stmt.setCascade(true);
        } else {
            stmt.setCascade(false);
        }
        if (this.lexer.token() == Token.RESTRICT) {
            this.lexer.nextToken();
            stmt.setRestrict(true);
        }
        return stmt;
    }

    @Override
    public PGDeleteStatement parseDeleteStatement() {
        this.lexer.nextToken();
        PGDeleteStatement deleteStatement = new PGDeleteStatement();
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.ONLY) {
            this.lexer.nextToken();
            deleteStatement.setOnly(true);
        }
        SQLName tableName = this.exprParser.name();
        deleteStatement.setTableName(tableName);
        if (this.lexer.token() == Token.AS) {
            this.accept(Token.AS);
        }
        if (this.lexer.token() == Token.IDENTIFIER) {
            deleteStatement.setAlias(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            SQLTableSource tableSource = this.createSQLSelectParser().parseTableSource();
            deleteStatement.setUsing(tableSource);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.CURRENT) {
                this.lexer.nextToken();
                this.accept(Token.OF);
                SQLName cursorName = this.exprParser.name();
                SQLCurrentOfCursorExpr where = new SQLCurrentOfCursorExpr(cursorName);
                deleteStatement.setWhere(where);
            } else {
                SQLExpr where = this.exprParser.expr();
                deleteStatement.setWhere(where);
            }
        }
        if (this.lexer.token() == Token.RETURNING) {
            this.lexer.nextToken();
            this.accept(Token.STAR);
            deleteStatement.setReturning(true);
        }
        return deleteStatement;
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        switch (this.lexer.token()) {
            case BEGIN: 
            case START: {
                PGStartTransactionStatement stmt = this.parseBegin();
                statementList.add(stmt);
                return true;
            }
            case END: {
                PGEndTransactionStatement stmt = this.parseEnd();
                statementList.add(stmt);
                return true;
            }
            case WITH: {
                statementList.add(this.parseWith());
                return true;
            }
            case DO: {
                PGDoStatement pgDoStatement = this.parseDo();
                statementList.add(pgDoStatement);
                return true;
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CONNECT)) {
            SQLStatement stmt = this.parseConnectTo();
            statementList.add(stmt);
            return true;
        }
        String strVal = this.lexer.stringVal();
        if (strVal.equalsIgnoreCase("ANALYZE")) {
            PGAnalyzeStatement stmt = this.parseAnalyzeTable();
            statementList.add(stmt);
            return true;
        }
        if (strVal.equalsIgnoreCase("VACUUM")) {
            PGVacuumStatement stmt = this.parseVacuumTable();
            statementList.add(stmt);
            return true;
        }
        return false;
    }

    public PGDoStatement parseDo() {
        PGDoStatement stmt = new PGDoStatement();
        stmt.setDbType(this.dbType);
        this.accept(Token.DO);
        SQLBlockStatement block = this.parseBlock();
        stmt.setBlock(block);
        return stmt;
    }

    @Override
    public SQLBlockStatement parseBlock() {
        SQLBlockStatement block = new SQLBlockStatement();
        block.setDbType(this.dbType);
        if (this.lexer.token() == Token.VARIANT) {
            String dollarQuotedStr = this.lexer.stringVal();
            if (!dollarQuotedStr.endsWith("$")) {
                throw new ParserException("syntax error. " + this.lexer.info());
            }
            block.setIsDollarQuoted(true);
            String dollarQuoteTagName = dollarQuotedStr.substring(1, dollarQuotedStr.length() - 1);
            block.setDollarQuoteTagName(dollarQuoteTagName);
            this.lexer.nextToken();
        }
        String labelName = null;
        if (this.lexer.token() == Token.IDENTIFIER) {
            labelName = this.lexer.stringVal();
            this.lexer.nextToken();
        }
        if (labelName != null) {
            block.setLabelName(labelName);
        }
        if (this.lexer.token() == Token.DECLARE) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.CURSOR) {
            this.parseParameters(block.getParameters(), block);
            for (SQLParameter param : block.getParameters()) {
                param.setParent(block);
            }
        }
        this.accept(Token.BEGIN);
        List<SQLStatement> statementList = block.getStatementList();
        this.parseStatementList(statementList, -1, block);
        if (this.lexer.token() != Token.END && !statementList.isEmpty() && (statementList.get(statementList.size() - 1) instanceof SQLCommitStatement || statementList.get(statementList.size() - 1) instanceof SQLRollbackStatement)) {
            block.setEndOfCommit(true);
            return block;
        }
        this.accept(Token.END);
        Token token = this.lexer.token();
        if (token != Token.SEMI) {
            if (token == Token.IDENTIFIER) {
                String endLabel = this.lexer.stringVal();
                block.setEndLabel(endLabel);
                if (!block.getLabelName().equals(endLabel)) {
                    this.printError(this.lexer.token());
                }
                this.acceptIdentifier(endLabel);
            }
            if (this.lexer.token() == Token.VARIANT) {
                this.parseEndDollarQuote(block);
            }
        }
        this.accept(Token.SEMI);
        if (this.lexer.token() == Token.VARIANT) {
            this.parseEndDollarQuote(block);
            this.accept(Token.SEMI);
        }
        return block;
    }

    private void parseEndDollarQuote(SQLBlockStatement block) {
        String dollarQuotedStr = this.lexer.stringVal();
        if (!dollarQuotedStr.endsWith("$")) {
            throw new ParserException("syntax error. " + this.lexer.info());
        }
        String dollarQuoteTagName = dollarQuotedStr.substring(1, dollarQuotedStr.length() - 1);
        if (!block.getDollarQuoteTagName().equals(dollarQuoteTagName)) {
            this.printError(this.lexer.token());
        }
        this.lexer.nextToken();
        if (this.lexer.token() != Token.SEMI) {
            this.accept(Token.LANGUAGE);
            block.setLanguage(this.lexer.stringVal());
            this.acceptIdentifier(block.getLanguage());
        }
    }

    private void parseParameters(List<SQLParameter> parameters, SQLObject parent) {
        Token token;
        do {
            SQLParameter parameter = new SQLParameter();
            parameter.setParent(parent);
            SQLDataType dataType = null;
            SQLName name = this.exprParser.name();
            if (this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.OUT) {
                    this.lexer.nextToken();
                    parameter.setParamType(SQLParameter.ParameterType.INOUT);
                } else {
                    parameter.setParamType(SQLParameter.ParameterType.IN);
                }
            } else if (this.lexer.token() == Token.OUT) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    parameter.setParamType(SQLParameter.ParameterType.INOUT);
                } else {
                    parameter.setParamType(SQLParameter.ParameterType.OUT);
                }
            } else if (this.lexer.token() == Token.INOUT) {
                this.lexer.nextToken();
                parameter.setParamType(SQLParameter.ParameterType.INOUT);
            }
            dataType = this.exprParser.parseDataType(false);
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                this.accept(Token.NULL);
                parameter.setNotNull(true);
            }
            if (this.lexer.token() == Token.COLONEQ || this.lexer.token() == Token.DEFAULT) {
                this.lexer.nextToken();
                parameter.setDefaultValue(this.exprParser.expr());
            }
            parameter.setName(name);
            parameter.setDataType(dataType);
            parameters.add(parameter);
            token = this.lexer.token();
            if (token != Token.COMMA && token != Token.SEMI && token != Token.IS) continue;
            this.lexer.nextToken();
        } while ((token = this.lexer.token()) != Token.BEGIN && token != Token.RPAREN && token != Token.EOF && token != Token.FUNCTION && !this.lexer.identifierEquals("DETERMINISTIC"));
    }

    protected PGStartTransactionStatement parseBegin() {
        PGStartTransactionStatement stmt = new PGStartTransactionStatement();
        if (this.lexer.token() == Token.START) {
            this.lexer.nextToken();
            this.acceptIdentifier("TRANSACTION");
        } else {
            this.accept(Token.BEGIN);
            stmt.setUseBegin(true);
        }
        return stmt;
    }

    @Override
    public PGEndTransactionStatement parseEnd() {
        PGEndTransactionStatement stmt = new PGEndTransactionStatement();
        this.accept(Token.END);
        return stmt;
    }

    public SQLStatement parseConnectTo() {
        this.acceptIdentifier("CONNECT");
        this.accept(Token.TO);
        PGConnectToStatement stmt = new PGConnectToStatement();
        SQLName target = this.exprParser.name();
        stmt.setTarget(target);
        return stmt;
    }

    @Override
    public PGSelectStatement parseSelect() {
        PGSelectParser selectParser = this.createSQLSelectParser();
        SQLSelect select = selectParser.select();
        return new PGSelectStatement(select);
    }

    @Override
    public SQLStatement parseWith() {
        SQLWithSubqueryClause with = this.parseWithQuery();
        if (this.lexer.token() == Token.INSERT) {
            PGInsertStatement stmt = this.parseInsert();
            stmt.setWith(with);
            return stmt;
        }
        if (this.lexer.token() == Token.SELECT) {
            PGSelectStatement stmt = this.parseSelect();
            stmt.getSelect().setWithSubQuery(with);
            return stmt;
        }
        if (this.lexer.token() == Token.DELETE) {
            PGDeleteStatement stmt = this.parseDeleteStatement();
            stmt.setWith(with);
            return stmt;
        }
        if (this.lexer.token() == Token.UPDATE) {
            PGUpdateStatement stmt = (PGUpdateStatement)this.parseUpdateStatement();
            stmt.setWith(with);
            return stmt;
        }
        throw new ParserException("TODO. " + this.lexer.info());
    }

    @Override
    protected SQLAlterTableAlterColumn parseAlterColumn() {
        if (this.lexer.token() == Token.COLUMN) {
            this.lexer.nextToken();
        }
        SQLColumnDefinition column = this.exprParser.parseColumn();
        column.setDbType(this.dbType);
        SQLAlterTableAlterColumn alterColumn = new SQLAlterTableAlterColumn();
        alterColumn.setColumn(column);
        if (column.getDataType() == null && column.getConstraints().isEmpty()) {
            if (this.lexer.token() == Token.SET) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.NOT) {
                    this.lexer.nextToken();
                    this.accept(Token.NULL);
                    alterColumn.setSetNotNull(true);
                } else {
                    this.accept(Token.DEFAULT);
                    SQLExpr defaultValue = this.exprParser.expr();
                    alterColumn.setSetDefault(defaultValue);
                }
            } else if (this.lexer.token() == Token.DROP) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.NOT) {
                    this.lexer.nextToken();
                    this.accept(Token.NULL);
                    alterColumn.setDropNotNull(true);
                } else {
                    this.accept(Token.DEFAULT);
                    alterColumn.setDropDefault(true);
                }
            }
        }
        return alterColumn;
    }

    @Override
    public SQLStatement parseShow() {
        this.accept(Token.SHOW);
        PGShowStatement stmt = new PGShowStatement(this.dbType);
        switch (this.lexer.token()) {
            case ALL: {
                stmt.setExpr(new SQLIdentifierExpr(Token.ALL.name()));
                this.lexer.nextToken();
                break;
            }
            default: {
                stmt.setExpr(this.exprParser.expr());
            }
        }
        return stmt;
    }

    @Override
    public SQLStatement parseCommit() {
        SQLCommitStatement stmt = new SQLCommitStatement();
        stmt.setDbType(this.dbType);
        this.lexer.nextToken();
        return stmt;
    }

    @Override
    public SQLStatement parseSet() {
        SQLExpr valueExpr;
        String value;
        SQLIdentifierExpr paramExpr;
        this.accept(Token.SET);
        Token token = this.lexer.token();
        String range = "";
        SQLSetStatement.Option option = null;
        if (token == Token.SESSION) {
            this.lexer.nextToken();
            range = Token.SESSION.name();
            option = SQLSetStatement.Option.SESSION;
        } else if (token == Token.IDENTIFIER && LOCAL.equalsIgnoreCase(this.lexer.stringVal())) {
            range = LOCAL;
            option = SQLSetStatement.Option.LOCAL;
            this.lexer.nextToken();
        }
        long hash = this.lexer.hashLCase();
        String parameter = this.lexer.stringVal();
        ArrayList<SQLExpr> values = new ArrayList<SQLExpr>();
        if (hash == FnvHash.Constants.TIME) {
            this.lexer.nextToken();
            this.acceptIdentifier("ZONE");
            paramExpr = new SQLIdentifierExpr(TIME_ZONE);
            value = this.lexer.stringVal();
            if (this.lexer.token() == Token.IDENTIFIER) {
                values.add(new SQLIdentifierExpr(value.toUpperCase()));
            } else {
                values.add(new SQLCharExpr(value));
            }
            this.lexer.nextToken();
        } else if (hash == FnvHash.Constants.ROLE) {
            paramExpr = new SQLIdentifierExpr(parameter);
            this.lexer.nextToken();
            values.add(this.exprParser.primary());
            this.lexer.nextToken();
        } else if ("schema".equalsIgnoreCase(parameter) || "names".equalsIgnoreCase(parameter)) {
            paramExpr = new SQLIdentifierExpr(parameter);
            this.lexer.nextToken();
            value = this.lexer.stringVal();
            values.add(new SQLCharExpr(value));
            this.lexer.nextToken();
        } else {
            paramExpr = new SQLIdentifierExpr(parameter);
            this.lexer.nextToken();
            while (!this.lexer.isEOF()) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LITERAL_CHARS) {
                    values.add(new SQLCharExpr(this.lexer.stringVal()));
                } else if (this.lexer.token() == Token.LITERAL_INT) {
                    values.add(new SQLIdentifierExpr(this.lexer.numberString()));
                } else if (this.lexer.identifierEquals(FnvHash.Constants.JSON_SET) || this.lexer.identifierEquals(FnvHash.Constants.JSONB_SET)) {
                    SQLExpr json_set = this.exprParser.expr();
                    values.add(json_set);
                } else {
                    values.add(new SQLIdentifierExpr(this.lexer.stringVal()));
                }
                this.lexer.nextToken();
                if (this.lexer.token() != Token.SEMI) continue;
            }
        }
        if (values.size() == 1) {
            valueExpr = (SQLExpr)values.get(0);
        } else {
            SQLListExpr listExpr = new SQLListExpr();
            for (SQLExpr value2 : values) {
                listExpr.addItem(value2);
            }
            valueExpr = listExpr;
        }
        SQLSetStatement stmt = new SQLSetStatement(paramExpr, valueExpr, this.dbType);
        stmt.setUseSet(true);
        stmt.setOption(option);
        return stmt;
    }

    @Override
    public SQLCreateIndexStatement parseCreateIndex() {
        this.accept(Token.CREATE);
        SQLCreateIndexStatement stmt = new SQLCreateIndexStatement(this.getDbType());
        if (this.lexer.token() == Token.UNIQUE) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("CLUSTERED")) {
                this.lexer.nextToken();
                stmt.setType("UNIQUE CLUSTERED");
            } else {
                stmt.setType("UNIQUE");
            }
        } else if (this.lexer.identifierEquals("FULLTEXT")) {
            stmt.setType("FULLTEXT");
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals("NONCLUSTERED")) {
            stmt.setType("NONCLUSTERED");
            this.lexer.nextToken();
        }
        this.accept(Token.INDEX);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CONCURRENTLY)) {
            this.lexer.nextToken();
            stmt.setConcurrently(true);
        }
        if (this.lexer.token() != Token.ON) {
            stmt.setName(this.exprParser.name());
        }
        this.accept(Token.ON);
        stmt.setTable(this.exprParser.name());
        if (this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            String using = this.lexer.stringVal();
            this.accept(Token.IDENTIFIER);
            stmt.setUsing(using);
        }
        this.accept(Token.LPAREN);
        while (true) {
            SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
            if (this.lexer.identifierEquals("jsonb_path_ops") && item.getExpr() instanceof SQLIdentifierExpr) {
                String ident = ((SQLIdentifierExpr)item.getExpr()).getName() + " " + this.lexer.stringVal();
                this.lexer.nextToken();
                item.setExpr(new SQLIdentifierExpr(ident));
            }
            item.setParent(stmt);
            stmt.addItem(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                String optionName = this.lexer.stringVal();
                this.accept(Token.IDENTIFIER);
                this.accept(Token.EQ);
                SQLExpr option = this.exprParser.expr();
                option.setParent(stmt);
                stmt.addOption(optionName, option);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.TABLESPACE) {
            this.lexer.nextToken();
            SQLName tablespace = this.exprParser.name();
            stmt.setTablespace(tablespace);
        }
        return stmt;
    }

    @Override
    public PGCreateTableParser getSQLCreateTableParser() {
        return new PGCreateTableParser(this.exprParser);
    }

    public PGAnalyzeStatement parseAnalyzeTable() {
        PGAnalyzeStatement stmt = new PGAnalyzeStatement(this.dbType);
        this.acceptIdentifier("ANALYZE");
        Lexer.SavePoint mark = this.lexer.mark();
        String strVal = this.lexer.stringVal();
        while (true) {
            if (strVal.equalsIgnoreCase("VERBOSE")) {
                stmt.setVerbose(true);
                this.lexer.nextToken();
                mark = this.lexer.mark();
                strVal = this.lexer.stringVal();
                continue;
            }
            if (!strVal.equalsIgnoreCase("SKIP_LOCKED")) break;
            stmt.setSkipLocked(true);
            this.lexer.nextToken();
            mark = this.lexer.mark();
            strVal = this.lexer.stringVal();
        }
        this.lexer.reset(mark);
        ArrayList<SQLName> names = new ArrayList<SQLName>();
        this.exprParser.names(names, stmt);
        for (SQLName name : names) {
            SQLExprTableSource sqlExprTableSource = new SQLExprTableSource(name);
            sqlExprTableSource.setParent(stmt);
            stmt.getTableSources().add(sqlExprTableSource);
        }
        return stmt;
    }

    public PGVacuumStatement parseVacuumTable() {
        PGVacuumStatement stmt = new PGVacuumStatement(this.dbType);
        this.acceptIdentifier("VACUUM");
        Lexer.SavePoint mark = this.lexer.mark();
        String strVal = this.lexer.stringVal();
        while (true) {
            if (Token.SEMI.equals((Object)this.lexer.token())) {
                stmt.setAfterSemi(true);
                return stmt;
            }
            if (this.lexer.isEOF()) {
                this.lexer.nextToken();
                return stmt;
            }
            if (strVal.equalsIgnoreCase("FULL")) {
                stmt.setFull(true);
                this.lexer.nextToken();
                mark = this.lexer.mark();
                strVal = this.lexer.stringVal();
                continue;
            }
            if (strVal.equalsIgnoreCase("FREEZE")) {
                stmt.setFreeze(true);
                this.lexer.nextToken();
                mark = this.lexer.mark();
                strVal = this.lexer.stringVal();
                continue;
            }
            if (strVal.equalsIgnoreCase("VERBOSE")) {
                stmt.setVerbose(true);
                this.lexer.nextToken();
                mark = this.lexer.mark();
                strVal = this.lexer.stringVal();
                continue;
            }
            if (strVal.equalsIgnoreCase("ANALYZE")) {
                stmt.setAnalyze(true);
                this.lexer.nextToken();
                mark = this.lexer.mark();
                strVal = this.lexer.stringVal();
                continue;
            }
            if (strVal.equalsIgnoreCase("DISABLE_PAGE_SKIPPING")) {
                stmt.setDisablePageSkipping(true);
                this.lexer.nextToken();
                mark = this.lexer.mark();
                strVal = this.lexer.stringVal();
                continue;
            }
            if (strVal.equalsIgnoreCase("SKIP_LOCKED")) {
                stmt.setSkipLocked(true);
                this.lexer.nextToken();
                mark = this.lexer.mark();
                strVal = this.lexer.stringVal();
                continue;
            }
            if (strVal.equalsIgnoreCase("PROCESS_TOAST")) {
                stmt.setProcessToast(true);
                this.lexer.nextToken();
                mark = this.lexer.mark();
                strVal = this.lexer.stringVal();
                continue;
            }
            if (strVal.equalsIgnoreCase("TRUNCATE")) {
                stmt.setTruncate(true);
                this.lexer.nextToken();
                mark = this.lexer.mark();
                strVal = this.lexer.stringVal();
                continue;
            }
            if (strVal.equalsIgnoreCase("DELTAMERGE")) {
                stmt.setDeltaMerge(true);
                this.lexer.nextToken();
                mark = this.lexer.markOut();
                strVal = this.lexer.stringVal();
                continue;
            }
            if (!strVal.equalsIgnoreCase("HDFSDIRECTORY")) break;
            stmt.setHdfsDirectory(true);
            this.lexer.nextToken();
            mark = this.lexer.markOut();
            strVal = this.lexer.stringVal();
        }
        this.lexer.reset(mark);
        ArrayList<SQLName> names = new ArrayList<SQLName>();
        this.exprParser.names(names, stmt);
        for (SQLName name : names) {
            SQLExprTableSource sqlExprTableSource = new SQLExprTableSource(name);
            sqlExprTableSource.setParent(stmt);
            stmt.getTableSources().add(sqlExprTableSource);
        }
        return stmt;
    }

    @Override
    public PGAlterDatabaseStatement alterDatabase() {
        Token valueToken;
        this.accept(Token.ALTER);
        if (!this.lexer.nextIf(Token.SCHEMA)) {
            this.accept(Token.DATABASE);
        }
        PGAlterDatabaseStatement stmt = new PGAlterDatabaseStatement(this.dbType);
        stmt.setDatabaseName(this.exprParser.identifier());
        if ("RENAME".equalsIgnoreCase(this.lexer.stringVal())) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            stmt.setRenameToName(this.exprParser.identifier());
        }
        if ("OWNER".equalsIgnoreCase(this.lexer.stringVal())) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            stmt.setOwnerToName(this.exprParser.identifier());
        }
        if ("REFRESH".equalsIgnoreCase(this.lexer.stringVal())) {
            this.lexer.nextToken();
            this.acceptIdentifier("COLLATION");
            this.acceptIdentifier("VERSION");
            stmt.setRefreshCollationVersion(true);
        }
        if (Token.SET.equals((Object)this.lexer.token())) {
            this.lexer.nextToken();
            if (Token.TABLESPACE.equals((Object)this.lexer.token())) {
                this.lexer.nextToken();
                stmt.setSetTableSpaceName(this.exprParser.identifier());
            } else {
                stmt.setSetParameterName(this.exprParser.identifier());
                if (Token.TO.equals((Object)this.lexer.token())) {
                    this.lexer.nextToken();
                    stmt.setSetParameterValue(this.exprParser.expr());
                } else {
                    this.accept(Token.EQ);
                    stmt.setUseEquals(true);
                    stmt.setSetParameterValue(this.exprParser.expr());
                }
            }
        }
        if ("RESET".equalsIgnoreCase(this.lexer.stringVal())) {
            this.lexer.nextToken();
            stmt.setResetParameterName(this.exprParser.identifier());
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            stmt.setHaveWith(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ALLOW_CONNECTIONS)) {
            this.lexer.nextToken();
            valueToken = this.lexer.token();
            if (valueToken == Token.TRUE) {
                this.lexer.nextToken();
                stmt.setAllowConnections(true);
            } else if (valueToken == Token.FALSE) {
                this.lexer.nextToken();
                stmt.setAllowConnections(false);
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.IS_TEMPLATE)) {
            this.lexer.nextToken();
            valueToken = this.lexer.token();
            if (valueToken == Token.TRUE) {
                this.lexer.nextToken();
                stmt.setSetTemplateMark(true);
            } else if (valueToken == Token.FALSE) {
                this.lexer.nextToken();
                stmt.setSetTemplateMark(false);
            }
        }
        return stmt;
    }

    @Override
    public SQLStatement parseCreateUser() {
        this.accept(Token.CREATE);
        this.accept(Token.USER);
        SQLCreateUserStatement stmt = new SQLCreateUserStatement();
        stmt.setDbType(this.dbType);
        stmt.setUser(this.exprParser.name());
        if (this.lexer.token() == Token.WITH) {
            this.accept(Token.WITH);
            stmt.setPostgresqlWith(true);
        }
        if (this.lexer.identifierEquals("ENCRYPTED")) {
            stmt.setPostgresqlEncrypted(true);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals("PASSWORD")) {
            this.lexer.nextToken();
        }
        stmt.setPassword(this.exprParser.primary());
        return stmt;
    }

    @Override
    protected boolean alterTableAfterNameRest(SQLAlterTableStatement stmt) {
        if (!this.lexer.identifierEquals("CHANGEOWNER") || !this.lexer.identifierEquals("OWNER")) {
            return true;
        }
        this.alterTableOwner(stmt);
        return false;
    }

    @Override
    protected void alterTableAlterComma() {
        if (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
        }
    }

    @Override
    public void parseAlterDropRest(SQLAlterTableStatement stmt, SQLAlterTableDropColumnItem item) {
        item.getColumns().add(this.exprParser.name());
        if (this.lexer.token() == Token.CASCADE) {
            item.setCascade(true);
            this.lexer.nextToken();
        }
        if (Token.RESTRICT == this.lexer.token()) {
            item.setRestrict(true);
            this.lexer.nextToken();
        }
        stmt.addItem(item);
        if (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
        }
    }
}

