/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.remote;

import com.alibaba.nacos.client.config.impl.SpasAdapter;
import com.alibaba.nacos.client.naming.remote.NamingClientProxy;
import com.alibaba.nacos.client.naming.utils.SignUtil;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.client.utils.AppNameUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractNamingClientProxy
implements NamingClientProxy {
    private final SecurityProxy securityProxy;
    private final Properties properties;

    protected AbstractNamingClientProxy(SecurityProxy securityProxy, Properties properties) {
        this.securityProxy = securityProxy;
        this.properties = properties;
    }

    protected Map<String, String> getSecurityHeaders() {
        HashMap<String, String> result = new HashMap<String, String>(1);
        if (StringUtils.isNotBlank(this.securityProxy.getAccessToken())) {
            result.put("accessToken", this.securityProxy.getAccessToken());
        }
        return result;
    }

    protected Map<String, String> getSpasHeaders(String serviceName) {
        HashMap<String, String> result = new HashMap<String, String>(2);
        String ak = this.getAccessKey();
        String sk = this.getSecretKey();
        result.put("app", AppNameUtils.getAppName());
        if (StringUtils.isNotBlank(ak) && StringUtils.isNotBlank(sk)) {
            try {
                String signData = this.getSignData(serviceName);
                String signature = SignUtil.sign(signData, sk);
                result.put("signature", signature);
                result.put("data", signData);
                result.put("ak", ak);
            }
            catch (Exception e) {
                LogUtils.NAMING_LOGGER.error("inject ak/sk failed.", (Throwable)e);
            }
        }
        return result;
    }

    private String getAccessKey() {
        if (this.properties == null) {
            return SpasAdapter.getAk();
        }
        return TemplateUtils.stringEmptyAndThenExecute(this.properties.getProperty("accessKey"), SpasAdapter::getAk);
    }

    private String getSecretKey() {
        if (this.properties == null) {
            return SpasAdapter.getSk();
        }
        return TemplateUtils.stringEmptyAndThenExecute(this.properties.getProperty("secretKey"), SpasAdapter::getSk);
    }

    private String getSignData(String serviceName) {
        return StringUtils.isNotEmpty(serviceName) ? System.currentTimeMillis() + "@@" + serviceName : String.valueOf(System.currentTimeMillis());
    }
}

