/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import com.alibaba.nacos.common.utils.BiFunction;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.Objects;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Map;
import java.util.function.Predicate;

public class MapUtil {
    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Dictionary coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(Map map) {
        return !MapUtil.isEmpty(map);
    }

    public static boolean isNotEmpty(Dictionary coll) {
        return !MapUtil.isEmpty(coll);
    }

    public static void putIfValNoNull(Map target, Object key, Object value) {
        Objects.requireNonNull(key, "key");
        if (value != null) {
            target.put(key, value);
        }
    }

    public static void putIfValNoEmpty(Map target, Object key, Object value) {
        Objects.requireNonNull(key, "key");
        if (value instanceof String) {
            if (StringUtils.isNotEmpty((String)value)) {
                target.put(key, value);
            }
            return;
        }
        if (value instanceof Collection) {
            if (CollectionUtils.isNotEmpty((Collection)value)) {
                target.put(key, value);
            }
            return;
        }
        if (value instanceof Map) {
            if (MapUtil.isNotEmpty((Map)value)) {
                target.put(key, value);
            }
            return;
        }
        if (value instanceof Dictionary) {
            if (MapUtil.isNotEmpty((Dictionary)value)) {
                target.put(key, value);
            }
            return;
        }
    }

    public static <K, C, V, T> V computeIfAbsent(Map<K, V> target, K key, BiFunction<C, T, V> mappingFunction, C param1, T param2) {
        Objects.requireNonNull(target, "target");
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(mappingFunction, "mappingFunction");
        Objects.requireNonNull(param1, "param1");
        Objects.requireNonNull(param2, "param2");
        V val = target.get(key);
        if (val == null) {
            V ret = mappingFunction.apply(param1, param2);
            target.put(key, ret);
            return ret;
        }
        return val;
    }

    public static <K, V> V removeKey(Map<K, V> map, K key, Predicate<V> removeJudge) {
        return (V)map.computeIfPresent(key, (k, v) -> removeJudge.test(v) ? null : v);
    }
}

