/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.address;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.address.AbstractServerListProvider;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.utils.InternetAddressUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class PropertiesListProvider
extends AbstractServerListProvider {
    private static final String FIXED_NAME = "fixed";
    private List<String> serverList;

    @Override
    public void init(NacosClientProperties properties, NacosRestTemplate nacosRestTemplate) throws NacosException {
        super.init(properties, nacosRestTemplate);
        this.serverList = new ArrayList<String>();
        String serverAddrsStr = properties.getProperty("serverAddr");
        StringTokenizer serverAddrsTokens = new StringTokenizer(serverAddrsStr, ",;");
        while (serverAddrsTokens.hasMoreTokens()) {
            String serverAddr = serverAddrsTokens.nextToken().trim();
            if (serverAddr.startsWith("http://") || serverAddr.startsWith("https://")) {
                this.serverList.add(serverAddr);
                continue;
            }
            String[] serverAddrArr = InternetAddressUtil.splitIPPortStr(serverAddr);
            if (serverAddrArr.length == 1) {
                this.serverList.add(serverAddrArr[0] + ":" + ParamUtil.getDefaultServerPort());
                continue;
            }
            this.serverList.add(serverAddr);
        }
    }

    @Override
    public List<String> getServerList() {
        return this.serverList;
    }

    @Override
    public String getServerName() {
        return "fixed-" + (StringUtils.isNotBlank(this.namespace) ? StringUtils.trim(this.namespace) + "-" : "") + ParamUtil.getNameSuffixByServerIps(this.serverList.toArray(new String[0]));
    }

    @Override
    public int getOrder() {
        return 499;
    }

    @Override
    public boolean match(NacosClientProperties properties) {
        return StringUtils.isNotBlank(properties.getProperty("serverAddr"));
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    @Override
    public void shutdown() throws NacosException {
    }
}

