/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.config.server.model.SubscriberStatus;
import com.alibaba.nacos.config.server.service.ClientRecord;
import com.alibaba.nacos.config.server.service.ConfigService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClientTrackService {
    static volatile ConcurrentMap<String, ClientRecord> clientRecords = new ConcurrentHashMap<String, ClientRecord>();

    public static void trackClientMd5(String ip, Map<String, String> clientMd5Map) {
        ClientRecord record = ClientTrackService.getClientRecord(ip);
        record.lastTime = System.currentTimeMillis();
        record.groupKey2md5Map.putAll(clientMd5Map);
    }

    public static void trackClientMd5(String ip, Map<String, String> clientMd5Map, Map<String, Long> clientlastPollingTSMap) {
        ClientRecord record = ClientTrackService.getClientRecord(ip);
        record.lastTime = System.currentTimeMillis();
        record.groupKey2md5Map.putAll(clientMd5Map);
        record.groupKey2pollingTsMap.putAll(clientlastPollingTSMap);
    }

    public static void trackClientMd5(String ip, String groupKey, String clientMd5) {
        ClientRecord record = ClientTrackService.getClientRecord(ip);
        record.lastTime = System.currentTimeMillis();
        record.groupKey2md5Map.put(groupKey, clientMd5);
        record.groupKey2pollingTsMap.put(groupKey, record.lastTime);
    }

    public static int subscribeClientCount() {
        return clientRecords.size();
    }

    public static long subscriberCount() {
        long count = 0L;
        for (ClientRecord record : clientRecords.values()) {
            count += (long)record.groupKey2md5Map.size();
        }
        return count;
    }

    public static Map<String, SubscriberStatus> listSubStatus(String ip) {
        HashMap<String, SubscriberStatus> status = new HashMap<String, SubscriberStatus>(100);
        ClientRecord record = ClientTrackService.getClientRecord(ip);
        if (record == null) {
            return status;
        }
        for (Map.Entry entry : record.groupKey2md5Map.entrySet()) {
            String groupKey = (String)entry.getKey();
            String clientMd5 = (String)entry.getValue();
            long lastPollingTs = (Long)record.groupKey2pollingTsMap.get(groupKey);
            boolean isUpdate = ConfigService.isUptodate(groupKey, clientMd5);
            status.put(groupKey, new SubscriberStatus(groupKey, isUpdate, clientMd5, lastPollingTs));
        }
        return status;
    }

    public static Map<String, SubscriberStatus> listSubsByGroup(String groupKey) {
        HashMap<String, SubscriberStatus> subs = new HashMap<String, SubscriberStatus>(100);
        for (ClientRecord clientRec : clientRecords.values()) {
            String clientMd5 = (String)clientRec.groupKey2md5Map.get(groupKey);
            Long lastPollingTs = (Long)clientRec.groupKey2pollingTsMap.get(groupKey);
            if (null == clientMd5 || lastPollingTs == null) continue;
            Boolean isUpdate = ConfigService.isUptodate(groupKey, clientMd5);
            subs.put(clientRec.ip, new SubscriberStatus(groupKey, isUpdate, clientMd5, lastPollingTs));
        }
        return subs;
    }

    public static Map<String, Boolean> isClientUptodate(String ip) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(100);
        for (Map.Entry entry : ClientTrackService.getClientRecord((String)ip).groupKey2md5Map.entrySet()) {
            String groupKey = (String)entry.getKey();
            String clientMd5 = (String)entry.getValue();
            Boolean isuptodate = ConfigService.isUptodate(groupKey, clientMd5);
            result.put(groupKey, isuptodate);
        }
        return result;
    }

    public static Map<String, Boolean> listSubscriberByGroup(String groupKey) {
        HashMap<String, Boolean> subs = new HashMap<String, Boolean>(100);
        for (ClientRecord clientRec : clientRecords.values()) {
            String clientMd5 = (String)clientRec.groupKey2md5Map.get(groupKey);
            if (null == clientMd5) continue;
            Boolean isuptodate = ConfigService.isUptodate(groupKey, clientMd5);
            subs.put(clientRec.ip, isuptodate);
        }
        return subs;
    }

    private static ClientRecord getClientRecord(String clientIp) {
        ClientRecord record = (ClientRecord)clientRecords.get(clientIp);
        if (null != record) {
            return record;
        }
        clientRecords.putIfAbsent(clientIp, new ClientRecord(clientIp));
        return (ClientRecord)clientRecords.get(clientIp);
    }

    public static void refreshClientRecord() {
        clientRecords = new ConcurrentHashMap<String, ClientRecord>(50);
    }
}

