/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.jdk.httpclient.implementation.AzureJdkHttpRequest;
import com.azure.core.http.jdk.httpclient.implementation.ByteArrayTimeoutResponseSubscriber;
import com.azure.core.http.jdk.httpclient.implementation.JdkHttpResponseAsync;
import com.azure.core.http.jdk.httpclient.implementation.JdkHttpResponseSync;
import com.azure.core.http.jdk.httpclient.implementation.JdkHttpUtils;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

class JdkHttpClient
implements HttpClient {
    private static final ClientLogger LOGGER = new ClientLogger(JdkHttpClient.class);
    private final java.net.http.HttpClient jdkHttpClient;
    private final Set<String> restrictedHeaders;
    private final Duration writeTimeout;
    private final Duration responseTimeout;
    private final Duration readTimeout;
    private final boolean hasReadTimeout;

    JdkHttpClient(java.net.http.HttpClient httpClient, Set<String> restrictedHeaders, Duration writeTimeout, Duration responseTimeout, Duration readTimeout) {
        this.jdkHttpClient = httpClient;
        int javaVersion = JdkHttpClient.getJavaVersion();
        if (javaVersion <= 11) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("JdkAsyncHttpClient is not supported in Java version 11 and below."));
        }
        this.restrictedHeaders = restrictedHeaders;
        LOGGER.verbose("Effective restricted headers: {}", new Object[]{restrictedHeaders});
        this.writeTimeout = writeTimeout != null && !writeTimeout.isNegative() && !writeTimeout.isZero() ? writeTimeout : null;
        this.responseTimeout = responseTimeout != null && !responseTimeout.isNegative() && !responseTimeout.isZero() ? responseTimeout : null;
        this.readTimeout = readTimeout;
        this.hasReadTimeout = readTimeout != null && !readTimeout.isNegative() && !readTimeout.isZero();
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        return this.send(request, Context.NONE);
    }

    public Mono<HttpResponse> send(HttpRequest request, Context context) {
        boolean eagerlyReadResponse = context.getData((Object)"azure-eagerly-read-response").orElse(false);
        boolean ignoreResponseBody = context.getData((Object)"azure-ignore-response-body").orElse(false);
        Duration readTimeout = (Duration)context.getData((Object)"azure-response-timeout").filter(timeoutDuration -> timeoutDuration instanceof Duration).orElse(this.readTimeout);
        Mono jdkRequestMono = Mono.fromCallable(() -> this.toJdkHttpRequest(request, context));
        if (eagerlyReadResponse || ignoreResponseBody) {
            HttpResponse.BodyHandler bodyHandler = JdkHttpClient.getResponseHandler(this.hasReadTimeout, readTimeout, HttpResponse.BodyHandlers::ofByteArray, ByteArrayTimeoutResponseSubscriber::new);
            return jdkRequestMono.flatMap(jdkRequest -> Mono.fromCompletionStage(this.jdkHttpClient.sendAsync((java.net.http.HttpRequest)jdkRequest, bodyHandler))).map(jdkResponse -> {
                HttpHeaders headers = JdkHttpUtils.fromJdkHttpHeaders(jdkResponse.headers());
                int statusCode = jdkResponse.statusCode();
                return new JdkHttpResponseSync(request, statusCode, headers, (byte[])jdkResponse.body());
            });
        }
        return jdkRequestMono.flatMap(jdkRequest -> Mono.fromCompletionStage(this.jdkHttpClient.sendAsync((java.net.http.HttpRequest)jdkRequest, HttpResponse.BodyHandlers.ofPublisher()))).map(jdkResponse -> new JdkHttpResponseAsync(request, readTimeout, this.hasReadTimeout, (java.net.http.HttpResponse<Flow.Publisher<List<ByteBuffer>>>)jdkResponse));
    }

    public HttpResponse sendSync(HttpRequest request, Context context) {
        boolean eagerlyReadResponse = context.getData((Object)"azure-eagerly-read-response").orElse(false);
        boolean ignoreResponseBody = context.getData((Object)"azure-ignore-response-body").orElse(false);
        java.net.http.HttpRequest jdkRequest = this.toJdkHttpRequest(request, context);
        try {
            if (eagerlyReadResponse || ignoreResponseBody) {
                HttpResponse.BodyHandler bodyHandler = JdkHttpClient.getResponseHandler(this.hasReadTimeout, this.readTimeout, HttpResponse.BodyHandlers::ofByteArray, ByteArrayTimeoutResponseSubscriber::new);
                java.net.http.HttpResponse jdKResponse = this.jdkHttpClient.send(jdkRequest, bodyHandler);
                return new JdkHttpResponseSync(request, jdKResponse.statusCode(), JdkHttpUtils.fromJdkHttpHeaders(jdKResponse.headers()), (byte[])jdKResponse.body());
            }
            return new JdkHttpResponseSync(request, this.jdkHttpClient.send(jdkRequest, HttpResponse.BodyHandlers.ofInputStream()), this.readTimeout);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
        catch (InterruptedException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    private java.net.http.HttpRequest toJdkHttpRequest(HttpRequest request, Context context) {
        return new AzureJdkHttpRequest(request, context, this.restrictedHeaders, LOGGER, this.writeTimeout, this.responseTimeout);
    }

    private static int getJavaVersion() {
        return Runtime.version().feature();
    }

    private static <T> HttpResponse.BodyHandler<T> getResponseHandler(boolean hasReadTimeout, Duration readTimeout, Supplier<HttpResponse.BodyHandler<T>> jdkBodyHandler, Function<Long, HttpResponse.BodySubscriber<T>> timeoutSubscriber) {
        return hasReadTimeout ? responseInfo -> (HttpResponse.BodySubscriber)timeoutSubscriber.apply(readTimeout.toMillis()) : jdkBodyHandler.get();
    }
}

