/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.junitextensions;

import com.azure.core.test.TestMode;
import com.azure.core.test.annotation.PlaybackOnly;
import com.azure.core.test.implementation.TestingHelpers;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class PlaybackOnlyExtension
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        PlaybackOnly playbackOnly = AnnotationSupport.findAnnotation((Optional)context.getElement(), PlaybackOnly.class).orElse(null);
        if (playbackOnly != null) {
            PlaybackOnlyExtension.validateExpiryTime(playbackOnly);
            TestMode testMode = TestingHelpers.getTestMode();
            return testMode != TestMode.PLAYBACK ? ConditionEvaluationResult.disabled((String)("PlaybackOnly annotation set and test ignored in " + (Object)((Object)testMode))) : ConditionEvaluationResult.enabled((String)("PlaybackOnly annotation set and test enabled in " + (Object)((Object)testMode)));
        }
        return ConditionEvaluationResult.enabled((String)"PlaybackOnly annotation not set.");
    }

    private static void validateExpiryTime(PlaybackOnly annotation) {
        String expiryStr = annotation.expiryTime();
        if ("".equals(expiryStr)) {
            return;
        }
        LocalDate expiry = LocalDate.parse(expiryStr, DateTimeFormatter.ISO_LOCAL_DATE);
        LocalDate now = LocalDate.now();
        if (now.isAfter(expiry)) {
            throw new RuntimeException("PlaybackOnly has expired. Test must be re-enabled");
        }
    }
}

