/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content;

import com.box.androidsdk.content.BoxApi;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.requests.BoxRequestsBookmark;

public class BoxApiBookmark
extends BoxApi {
    public BoxApiBookmark(BoxSession session) {
        super(session);
    }

    protected String getBookmarksUrl() {
        return String.format("%s/web_links", this.getBaseUri());
    }

    protected String getBookmarkInfoUrl(String id) {
        return String.format("%s/%s", this.getBookmarksUrl(), id);
    }

    protected String getBookmarkCopyUrl(String id) {
        return String.format(this.getBookmarkInfoUrl(id) + "/copy", new Object[0]);
    }

    protected String getTrashedBookmarkUrl(String id) {
        return this.getBookmarkInfoUrl(id) + "/trash";
    }

    protected String getBookmarkCommentsUrl(String id) {
        return this.getBookmarkInfoUrl(id) + "/comments";
    }

    protected String getCommentUrl() {
        return this.getBaseUri() + "/comments";
    }

    public BoxRequestsBookmark.GetBookmarkInfo getInfoRequest(String id) {
        BoxRequestsBookmark.GetBookmarkInfo request = new BoxRequestsBookmark.GetBookmarkInfo(id, this.getBookmarkInfoUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsBookmark.CreateBookmark getCreateRequest(String parentId, String url) {
        BoxRequestsBookmark.CreateBookmark request = new BoxRequestsBookmark.CreateBookmark(parentId, url, this.getBookmarksUrl(), this.mSession);
        return request;
    }

    public BoxRequestsBookmark.UpdateBookmark getUpdateRequest(String id) {
        BoxRequestsBookmark.UpdateBookmark request = new BoxRequestsBookmark.UpdateBookmark(id, this.getBookmarkInfoUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsBookmark.CopyBookmark getCopyRequest(String id, String parentId) {
        BoxRequestsBookmark.CopyBookmark request = new BoxRequestsBookmark.CopyBookmark(id, parentId, this.getBookmarkCopyUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsBookmark.UpdateBookmark getRenameRequest(String id, String newName) {
        BoxRequestsBookmark.UpdateBookmark request = new BoxRequestsBookmark.UpdateBookmark(id, this.getBookmarkInfoUrl(id), this.mSession);
        request.setName(newName);
        return request;
    }

    public BoxRequestsBookmark.UpdateBookmark getMoveRequest(String id, String parentId) {
        BoxRequestsBookmark.UpdateBookmark request = new BoxRequestsBookmark.UpdateBookmark(id, this.getBookmarkInfoUrl(id), this.mSession);
        request.setParentId(parentId);
        return request;
    }

    public BoxRequestsBookmark.DeleteBookmark getDeleteRequest(String id) {
        BoxRequestsBookmark.DeleteBookmark request = new BoxRequestsBookmark.DeleteBookmark(id, this.getBookmarkInfoUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsBookmark.UpdateSharedBookmark getCreateSharedLinkRequest(String id) {
        BoxRequestsBookmark.UpdateSharedBookmark request = (BoxRequestsBookmark.UpdateSharedBookmark)new BoxRequestsBookmark.UpdateSharedBookmark(id, this.getBookmarkInfoUrl(id), this.mSession).setAccess(null);
        return request;
    }

    public BoxRequestsBookmark.UpdateBookmark getDisableSharedLinkRequest(String id) {
        BoxRequestsBookmark.UpdateBookmark request = (BoxRequestsBookmark.UpdateBookmark)new BoxRequestsBookmark.UpdateBookmark(id, this.getBookmarkInfoUrl(id), this.mSession).setSharedLink(null);
        return request;
    }

    public BoxRequestsBookmark.AddCommentToBookmark getAddCommentRequest(String bookmarkId, String message) {
        BoxRequestsBookmark.AddCommentToBookmark request = new BoxRequestsBookmark.AddCommentToBookmark(bookmarkId, message, this.getCommentUrl(), this.mSession);
        return request;
    }

    public BoxRequestsBookmark.GetTrashedBookmark getTrashedBookmarkRequest(String id) {
        BoxRequestsBookmark.GetTrashedBookmark request = new BoxRequestsBookmark.GetTrashedBookmark(id, this.getTrashedBookmarkUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsBookmark.DeleteTrashedBookmark getDeleteTrashedBookmarkRequest(String id) {
        BoxRequestsBookmark.DeleteTrashedBookmark request = new BoxRequestsBookmark.DeleteTrashedBookmark(id, this.getTrashedBookmarkUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsBookmark.RestoreTrashedBookmark getRestoreTrashedBookmarkRequest(String id) {
        BoxRequestsBookmark.RestoreTrashedBookmark request = new BoxRequestsBookmark.RestoreTrashedBookmark(id, this.getBookmarkInfoUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsBookmark.GetBookmarkComments getCommentsRequest(String id) {
        BoxRequestsBookmark.GetBookmarkComments request = new BoxRequestsBookmark.GetBookmarkComments(id, this.getBookmarkCommentsUrl(id), this.mSession);
        return request;
    }

    public BoxRequestsBookmark.AddBookmarkToCollection getAddToCollectionRequest(String bookmarkId, String collectionId) {
        BoxRequestsBookmark.AddBookmarkToCollection request = new BoxRequestsBookmark.AddBookmarkToCollection(bookmarkId, collectionId, this.getBookmarkInfoUrl(bookmarkId), this.mSession);
        return request;
    }

    public BoxRequestsBookmark.DeleteBookmarkFromCollection getDeleteFromCollectionRequest(String id) {
        BoxRequestsBookmark.DeleteBookmarkFromCollection request = new BoxRequestsBookmark.DeleteBookmarkFromCollection(id, this.getBookmarkInfoUrl(id), this.mSession);
        return request;
    }
}

