/*
 * Decompiled with CFR 0.152.
 */
package com.box.androidsdk.content;

import com.box.androidsdk.content.BoxApi;
import com.box.androidsdk.content.models.BoxCollaboration;
import com.box.androidsdk.content.models.BoxCollaborator;
import com.box.androidsdk.content.models.BoxSession;
import com.box.androidsdk.content.requests.BoxRequestsShare;

public class BoxApiCollaboration
extends BoxApi {
    protected String getCollaborationsUrl() {
        return String.format("%s/collaborations", this.getBaseUri());
    }

    protected String getCollaborationInfoUrl(String id) {
        return String.format("%s/%s", this.getCollaborationsUrl(), id);
    }

    public BoxApiCollaboration(BoxSession session) {
        super(session);
    }

    public BoxRequestsShare.GetCollaborationInfo getInfoRequest(String collaborationId) {
        BoxRequestsShare.GetCollaborationInfo collab = new BoxRequestsShare.GetCollaborationInfo(collaborationId, this.getCollaborationInfoUrl(collaborationId), this.mSession);
        return collab;
    }

    public BoxRequestsShare.AddCollaboration getAddRequest(String folderId, BoxCollaboration.Role role, BoxCollaborator collaborator) {
        BoxRequestsShare.AddCollaboration collab = new BoxRequestsShare.AddCollaboration(this.getCollaborationsUrl(), folderId, role, collaborator, this.mSession);
        return collab;
    }

    public BoxRequestsShare.AddCollaboration getAddRequest(String folderId, BoxCollaboration.Role role, String login) {
        BoxRequestsShare.AddCollaboration collab = new BoxRequestsShare.AddCollaboration(this.getCollaborationsUrl(), folderId, role, login, this.mSession);
        return collab;
    }

    public BoxRequestsShare.GetPendingCollaborations getPendingCollaborationsRequest() {
        BoxRequestsShare.GetPendingCollaborations request = new BoxRequestsShare.GetPendingCollaborations(this.getCollaborationsUrl(), this.mSession);
        return request;
    }

    public BoxRequestsShare.DeleteCollaboration getDeleteRequest(String collaborationId) {
        BoxRequestsShare.DeleteCollaboration collab = new BoxRequestsShare.DeleteCollaboration(collaborationId, this.getCollaborationInfoUrl(collaborationId), this.mSession);
        return collab;
    }

    public BoxRequestsShare.UpdateCollaboration getUpdateRequest(String collaborationId) {
        BoxRequestsShare.UpdateCollaboration collab = new BoxRequestsShare.UpdateCollaboration(collaborationId, this.getCollaborationInfoUrl(collaborationId), this.mSession);
        return collab;
    }
}

